<?php

/* ==================================================== 
* COPYRIGHT 2010 by Половенко Максим (aka SPunk)
* ==================================================== 
* ПРОДУКТ : Скрипт граббера погоды с сайта Yandex.ru
* E-MAIL : punk-az@mail.ru
* ==================================================== */

class weather {
    private $grabb_url;
    private $file_path;
    private $id_city;
    private $life_time;

    public function __construct()
    {
        $configs = func_get_args();
        extract($configs[0], EXTR_PREFIX_ALL, 'conf');

        $this->id_city = isset($conf_id_city) ? (int) $conf_id_city : 30509;
        $this->life_time = isset($conf_life_time) ? (int) $conf_life_time : 3;
        $this->file_path = isset($conf_file_path) ? $conf_file_path : 'temp/' . $this->id_city . '_weather.xml';
        $this->grabb_url = isset($conf_grabb_url) ? $conf_grabb_url : 'http://export.yandex.ru/weather/?city=';
    } 

    private function cache_file()
    {
        $time_created = time() - @filemtime($this->file_path);

        if (!file_exists($this->file_path) || $time_created > $this->life_time) {
            $weather = file_get_contents($this->grabb_url . $this->id_city);
            $handle = fopen($this->file_path, "w");

            fwrite($handle, $weather);
            fclose($handle);
            return true;
        } else {
            return false;
        } 
    } 

    private function parse()
    {
        $weather = file($this->file_path);
        $object = simplexml_load_string(implode('', $weather));
        $object->image = str_replace('http://weather.yandex.ru/i/', '', $object->image);
        unset($object->image2);

        return (object) $object;
    } 

    public function get_data()
    {
        $this->cache_file();
        return $this->parse();
    } 
} 

?>