# SQL Manager 2005 for MySQL 3.6.5.1
# ---------------------------------------
# Host     : 192.168.0.9
# Port     : 3306
# Database : smartex


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES cp1251 */;

SET FOREIGN_KEY_CHECKS=0;

#
# Structure for the `administrators` table : 
#

CREATE TABLE `administrators` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `login` varchar(255) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `balance_history` table : 
#

CREATE TABLE `balance_history` (
  `id` int(11) NOT NULL auto_increment,
  `ex_currency_id` int(11) NOT NULL default '0',
  `change_amount` decimal(10,6) NOT NULL default '0.000000',
  `comments` text NOT NULL,
  `balance` decimal(10,6) NOT NULL default '0.000000',
  `date` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `banners` table : 
#

CREATE TABLE `banners` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(45) default NULL,
  `html_code` text,
  `status` int(2) default NULL,
  `js_code` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `client_pages` table : 
#

CREATE TABLE `client_pages` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `pseudo_name` varchar(50) default NULL,
  `browser_title` varchar(255) default NULL,
  `page_title` varchar(255) default NULL,
  `content` text,
  `is_default` tinyint(4) default NULL,
  `type` tinyint(4) default NULL,
  `parent_id` bigint(20) default NULL,
  `template_id` bigint(20) default NULL,
  `status` tinyint(4) default NULL,
  PRIMARY KEY  (`id`),
  KEY `client_pages_parent_FK` (`parent_id`),
  CONSTRAINT `FK_client_pages_parent` FOREIGN KEY (`parent_id`) REFERENCES `client_pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `countries` table : 
#

CREATE TABLE `countries` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `full_name` varchar(255) default NULL,
  `fips_code` char(3) default NULL,
  `capital` varchar(255) default NULL,
  `code` char(3) default NULL,
  `name_rus` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `clients` table : 
#

CREATE TABLE `clients` (
  `id` bigint(20) NOT NULL auto_increment,
  `email` varchar(255) default NULL,
  `password` varchar(32) default NULL,
  `first_name` varchar(255) default NULL,
  `last_name` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `country_id` bigint(20) default NULL,
  `icq` varchar(50) default NULL,
  `phone` varchar(50) NOT NULL,
  `passport` text NOT NULL,
  `amount` decimal(10,2) NOT NULL default '0.00',
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `idx_client_email` (`email`),
  KEY `clients_countries_FK` (`country_id`),
  CONSTRAINT `FK_clients_countries` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `client_sessions` table : 
#

CREATE TABLE `client_sessions` (
  `id` bigint(20) NOT NULL auto_increment,
  `client_id` bigint(20) default NULL,
  `logindate` bigint(20) default NULL,
  `logoutdate` bigint(20) default NULL,
  `ip` varchar(15) default NULL,
  `user_agent` text,
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `client_sessions_FK` (`client_id`),
  KEY `clsess_ip` (`status`,`ip`),
  CONSTRAINT `FK_client_sessions` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `courses` table : 
#

CREATE TABLE `courses` (
  `id` int(11) NOT NULL auto_increment,
  `val1_id` int(11) NOT NULL default '0',
  `val1_number` int(11) NOT NULL default '0',
  `val2_id` int(11) NOT NULL default '0',
  `val2_number` int(11) NOT NULL default '0',
  `course` decimal(10,6) NOT NULL default '0.000000',
  `back_course` decimal(10,6) NOT NULL default '0.000000',
  `date` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `currencies` table : 
#

CREATE TABLE `currencies` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `country_id` int(11) NOT NULL default '0',
  `code` varchar(10) NOT NULL default '',
  `symbol` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `ebullion_orders` table : 
#

CREATE TABLE `ebullion_orders` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `payee_account` varchar(255) NOT NULL default '',
  `payer_account` varchar(255) NOT NULL default '',
  `transaction_id` varchar(255) NOT NULL default '',
  `metal` tinyint(3) unsigned NOT NULL default '0',
  `exchange` float unsigned NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL default '0',
  `type` tinyint(3) unsigned NOT NULL default '0',
  `status` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `egold_orders` table : 
#

CREATE TABLE `egold_orders` (
  `id` int(11) NOT NULL auto_increment,
  `payee_account` varchar(255) NOT NULL default '',
  `payment_metal_id` smallint(6) NOT NULL default '0',
  `payment_batch_num` varchar(255) NOT NULL default '',
  `payer_account` varchar(255) NOT NULL default '',
  `actual_payment_ounces` decimal(10,6) NOT NULL default '0.000000',
  `usd_per_ounce` decimal(10,2) NOT NULL default '0.00',
  `feeweight` decimal(10,6) NOT NULL default '0.000000',
  `timestampgmt` int(11) NOT NULL default '0',
  `error` text NOT NULL,
  `type` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `email_templates` table : 
#

CREATE TABLE `email_templates` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `code` varchar(50) default NULL,
  `format` enum('text','html') default 'html',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `email_tpl` table : 
#

CREATE TABLE `email_tpl` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `from_who` varchar(255) default NULL,
  `subject` varchar(255) default NULL,
  `body` text,
  `code` varchar(50) default NULL,
  `format` varchar(4) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `eport_orders` table : 
#

CREATE TABLE `eport_orders` (
  `id` int(11) NOT NULL auto_increment,
  `shop_id` int(11) NOT NULL default '0',
  `payer_account` varchar(255) NOT NULL default '',
  `payee_account` varchar(255) NOT NULL default '',
  `eport_order_id` varchar(255) NOT NULL default '',
  `sum_eye` decimal(10,2) NOT NULL default '0.00',
  `sum_rur` decimal(10,2) NOT NULL default '0.00',
  `type` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `ex_currencies` table : 
#

CREATE TABLE `ex_currencies` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `code` varchar(100) NOT NULL default '',
  `country_id` int(11) NOT NULL default '0',
  `currency_id` int(11) NOT NULL default '0',
  `metal_id` int(11) NOT NULL default '0',
  `url` varchar(255) NOT NULL default '',
  `regdate` int(11) NOT NULL default '0',
  `position` int(11) NOT NULL default '0',
  `amount` decimal(15,6) NOT NULL default '0.000000',
  `comission_min` decimal(10,6) NOT NULL default '0.000000',
  `who_pay_comission` smallint(6) NOT NULL default '0',
  `precision` smallint(6) NOT NULL default '0',
  `type` enum('ordinary','pincode') NOT NULL default 'ordinary',
  `pincode_collection_id` smallint(5) unsigned NOT NULL default '0',
  `transfare_type` enum('auto','manual','pincode') NOT NULL default 'auto',
  `manual_properties` varchar(255) NOT NULL default '',
  `symbol` varchar(10) default NULL,
  `input` smallint(6) default NULL,
  `output` smallint(6) default NULL,
  `status` smallint(6) NOT NULL default '0',
  `payment_system_comission_perc` decimal(11,6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `FK_ex_currencies_currencies` (`currency_id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251 COMMENT='Exchanger currencies';

#
# Structure for the `ex_currency_comissions` table : 
#

CREATE TABLE `ex_currency_comissions` (
  `id` int(11) NOT NULL auto_increment,
  `ex_currency_id` int(11) NOT NULL default '0',
  `amount_from` decimal(10,6) NOT NULL default '0.000000',
  `amount_to` decimal(10,6) NOT NULL default '0.000000',
  `perc` decimal(10,6) NOT NULL default '0.000000',
  `fix` decimal(10,6) NOT NULL default '0.000000',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `ex_exchanges` table : 
#

CREATE TABLE `ex_exchanges` (
  `id` int(11) NOT NULL auto_increment,
  `ex_currency1_id` int(11) NOT NULL default '0',
  `ex_currency2_id` int(11) NOT NULL default '0',
  `sys_comission_perc` decimal(10,6) NOT NULL default '0.000000',
  `sys_comission_fix` decimal(10,6) NOT NULL default '0.000000',
  `sys_comission_min` decimal(10,6) NOT NULL default '0.000000',
  `min_amount` decimal(10,6) NOT NULL default '0.000000',
  `max_amount` decimal(10,6) NOT NULL default '0.000000',
  `status` smallint(6) NOT NULL default '0',
  `unq` varchar(64) NOT NULL default '',
  `course` decimal(15,6) default '0.000000',
  `init_value_form` enum('in','out') default 'in',
  `init_value_in` decimal(11,6) default '0.000000',
  `init_value_out` decimal(11,6) default '0.000000',
  `formula_type` enum('value','formula') default 'formula',
  `formula_value` decimal(15,6) default '0.000000',
  `formula_perc` decimal(11,6) default '0.010000',
  `formula_fix` decimal(11,6) default '0.000000',
  `include_ps_comission` smallint(6) default '1',
  `course_up_date` bigint(20) default NULL,
  `course_up_method` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `exchanger_ads` table : 
#

CREATE TABLE `exchanger_ads` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `html_code` text,
  `status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `exchanger_codes` table : 
#

CREATE TABLE `exchanger_codes` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `html_code` text,
  `status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `faqs` table : 
#

CREATE TABLE `faqs` (
  `id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `answer` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `hashes` table : 
#

CREATE TABLE `hashes` (
  `id` int(11) NOT NULL auto_increment,
  `owner_id` int(11) NOT NULL default '0',
  `type` smallint(6) NOT NULL default '0',
  `hash` varchar(255) NOT NULL default '',
  `regdate` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `lang_objects` table : 
#

CREATE TABLE `lang_objects` (
  `table_name` varchar(255) NOT NULL default '',
  `field_name` varchar(255) NOT NULL default '',
  `lang_id` int(11) NOT NULL default '0',
  `value` text NOT NULL,
  `comment` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=cp1251 COMMENT='Language object links';

#
# Structure for the `langs` table : 
#

CREATE TABLE `langs` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `code` varchar(10) NOT NULL default '',
  `accept_lang` varchar(10) NOT NULL default '',
  `status` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `manual_orders` table : 
#

CREATE TABLE `manual_orders` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `account` varchar(50) NOT NULL default '',
  `type` tinyint(3) unsigned NOT NULL default '0',
  `status` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `merchant_orders` table : 
#

CREATE TABLE `merchant_orders` (
  `id` int(11) NOT NULL auto_increment,
  `merchant_id` int(11) NOT NULL,
  `from_order_id` int(11) NOT NULL default '0',
  `to_order_id` int(11) NOT NULL default '0',
  `email` varchar(255) NOT NULL default '',
  `description` text,
  `ip` varchar(15) NOT NULL default '',
  `ex_currency_from_id` int(11) NOT NULL default '0',
  `ex_currency_to_id` int(11) NOT NULL default '0',
  `amount_from` decimal(10,6) NOT NULL default '0.000000',
  `amount_to` decimal(10,6) NOT NULL default '0.000000',
  `sys_comission` decimal(10,6) NOT NULL default '0.000000',
  `ex_currency_from_comission` decimal(10,6) NOT NULL default '0.000000',
  `ex_currency_to_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_amount_from` decimal(10,6) NOT NULL default '0.000000',
  `metal_amount_to` decimal(10,6) NOT NULL default '0.000000',
  `metal_sys_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_ex_currency_from_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_ex_currency_to_comission` decimal(10,6) NOT NULL default '0.000000',
  `from_info` text NOT NULL,
  `to_info` text NOT NULL,
  `batch_from` varchar(255) NOT NULL default '',
  `batch_to` varchar(255) NOT NULL default '',
  `regdate` varchar(255) NOT NULL default '',
  `type` smallint(6) NOT NULL default '0',
  `from_status` smallint(6) NOT NULL default '0',
  `to_status` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  `merchant_order_id` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `marchant` (`merchant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `merchant_users` table : 
#

CREATE TABLE `merchant_users` (
  `id` int(11) NOT NULL auto_increment,
  `email` varchar(255) default NULL,
  `password` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `last_name` varchar(255) default NULL,
  `p_name` varchar(255) default NULL,
  `passport_series` varchar(32) default NULL,
  `passport_number` varchar(32) default NULL,
  `site_name` varchar(255) default NULL,
  `site_url` text,
  `ex_currency_id` int(11) default NULL,
  `purse` varchar(255) default NULL,
  `purse_serial` varchar(255) default NULL,
  `secret_word` varchar(255) default NULL,
  `notification_url` text,
  `notification_method` smallint(6) default NULL,
  `success_url` text,
  `success_method` text,
  `failure_url` text,
  `failure_method` text,
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `metal_prices` table : 
#

CREATE TABLE `metal_prices` (
  `id` int(11) NOT NULL auto_increment,
  `metal_id` int(11) NOT NULL default '0',
  `currency_id` int(11) NOT NULL default '0',
  `price` decimal(10,6) NOT NULL default '0.000000',
  `date` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251 COMMENT='Metal cources';

#
# Structure for the `metals` table : 
#

CREATE TABLE `metals` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `code` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `news` table : 
#

CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `date` int(11) default NULL,
  `title` varchar(255) NOT NULL default '',
  `text` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `offline_payment_methods` table : 
#

CREATE TABLE `offline_payment_methods` (
  `id` bigint(20) NOT NULL auto_increment,
  `currency_id` bigint(20) default NULL,
  `name` varchar(255) default NULL,
  `who_pay_comission` smallint(6) default NULL,
  `code` varchar(255) default NULL,
  `symbol` varchar(255) default NULL,
  `position` bigint(20) default NULL,
  `precision` smallint(6) NOT NULL default '2',
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `FK_ex_currency_currencies` (`currency_id`),
  CONSTRAINT `FK_ex_currency_currencies` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `offline_exchange_ways` table : 
#

CREATE TABLE `offline_exchange_ways` (
  `id` bigint(20) NOT NULL auto_increment,
  `offline_method_id` bigint(20) default NULL,
  `ex_currency_id` bigint(20) default NULL,
  `sys_comission_perc` decimal(10,6) default NULL,
  `sys_comission_fix` decimal(10,6) default NULL,
  `sys_comission_min` decimal(10,6) default NULL,
  `min_amount` decimal(10,2) default NULL,
  `max_amount` decimal(10,2) default NULL,
  `type` smallint(6) NOT NULL,
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `exchange_ways_currencies_FK` (`ex_currency_id`),
  KEY `exchange_offline_methods_FK` (`offline_method_id`),
  CONSTRAINT `FK_exchange_offline_methods` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `offline_pm_comissions` table : 
#

CREATE TABLE `offline_pm_comissions` (
  `id` bigint(20) NOT NULL auto_increment,
  `offline_pm_id` bigint(20) default NULL,
  `amount_from` decimal(10,6) default NULL,
  `amount_to` decimal(10,6) default NULL,
  `perc` decimal(10,6) default NULL,
  `fix` decimal(10,6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `offline_pm_comissions_FK` (`offline_pm_id`),
  CONSTRAINT `FK_offline_pm_comissions` FOREIGN KEY (`offline_pm_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `orders` table : 
#

CREATE TABLE `orders` (
  `id` int(11) NOT NULL auto_increment,
  `from_order_id` int(11) NOT NULL default '0',
  `to_order_id` int(11) NOT NULL default '0',
  `email` varchar(255) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `ex_currency_from_id` int(11) NOT NULL default '0',
  `ex_currency_to_id` int(11) NOT NULL default '0',
  `amount_from` decimal(10,6) NOT NULL default '0.000000',
  `amount_to` decimal(10,6) NOT NULL default '0.000000',
  `sys_comission` decimal(10,6) NOT NULL default '0.000000',
  `ex_currency_from_comission` decimal(10,6) NOT NULL default '0.000000',
  `ex_currency_to_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_amount_from` decimal(10,6) NOT NULL default '0.000000',
  `metal_amount_to` decimal(10,6) NOT NULL default '0.000000',
  `metal_sys_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_ex_currency_from_comission` decimal(10,6) NOT NULL default '0.000000',
  `metal_ex_currency_to_comission` decimal(10,6) NOT NULL default '0.000000',
  `from_info` text NOT NULL,
  `to_info` text NOT NULL,
  `batch_from` varchar(255) NOT NULL default '',
  `batch_to` varchar(255) NOT NULL default '',
  `regdate` varchar(255) NOT NULL default '',
  `type` smallint(6) NOT NULL default '0',
  `from_status` smallint(6) NOT NULL default '0',
  `to_status` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  `partner_id` bigint(20) NOT NULL default '0',
  `partner_amount` decimal(10,6) NOT NULL default '0.000000',
  `partner_currency_id` bigint(20) NOT NULL default '0',
  `real_course` decimal(15,6) default '0.000000',
  `ex_course` decimal(15,6) default '0.000000',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `pages` table : 
#

CREATE TABLE `pages` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `title` varchar(255) default NULL,
  `pseudo_name` varchar(100) default NULL,
  `content` text,
  `status` tinyint(4) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partner_ads` table : 
#

CREATE TABLE `partner_ads` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `html_code` text,
  `status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partner_clicks` table : 
#

CREATE TABLE `partner_clicks` (
  `id` int(11) NOT NULL auto_increment,
  `partner_id` int(11) NOT NULL default '0',
  `partner_website_id` int(11) default NULL,
  `ip` varchar(15) default NULL,
  `ip_country_id` int(11) NOT NULL default '0',
  `proxy_ip` varchar(15) default NULL,
  `proxy_country_id` int(11) NOT NULL default '0',
  `proxy_type` tinyint(4) default NULL,
  `regdate` int(11) default NULL,
  `user_agent` text,
  `is_unique` tinyint(4) default NULL,
  `partner_amount` decimal(10,2) default NULL,
  `partner_currency_id` int(11) default NULL,
  `referer` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partner_clicks2orders` table : 
#

CREATE TABLE `partner_clicks2orders` (
  `click_id` int(11) default NULL,
  `order_id` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partner_payouts` table : 
#

CREATE TABLE `partner_payouts` (
  `id` int(11) NOT NULL auto_increment,
  `partner_id` int(11) default NULL,
  `trn_id` bigint(20) default NULL,
  `payout_method_id` int(11) default NULL,
  `amount` decimal(10,2) default NULL,
  `currency_id` int(11) default NULL,
  `partner_amount` decimal(10,2) NOT NULL default '0.00',
  `partner_currency_id` int(11) NOT NULL default '0',
  `regdate` int(11) default NULL,
  `description` text,
  `properties` text,
  `status` tinyint(4) default NULL,
  `payee_purse` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `PARTNER` (`partner_id`),
  KEY `PAYOUT` (`payout_method_id`),
  KEY `CURRENCY` (`currency_id`),
  KEY `partner_currency_id` (`partner_currency_id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partner_transactions` table : 
#

CREATE TABLE `partner_transactions` (
  `id` int(11) NOT NULL auto_increment,
  `partner_id` int(11) default NULL,
  `partner_website_id` int(11) default NULL,
  `description` text,
  `regdate` int(11) default NULL,
  `amount` decimal(10,6) default NULL,
  `currency_id` int(11) default NULL,
  `partner_amount` decimal(10,6) default NULL,
  `partner_currency_id` int(11) default NULL,
  `rest_amount` decimal(10,6) default NULL,
  `rest_currency_id` int(11) default NULL,
  `ref_partner_id` int(11) default NULL,
  `order_id` bigint(20) NOT NULL default '0',
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `partners` table : 
#

CREATE TABLE `partners` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(30) default NULL,
  `password` varchar(32) default NULL,
  `email` varchar(50) default NULL,
  `site_name` varchar(255) default NULL,
  `site_url` varchar(255) default NULL,
  `reg_ip` varchar(15) default NULL,
  `withdraw_properties` text,
  `amount` decimal(10,6) default NULL,
  `regdate` int(11) default NULL,
  `program_type` smallint(6) default NULL,
  `comments` text,
  `trans_notify` tinyint(4) NOT NULL default '0',
  `status` tinyint(4) default NULL,
  `activation_code` varchar(30) NOT NULL default '',
  `currency_id` bigint(20) NOT NULL default '0',
  `payout_perc` varchar(100) NOT NULL default '',
  `ref_partner_id` bigint(20) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `payments` table : 
#

CREATE TABLE `payments` (
  `id` bigint(20) NOT NULL auto_increment,
  `client_id` bigint(20) default NULL,
  `exchange_way_id` bigint(20) default NULL,
  `in_amount` decimal(10,2) default '0.00',
  `out_amount` decimal(10,2) default '0.00',
  `sys_com` decimal(10,6) default '0.000000',
  `ex_from_com` decimal(10,6) NOT NULL,
  `ex_to_com` decimal(10,6) NOT NULL,
  `offline_method_params` text,
  `ex_currency_params` text,
  `pm_params` text NOT NULL,
  `regdate` bigint(20) NOT NULL,
  `status` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `payments_in_ways_FK` (`exchange_way_id`),
  KEY `payments_clients_FK` (`client_id`),
  CONSTRAINT `FK_payments_clients` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `FK_payments_in_ways` FOREIGN KEY (`exchange_way_id`) REFERENCES `offline_exchange_ways` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `pincode_collections` table : 
#

CREATE TABLE `pincode_collections` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `currency_id` smallint(5) unsigned NOT NULL default '0',
  `sell_price` decimal(10,2) unsigned NOT NULL default '0.00',
  `buy_price` decimal(10,2) unsigned NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251 COMMENT=' -';

#
# Structure for the `pincode_orders` table : 
#

CREATE TABLE `pincode_orders` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `pincode` varchar(50) NOT NULL default '',
  `type` tinyint(3) unsigned NOT NULL default '0',
  `status` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `pincodes` table : 
#

CREATE TABLE `pincodes` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `collection_id` smallint(5) unsigned NOT NULL default '0',
  `code` varchar(30) NOT NULL default '',
  `status` enum('valid','used') NOT NULL default 'valid',
  PRIMARY KEY  (`id`),
  KEY `collection_id` (`collection_id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251 COMMENT='-';

#
# Structure for the `system_settings` table : 
#

CREATE TABLE `system_settings` (
  `param_name` varchar(255) NOT NULL default '',
  `param_value` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `system_settings_backup` table : 
#

CREATE TABLE `system_settings_backup` (
  `param_name` varchar(255) NOT NULL default '',
  `param_value` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `turings` table : 
#

CREATE TABLE `turings` (
  `session` varchar(32) NOT NULL,
  `code` varchar(4) NOT NULL,
  `heure` int(11) NOT NULL,
  PRIMARY KEY  (`session`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

#
# Structure for the `wm_orders` table : 
#

CREATE TABLE `wm_orders` (
  `id` int(11) NOT NULL auto_increment,
  `payer_purse` varchar(255) NOT NULL default '',
  `payer_wm` varchar(255) NOT NULL default '',
  `payee_purse` varchar(255) NOT NULL default '',
  `payee_wm` varchar(255) NOT NULL default '',
  `sys_invs_no` varchar(255) NOT NULL default '',
  `sys_trans_no` varchar(255) NOT NULL default '',
  `sys_trans_date` varchar(255) NOT NULL default '',
  `type` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Structure for the `yandex_orders` table : 
#

CREATE TABLE `yandex_orders` (
  `id` int(11) NOT NULL auto_increment,
  `shop_user_id` varchar(255) NOT NULL default '',
  `shop_user_name` varchar(255) NOT NULL default '',
  `shop_cypher` varchar(255) NOT NULL default '',
  `payer_account_id` varchar(255) NOT NULL default '',
  `payer_account` varchar(255) NOT NULL default '',
  `payer_bank` varchar(255) NOT NULL default '',
  `payee_account_id` varchar(255) NOT NULL default '',
  `payee_account` varchar(255) NOT NULL default '',
  `payee_bank` varchar(255) NOT NULL default '',
  `paymentid` varchar(255) NOT NULL default '',
  `paymentcurrency` varchar(255) NOT NULL default '',
  `contractdatetime` varchar(255) NOT NULL default '',
  `authorizationtime` varchar(255) NOT NULL default '',
  `type` smallint(6) NOT NULL default '0',
  `status` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;

#
# Data for the `administrators` table  (LIMIT 0,500)
#

INSERT INTO `administrators` (`id`, `name`, `email`, `login`, `password`, `status`) VALUES 
  (1,'admin','admin@admin.ad','admin','f6fdffe48c908deb0f4c3bd36c032e72',1);

COMMIT;

#
# Data for the `balance_history` table  (LIMIT 0,500)
#

INSERT INTO `balance_history` (`id`, `ex_currency_id`, `change_amount`, `comments`, `balance`, `date`) VALUES 
  (1,1,-5.86,'  WebMoney RUR   .',16.02,1172756800),
  (2,2,-9999.81,'  WebMoney USD   .',0.19,1172756800),
  (3,3,-34,'  WebMoney EUR   .',0,1172756801),
  (4,4,-44,'  WebMoney UAH   .',1,1172756801),
  (5,7,-9.9516,'  E-Gold GOLD(USD)   .',0.0484,1172756803),
  (6,8,-33,'  E-Gold SILVER(USD)   .',0,1172756804),
  (7,9,-0.001,'  E-Gold PLATINUM(USD)   .',0,1172756806),
  (8,1,1.1,'   R304179126687, WM ID 393703328897  .   # 410.',17.12,1172757377),
  (9,1,1.09,'   R304179126687, WM ID 393703328897  .   # 411.',18.21,1172760114),
  (10,7,-0.001586,'   EGold  3845167.   # 411.',0.046814,1172760138),
  (11,1,26.7,'   R304179126687, WM ID 393703328897  .   # 412.',44.91,1172760303),
  (12,7,-0.042985,'   EGold  3845167.   # 412.',0.003829,1172760327),
  (13,7,0.041771,'  E-Gold GOLD(USD)   .',0.0456,1172760407),
  (14,7,0.005101,'   EGold # 3845167  .   # 413.',0.050701,1172760493),
  (15,7,0.410441,'   EGold # 3845167  .   # 414.',0.461142,1172761054),
  (16,7,0.32752,'   EGold # 3845167  .   # 415.',0.788662,1172761911),
  (17,7,0.306058,'   EGold # 3845167  .   # 418.',1.09472,1172763330),
  (18,7,0.22522,'   EGold # 3845167  .   # 419.',1.31994,1172763544),
  (19,7,0.225251,'   EGold # 3845167  .   # 422.',1.545191,1172764104),
  (20,7,0.271596,'   EGold # 3845167  .   # 423.',1.816787,1172764325),
  (21,7,0.264691,'   EGold # 3845167  .   # 425.',2.081478,1172764936),
  (22,7,0.009922,'   EGold # 3845167  .   # 426.',2.0914,1172768547);

COMMIT;

#
# Data for the `banners` table  (LIMIT 0,500)
#

INSERT INTO `banners` (`id`, `name`, `html_code`, `status`, `js_code`) VALUES 
  (1,'   ','<table border=\\\"0\\\" align=\\\"center\\\" width=\\\"200\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" style=\\\"background-color : #FFFFFF;\\\">\r\n<tr><td>\r\n<div align=\\\"center\\\">\r\n<a href=\\\"http://[[SITE_URL]]\\\"><img src=\\\"http://[[SITE_URL]]/imgs/logo.gif\\\" width=\\\"175\\\" height=\\\"70\\\" border=\\\"0\\\" alt=\\\"[[SITE_NAME]]\\\"></a>\r\n<form name=\\\"smartex\\\" method=\\\"post\\\" action=\\\"http://[[SITE_URL]]/get_currency.php\\\">\r\n<input type=\\\"hidden\\\" name=\\\"partner\\\" value=\\\"[[PARTNER_ID]]\\\"/>\r\n<table cellSpacing=0 cellPadding=0 border=0>\r\n<tr><td align=\\\"center\\\">\r\n<font color=\\\"#000000\\\" >:</font><br />\r\n<select name=\\\'curr_out\\\'>\r\n[[SELECT_OUT]]\r\n</select>\r\n</td></tr>\r\n<tr><td align=\\\"center\\\">\r\n<font color=\\\"#000000\\\" >:</font> <br />\r\n<select name=\\\'curr_in\\\'>\r\n[[SELECT_IN]]\r\n</select>\r\n</td></tr>\r\n<tr><td align=\\\"center\\\"><input type=\\\"submit\\\" value=\\\"!\\\">\r\n</td></tr>\r\n</table>\r\n</form>\r\n</div>\r\n</td></tr> </table>',1,'<script src=\"/banners.php?id=1&pid=24\" language=\"javascript\" type=\"text/javascript\"></script>'),
  (2,'   ','<table style=\\\"{border: 1px groove #116699;font-size:10;font-family:Verdana;}\\\" align=center border=0 cellpadding=0 cellspacing=0 width=600 bgcolor=\\\"white\\\">\r\n<tr>\r\n\t<td colspan=6 align=center style=\\\"{font-size:15;font-family:Verdana;}\\\" height=35><b>Smartex -   </b></td>\r\n</tr>\r\n<tr bgcolor=\\\"#dcdcdc\\\">\r\n\t<th width=250  height=20 colspan=2 bgcolor=#7499FD><font color=white></font></th>\r\n\t<td width=35  bgcolor=7499FD >&nbsp;</td>\r\n\t<th width=250 colspan=2  bgcolor=#7499FD><font color=white></font></th>\r\n\t<th  bgcolor=7499FD><font color=white> </font></th>\r\n</tr>\r\n_CONTENT_\r\n</table>',1,'<script src=\"/banners.php?id=2&pid=24\" language=\"javascript\" type=\"text/javascript\"></script>'),
  (3,'     - ','<!-- Smartex Code Begin-->\r\n<table align=\\\"center\\\" border=\\\"0\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\" width=\\\"140\\\">\r\n        <tr>\r\n                <td bgcolor=\\\"#008000\\\">\r\n                <table border=\\\"0\\\" cellpadding=\\\"0\\\" cellspacing=\\\"1\\\" width=\\\"60%\\\">\r\n                        <tr>\r\n                                <td bgcolor=\\\"#FFFFFF\\\">\r\n                                <table border=\\\"0\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\r\n                                        \r\n                                        <tr>\r\n                                                <td colspan=\\\"2\\\">\r\n                                                <table border=\\\"0\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\r\n                                                       <tr><td align=\\\"center\\\"><a href=\\\"http://[[SITE_URL]]\\\">[[SITE_NAME]]</a></td></tr> \r\n                                                       <tr>\r\n                                                                <td>\r\n                                                                <p align=\\\"center\\\">\r\n        <font face=\\\"Tahoma\\\"><span style=\\\"font-size: 11px\\\">     :</span></font></td>\r\n                                                        </tr>\r\n                                                        <tr>\r\n                                                                <td>\r\n                                                                <table width=\\\"142\\\">\r\n<form method=\\\"post\\\" action=\\\"http://[[SITE_URL]]/get_currency.php\\\">\r\n<input type=\\\"hidden\\\" name=\\\"partner\\\" value=\\\"[[PARTNER_ID]]\\\" />\r\n <tr>\r\n  <td width=\\\"50%\\\" align=\\\"center\\\"><font face=\\\"Tahoma\\\">\r\n        <span style=\\\"font-size: 11px; font-weight: 700\\\">[[CURR_OUT_AMOUNT]]</span></font>\r\n  </td>\r\n  <td>\r\n   <select id=\\\"curr_out\\\" name=\\\"curr_out\\\">\r\n\t[[SELECT_OUT]]\r\n   </select>\r\n  </td>\r\n </tr>\r\n <tr align=\\\"center\\\">\r\n  <td width=\\\"50%\\\" align=\\\"center\\\"><font face=\\\"Tahoma\\\">\r\n        <span style=\\\"font-size: 11px; font-weight: 700\\\">[[CURR_IN_AMOUNT]]</span></font>\r\n  </td>\r\n  <td>\r\n   <select id=\\\"curr_in\\\" name=\\\"curr_in\\\">\r\n\t[[SELECT_IN]]\r\n   </select>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td colspan=\\\"2\\\" align=\\\"center\\\" width=\\\"100%\\\">\r\n   <input id=\\\"Submite\\\" type=\\\"submit\\\" name=\\\"Submite\\\" value=\\\"!\\\" />\r\n </tr></form>\r\n</table>\r\n                                                                </td>\r\n                                                        </tr>\r\n                                                </table>\r\n                                                </td>\r\n                                        </tr>\r\n                                        </table>\r\n                                </td>\r\n                        </tr>\r\n                </table>\r\n                </td>\r\n        </tr>\r\n</table>\r\n<!-- Smartex Code End-->',1,'<script src=\"/banners.php?id=3&pid=24\" language=\"javascript\" type=\"text/javascript\"></script>');

COMMIT;

#
# Data for the `client_pages` table  (LIMIT 0,500)
#

INSERT INTO `client_pages` (`id`, `name`, `pseudo_name`, `browser_title`, `page_title`, `content`, `is_default`, `type`, `parent_id`, `template_id`, `status`) VALUES 
  (4,'','login','','',NULL,NULL,NULL,NULL,2,1),
  (5,'','logout','','',NULL,NULL,NULL,NULL,0,1),
  (7,' ','system_msg',' ',' ',NULL,NULL,NULL,NULL,3,1),
  (12,' ','payments',' ',' ',NULL,NULL,NULL,NULL,3,1),
  (15,'   ','sessions','   ','   ',NULL,NULL,NULL,NULL,3,1),
  (16,'','home','','',NULL,NULL,NULL,NULL,0,1),
  (19,' ','reg_info',' ',' ',NULL,NULL,NULL,NULL,3,1),
  (24,' ','ad_materials',' ',' ',NULL,NULL,NULL,NULL,NULL,1),
  (25,' ','partner',' ',' ',NULL,NULL,NULL,NULL,0,1),
  (26,' ','description',' ',' ',NULL,NULL,NULL,NULL,3,1),
  (27,'','partner_clicks','','',NULL,NULL,NULL,NULL,3,1),
  (28,'IP info','ip_info','IP info','IP info',NULL,NULL,NULL,NULL,4,1),
  (29,' ','pass_change',' ',' ',NULL,NULL,NULL,NULL,3,1),
  (30,' ','forgot_password',' ',' ',NULL,NULL,NULL,NULL,2,0),
  (31,'   ','partner_transactions','   ','   ',NULL,NULL,NULL,NULL,3,1),
  (32,'','partner_payouts','','',NULL,NULL,NULL,NULL,3,1),
  (33,'','payout','','',NULL,NULL,NULL,NULL,3,1);

COMMIT;

#
# Data for the `countries` table  (LIMIT 0,500)
#

INSERT INTO `countries` (`id`, `name`, `full_name`, `fips_code`, `capital`, `code`, `name_rus`) VALUES 
  (1,'Afghanistan','Islamic State of Afghanistan','AF','Kabul','AFG',''),
  (2,'Albania','Republic of Albania','AL','Tirana','ALB',''),
  (3,'Algeria','Democratic and Popular Republic of Algeria','AG','Algiers','DZA',''),
  (4,'Andorra','Principality of Andorra','AN','Andorra la Vella','AND',''),
  (5,'Angola','Republic of Angola','AO','Luanda','AGO',''),
  (6,'Antigua and Barbuda','(,no long-form name)','AC','Saint John','ATG','  '),
  (7,'Argentina','Argentine Republic','AR','Buenos Aires','ARG',''),
  (8,'Armenia','Republic of Armenia','AM','Yerevan','ARM',''),
  (9,'Australia','Commonwealth of Australia','AS','Canberra','AUS',''),
  (10,'Austria','Republic of Austria','AU','Vienna','AUT',''),
  (11,'Azerbaijan','Azerbaijani Republic','AJ','Baku','AZE',''),
  (12,'Bahamas','Commonwealth of The Bahamas','BF','Nassau','BHS',''),
  (13,'Bahrain','State of Bahrain','BA','Manama','BHR',''),
  (14,'Bangladesh','Peoples Republic of Bangladesh','BG','Dhaka','BGD',''),
  (15,'Barbados','(,no long-form name)','BB','Bridgetown','BRD',''),
  (16,'Belarus','Republic of Belarus','BO','Minsk','BLR',''),
  (17,'Belgium','Kingdom of Belgium','BE','Brussels','BEL',''),
  (18,'Belize','(,no long-form name)','BH','Belmopan','BLZ',''),
  (19,'Benin','Republic of Benin','BN','Porto-Novo','BEN',''),
  (20,'Bhutan','Kingdom of Bhutan','BT','Thimphu','BTN',''),
  (21,'Bolivia','Republic of Bolivia','BL','La Paz (,administrative) Sucre (,legislative/judiciary)','BOL',''),
  (22,'Bosnia and Herzegovina','(,no long-form name)','BK','Sarajevo','BIH','  '),
  (23,'Botswana','Republic of Botswana','BC','Gaborone','BWA',''),
  (24,'Brazil','Federative Republic of Brazil','BR','Bras?lia','BRA',''),
  (25,'Brunei','Negara Brunei Darussalam','BX','Bandar Seri Begawan','BRN',''),
  (26,'Bulgaria','Republic of Bulgaria','BU','Sofia','BGR',''),
  (27,'Burkina Faso','Burkina Faso','UV','Ouagadougou','BFA','-'),
  (28,'Burma','Union of Burma','BM','Rangoon',NULL,''),
  (29,'Burundi','Republic of Burundi','BY','Bujumbura','BDI',''),
  (30,'Cambodia','Kingdom of Cambodia','CB','Phnom Penh','KHM',''),
  (31,'Cameroon','Republic of Cameroon','CM','Yaound?','CMR',''),
  (32,'Canada','(,no long-form name)','CA','Ottawa','CAN',''),
  (33,'Cape Verde','Republic of Cape Verde','CV','Praia',NULL,' '),
  (34,'Central African Republic','Central African Republic','CT','Bangui','CAF',' '),
  (35,'Chad','Republic of Chad','CD','NDjamena','TCD',''),
  (36,'Chile','Republic of Chile','CI','Santiago','CHL',''),
  (37,'China','Peoples Republic of China','CH','Beijing','CHN',''),
  (38,'Colombia','Republic of Colombia','CO','Bogot?','COL',''),
  (39,'Comoros','Federal Islamic Republic of the Comoros','CN','Moroni','COM',' '),
  (40,'Congo (,Brazzaville)','Republic of the Congo','CF','Brazzaville','COG','()'),
  (41,'Congo (,Kinshasa)','Democratic Republic of the Congo','CG','Kinshasa','COG','()'),
  (42,'Costa Rica','Republic of Costa Rica','CS','San Jos?','CRI','-'),
  (44,'Croatia','Republic of Croatia','HR','Zagreb','HRV',''),
  (45,'Cuba','Republic of Cuba','CU','Havana','CUB',''),
  (46,'Cyprus','Republic of Cyprus','CY','Nicosia','CYP',''),
  (47,'Czechia','Czech Republic','EZ','Prague','CZE',''),
  (48,'Denmark','Kingdom of Denmark','DA','Copenhagen','DEU',''),
  (49,'Djibouti','Republic of Djibouti','DJ','Djibouti','DJI',''),
  (50,'Dominica','Commonwealth of Dominica','DO','Roseau','DMA',''),
  (51,'Dominican Republic','Dominican Republic','DR','Santo Domingo','DMA',' '),
  (52,'Ecuador','Republic of Ecuador','EC','Quito','ECU',''),
  (53,'Egypt','Arab Republic of Egypt','EG','Cairo','EGY',''),
  (54,'El Salvador','Republic of El Salvador','ES','San Salvador','SLV',''),
  (55,'Equatorial Guinea','Republic of Equatorial Guinea','EK','Malabo',NULL,' '),
  (56,'Eritrea','State of Eritrea','ER','Asmara',NULL,''),
  (57,'Estonia','Republic of Estonia','EN','Tallinn','EST',''),
  (58,'Ethiopia','Federal Democratic Republic of Ethiopia','ET','Addis Ababa','ETH',''),
  (59,'Fiji','Republic of the Fiji Islands','FJ','Suva','FJI',''),
  (60,'Finland','Republic of Finland','FI','Helsinki','FIN',''),
  (61,'France','French Republic','FR','Paris','FRA',''),
  (62,'Gabon','Gabonese Republic','GB','Libreville','GAB',''),
  (63,'Gambia','Republic of The Gambia','GA','Banjul','GMB',''),
  (64,'Georgia','(,no long-form name)','GG','Tbilisi','GEO',''),
  (65,'Germany','Federal Republic of Germany','GM','Berlin','DEU',''),
  (66,'Ghana','Republic of Ghana','GH','Accra',NULL,''),
  (67,'Greece','Hellenic Republic','GR','Athens','GRC',''),
  (68,'Grenada','(,no long-form name)','GJ','Saint Georges','GRD',''),
  (69,'Guatemala','Republic of Guatemala','GT','Guatemala','GTM',''),
  (70,'Guinea','Republic of Guinea','GV','Conakry','GIN',''),
  (71,'Guinea-Bissau','Republic of Guinea-Bissau','PU','Bissau','GNB','-'),
  (72,'Guyana','Co-operative Republic of Guyana','GY','Georgetown','GUF',''),
  (73,'Haiti','Republic of Haiti','HA','Port-au-Prince','HTI',''),
  (74,'Holy See','Holy See','VT','Vatican City',NULL,''),
  (75,'Honduras','Republic of Honduras','HO','Tegucigalpa','HND',''),
  (76,'Hungary','Republic of Hungary','HU','Budapest','HUN',''),
  (77,'Iceland','Republic of Iceland','IC','Reykjav?k','ISL',''),
  (78,'India','Republic of India','IN','New Delhi','IND',''),
  (79,'Indonesia','Republic of Indonesia','ID','Jakarta','IDN',''),
  (80,'Iran','Islamic Republic of Iran','IR','Tehran','IRN',''),
  (81,'Iraq','Republic of Iraq','IZ','Baghdad','IRQ',''),
  (82,'Ireland','(,no long-form name)','EI','Dublin','IRL',''),
  (83,'Israel','State of Israel','IS','','ISR',''),
  (84,'Italy','Italian Republic','IT','Rome','ITA',''),
  (85,'Jamaica','(,no long-form name)','JM','Kingston','JAM',''),
  (86,'Japan','(,no long-form name)','JA','Tokyo','JPN',''),
  (87,'Jordan','Hashemite Kingdom of Jordan','JO','Amman','JOR',''),
  (88,'Kazakhstan','Republic of Kazakhstan','KZ','Astana','KAZ',''),
  (89,'Kenya','Republic of Kenya','KE','Nairobi','KEN',''),
  (90,'Kiribati','Republic of Kiribati','KR','Tarawa',NULL,''),
  (91,'Korea, North','Democratic Peoples Republic of Korea','KN','Pyongyang','PRK',' '),
  (92,'Korea, South','Republic of Korea','KS','Seoul','PRK',' '),
  (93,'Kuwait','State of Kuwait','KU','Kuwait','KWT',''),
  (94,'Kyrgyzstan','Kyrgyz Republic','KG','Bishkek','KGZ',''),
  (95,'Laos','Lao Peoples Democratic Republic','LA','Vientiane','LAO',''),
  (96,'Latvia','Republic of Latvia','LG','Riga','LVA',''),
  (97,'Lebanon','Lebanese Republic','LE','Beirut',NULL,''),
  (98,'Lesotho','Kingdom of Lesotho','LT','Maseru','LSO',''),
  (99,'Liberia','Republic of Liberia','LI','Monrovia','LBR',''),
  (100,'Libya','Socialist Peoples Libyan Arab Jamahiriya','LY','Tripoli','LBY',''),
  (101,'Liechtenstein','Principality of Liechtenstein','LS','Vaduz','LIE',''),
  (102,'Lithuania','Republic of Lithuania','LH','Vilnius',NULL,''),
  (103,'Luxembourg','Grand Duchy of Luxembourg','LU','Luxembourg','LUX',''),
  (104,'Macedonia','The Former Yugoslav Republic of Macedonia','MK','Skopje','MKD',''),
  (105,'Madagascar','Republic of Madagascar','MA','Antananarivo','MDG',''),
  (106,'Malawi','Republic of Malawi','MI','Lilongwe',NULL,''),
  (107,'Malaysia','(,no long-form name)','MY','Kuala Lumpur','MYS',''),
  (108,'Maldives','Republic of Maldives','MV','Male','MDV',''),
  (109,'Mali','Republic of Mali','ML','Bamako','MLI',''),
  (110,'Malta','(,no long-form name)','MT','Valletta','MLT',''),
  (111,'Marshall Islands','Republic of the Marshall Islands','RM','Majuro','MHL',' '),
  (112,'Mauritania','Islamic Republic of Mauritania','MR','Nouakchott','MRT',''),
  (113,'Mauritius','Republic of Mauritius','MP','Port Louis','MUS',''),
  (114,'Mexico','United Mexican States','MX','Mexico','MEX',''),
  (115,'Micronesia','Federated States of Micronesia','FM','Palikir','FSM',''),
  (116,'Moldova','Republic of Moldova','MD','Chisinau','MDA',''),
  (117,'Monaco','Principality of Monaco','MN','Monaco','MCO',''),
  (118,'Mongolia','(,no long-form name)','MG','Ulaanbaatar','MNG',''),
  (119,'Morocco','Kingdom of Morocco','MO','Rabat','MAR',''),
  (120,'Mozambique','Republic of Mozambique','MZ','Maputo','MOZ',''),
  (121,'Namibia','Republic of Namibia','WA','Windhoek','NAM',''),
  (122,'Nauru','Republic of Nauru','NR','Yaren District (,no capital city)',NULL,''),
  (123,'Nepal','Kingdom of Nepal','NP','Kathmandu','NPN',''),
  (124,'Netherlands','Kingdom of the Netherlands','NL','Amsterdam The Hague (,seat of govt)','NLD',''),
  (125,'New Zealand','(,no long-form name)','NZ','Wellington','NZL',' '),
  (126,'Nicaragua','Republic of Nicaragua','NU','Managua','NIC',''),
  (127,'Niger','Republic of Niger','NG','Niamey','NER',''),
  (128,'Nigeria','Federal Republic of Nigeria','NI','Abuja','NGA',''),
  (129,'Norway','Kingdom of Norway','NO','Oslo','NOR',''),
  (130,'Oman','Sultanate of Oman','MU','Muscat','OMN',''),
  (131,'Pakistan','Islamic Republic of Pakistan','PK','Islamabad','PAK',''),
  (132,'Palau','Republic of Palau','PS','Koror','PLW',''),
  (133,'Panama','Republic of Panama','PM','Panama','PAN',''),
  (134,'Papua New Guinea','Independent State of Papua New Guinea','PP','Port Moresby','PNG','- '),
  (135,'Paraguay','Republic of Paraguay','PA','Asunci?n','PRY',''),
  (136,'Peru','Republic of Peru','PE','Lima','PER',''),
  (137,'Philippines','Republic of the Philippines','RP','Manila','PHL',''),
  (138,'Poland','Republic of Poland','PL','Warsaw','POL',''),
  (139,'Portugal','Portuguese Republic','PO','Lisbon','PRT',''),
  (140,'Qatar','State of Qatar','QA','Doha',NULL,''),
  (141,'Romania','(,no long-form name)','RO','Bucharest','ROM',''),
  (142,'Russia','Russian Federation','RS','Moscow','RUS',''),
  (143,'Rwanda','Rwandese Republic','RW','Kigali','RWA',''),
  (144,'Saint Kitts and Nevis','Federation of Saint Kitts and Nevis','SC','Basseterre',NULL,'-  '),
  (145,'Saint Lucia','(,no long-form name)','ST','Castries',NULL,'-'),
  (146,'Saint Vincent and the Grenadines','(,no long-form name)','VC','Kingstown',NULL,'-   '),
  (147,'Samoa','Independent State of Samoa','WS','Apia','WSM',''),
  (148,'San Marino','Republic of San Marino','SM','San Marino','SMR','-'),
  (149,'Sao Tome and Principe','Democratic Republic of Sao Tome and Principe','TP','S?o Tom?',NULL,'-  '),
  (150,'Saudi Arabia','Kingdom of Saudi Arabia','SA','Riyadh','SAU',' '),
  (151,'Senegal','Republic of Senegal','SG','Dakar','SEN',''),
  (152,'Seychelles','Republic of Seychelles','SE','Victoria','SYC',' '),
  (153,'Sierra Leone','Republic of Sierra Leone','SL','Freetown','SLE','-'),
  (154,'Singapore','Republic of Singapore','SN','Singapore','SGP',''),
  (155,'Slovakia','Slovak Republic','LO','Bratislava','SVK',''),
  (156,'Slovenia','Republic of Slovenia','SI','Ljubljana','SVN',''),
  (157,'Solomon Islands','(,no long-form name)','BP','Honiara','SLB',' '),
  (158,'Somalia','(,no long-form name)','SO','Mogadishu','SOM',''),
  (159,'South Africa','Republic of South Africa','SF','Pretoria (,administrative) Cape Town (,legislative) Bloemfontein (,judiciary)','ZAF',' '),
  (160,'Spain','Kingdom of Spain','SP','Madrid','ESP',''),
  (161,'Sri Lanka','Democratic Socialist Republic of Sri Lanka','CE','Colombo','LKA','-'),
  (162,'Sudan','Republic of the Sudan','SU','Khartoum','SDN',''),
  (163,'Suriname','Republic of Suriname','NS','Paramaribo','SUR',''),
  (164,'Swaziland','Kingdom of Swaziland','WZ','Mbabane (,administrative) Lobamba (,legislative)','SWZ',''),
  (165,'Sweden','Kingdom of Sweden','SW','Stockholm','SWE',''),
  (166,'Switzerland','Swiss Confederation','SZ','Bern','CHE',''),
  (167,'Syria','Syrian Arab Republic','SY','Damascus','SYR',''),
  (168,'Tajikistan','Republic of Tajikistan','TI','Dushanbe',NULL,''),
  (169,'Tanzania','United Republic of Tanzania','TZ','Dar es Salaam Dodoma (,legislative)','TZA',''),
  (170,'Thailand','Kingdom of Thailand','TH','Bangkok','THA',''),
  (171,'Togo','Togolese Republic','TO','Lome','TGO',''),
  (172,'Tonga','Kingdom of Tonga','TN','Nukualofa','TON',''),
  (173,'Trinidad and Tobago','Republic of Trinidad and Tobago','TD','Port-of-Spain','TTO','  '),
  (174,'Tunis','Republic of Tunisia','TS','Tunis','TUN',''),
  (175,'Turkey','Republic of Turkey','TU','Ankara','TUR',''),
  (176,'Turkmenistan','(,no long-form name)','TX','Ashgabat','TKM',''),
  (177,'Tuvalu','(,no long-form name)','TV','Funafuti',NULL,''),
  (178,'Uganda','Republic of Uganda','UG','Kampala','UGA',''),
  (179,'Ukraine','Ukraine','UP','Kiev','UKR',''),
  (180,'United Arab Emirates','United Arab Emirates','TC','Abu Dhabi',NULL,'  '),
  (181,'United Kingdom','United Kingdom of Great Britain and Northern Ireland','UK','London','GBR',''),
  (182,'United States','United States of America','US','Washington DC','USA',''),
  (183,'Uruguay','Oriental Republic of Uruguay','UY','Montevideo','URY',''),
  (184,'Uzbekistan','Republic of Uzbekistan','UZ','Tashkent','UZB',''),
  (185,'Vanuatu','Republic of Vanuatu','NH','Port-Vila','VUT',''),
  (186,'Venezuela','Republic of Venezuela','VE','Caracas','VEN',''),
  (187,'Vietnam','Socialist Republic of Vietnam','VM','Hanoi','VNM',''),
  (188,'Yemen','Republic of Yemen','YM','Sanaa','YMD',''),
  (189,'Zambia','Republic of Zambia','ZA','Lusaka','ZMB',''),
  (190,'Zimbabwe','Republic of Zimbabwe','ZI','Harare','ZWE',''),
  (197,'Euro','Europe','EUR','','EUR',''),
  (198,'International','International',NULL,'International',NULL,'');

COMMIT;

#
# Data for the `clients` table  (LIMIT 0,500)
#

INSERT INTO `clients` (`id`, `email`, `password`, `first_name`, `last_name`, `city`, `country_id`, `icq`, `phone`, `passport`, `amount`, `status`) VALUES 
  (1,'nichi2@mail.ru','202cb962ac59075b964b07152d234b70','SDFSDFSDF','SDFSDF','DDDDDD',9,'12345','','dfsdfsdf\r\nsdfsfsdf\r\n\\\'sdfsf\\\'',0,1),
  (3,'nichi1@mail.ru','b00a50c448238a71ed479f81fa4d9066','','',NULL,NULL,'1234567890','345345','sdsdfsfsf',0,1),
  (4,'mshonich@businessmedia.ru','20ae7674f459ea50edbb2dd673696c13','dsasdasd','qweqwe',NULL,NULL,'1231231','89213955813','adasdaasdlzs dsdlk sa',0,0),
  (5,'az904@mail.ru','bbf81cb7b9e36f1264c17575655ea9e5','jkhj','uyii',NULL,NULL,'','','',0,0);

COMMIT;

#
# Data for the `client_sessions` table  (LIMIT 0,500)
#

INSERT INTO `client_sessions` (`id`, `client_id`, `logindate`, `logoutdate`, `ip`, `user_agent`, `status`) VALUES 
  (1,3,1156604770,1156604770,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (2,3,1156604812,1156605030,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (3,3,1156609888,1156694650,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (4,3,1156694763,1156694774,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (5,3,1156695468,1156695475,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (6,3,1156695500,1156697740,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (7,3,1156698064,1156703509,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (8,3,1156768867,1156768867,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (9,3,1156769405,1156769592,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',1),
  (10,3,1156769668,1156770972,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',1),
  (11,3,1156771084,1156771137,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',1),
  (12,3,1156776982,1156791571,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)',1),
  (13,3,1156847258,1156847268,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',1),
  (14,3,1156847276,1156847392,'80.249.176.66','Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',1);

COMMIT;

#
# Data for the `courses` table  (LIMIT 0,500)
#

INSERT INTO `courses` (`id`, `val1_id`, `val1_number`, `val2_id`, `val2_number`, `course`, `back_course`, `date`) VALUES 
  (67,7,1,1,1,49.8503,0.02006,1154031053),
  (66,6,10,1,1,53.2263,0.018788,1154031053),
  (65,5,1,1,1,34.1713,0.029264,1154031053),
  (64,4,1,1,1,26.8431,0.037254,1154031053),
  (63,7,1,1,1,49.8843,0.020046,1153775711),
  (62,6,10,1,1,53.43,0.018716,1153775711),
  (61,5,1,1,1,34.0136,0.0294,1153775711),
  (60,4,1,1,1,26.9223,0.037144,1153775711),
  (71,7,1,1,1,49.952,0.020019,1154333443),
  (70,6,10,1,1,53.297,0.018763,1154333443),
  (69,5,1,1,1,34.1084,0.029318,1154333443),
  (68,4,1,1,1,26.8718,0.037214,1154333443),
  (56,4,1,1,1,26.8558,0.037236,1152563737),
  (57,5,1,1,1,34.3647,0.0291,1152563737),
  (58,6,10,1,1,53.2621,0.018775,1152563737),
  (59,7,1,1,1,49.7047,0.020119,1152563737),
  (87,6,10,1,1,53.2,0.018797,1154376002),
  (86,5,1,1,1,34.2112,0.02923,1154376002),
  (85,4,1,1,1,26.8197,0.037286,1154376002),
  (84,7,1,1,1,50.0161,0.019994,1154376002),
  (91,6,10,1,1,53.1907,0.0188,1154462403),
  (90,5,1,1,1,34.172,0.029264,1154462403),
  (89,4,1,1,1,26.8416,0.037256,1154462403),
  (88,7,1,1,1,50.0488,0.01998,1154462403),
  (80,7,1,1,1,50.0161,0.019994,1154335202),
  (81,4,1,1,1,26.8197,0.037286,1154335202),
  (82,5,1,1,1,34.2112,0.02923,1154335202),
  (83,6,10,1,1,53.2,0.018797,1154335202),
  (92,7,1,1,1,50.2348,0.019907,1154548803),
  (93,4,1,1,1,26.7605,0.037369,1154548803),
  (94,5,1,1,1,34.3016,0.029153,1154548803),
  (95,6,10,1,1,53.0436,0.018852,1154548803),
  (96,7,1,1,1,50.2816,0.019888,1154635203),
  (97,4,1,1,1,26.804,0.037308,1154635203),
  (98,5,1,1,1,34.2126,0.029229,1154635203),
  (99,6,10,1,1,53.1161,0.018827,1154635203),
  (100,7,1,1,1,50.5008,0.019802,1154721603),
  (101,4,1,1,1,26.771,0.037354,1154721603),
  (102,5,1,1,1,34.2508,0.029196,1154721603),
  (103,6,10,1,1,53.0245,0.018859,1154721603),
  (104,7,1,1,1,50.5008,0.019802,1154808003),
  (105,4,1,1,1,26.771,0.037354,1154808003),
  (106,5,1,1,1,34.2508,0.029196,1154808003),
  (107,6,10,1,1,53.0245,0.018859,1154808003),
  (108,7,1,1,1,50.5008,0.019802,1154894403),
  (109,4,1,1,1,26.771,0.037354,1154894403),
  (110,5,1,1,1,34.2508,0.029196,1154894403),
  (111,6,10,1,1,53.0245,0.018859,1154894403),
  (112,7,1,1,1,50.907,0.019644,1154980803),
  (113,4,1,1,1,26.6962,0.037459,1154980803),
  (114,5,1,1,1,34.3633,0.029101,1154980803),
  (115,6,10,1,1,52.8763,0.018912,1154980803),
  (116,7,1,1,1,50.9485,0.019628,1155067203),
  (117,4,1,1,1,26.7348,0.037404,1155067203),
  (118,5,1,1,1,34.2954,0.029158,1155067203),
  (119,6,10,1,1,52.979,0.018875,1155067203),
  (120,7,1,1,1,51.6258,0.01937,1166866956),
  (121,4,1,1,1,26.2941,0.038031,1166866956),
  (122,5,1,1,1,34.7082,0.028812,1166866956),
  (123,6,10,1,1,52.0799,0.019201,1166866956),
  (124,7,1,1,1,51.6258,0.01937,1166867003),
  (125,4,1,1,1,26.2941,0.038031,1166867003),
  (126,5,1,1,1,34.7082,0.028812,1166867003),
  (127,6,10,1,1,52.0799,0.019201,1166867003),
  (128,7,1,1,1,51.6258,0.01937,1166867021),
  (129,4,1,1,1,26.2941,0.038031,1166867021),
  (130,5,1,1,1,34.7082,0.028812,1166867021),
  (131,6,10,1,1,52.0799,0.019201,1166867021),
  (132,4,1,1,1,26.5412,0.037677,1172742917),
  (133,5,1,1,1,35,0.028571,1172742917),
  (134,6,1,1,1,5,0.2,1172742917),
  (135,7,1,1,1,50,0.02,1172742917),
  (136,7,1,1,1,51.1938,0.019534,1172759918),
  (137,4,1,1,1,26.1366,0.038261,1172759918),
  (138,5,1,1,1,34.55,0.028944,1172759918),
  (139,6,10,1,1,51.6207,0.019372,1172759918);

COMMIT;

#
# Data for the `currencies` table  (LIMIT 0,500)
#

INSERT INTO `currencies` (`id`, `name`, `country_id`, `code`, `symbol`) VALUES 
  (1,' ',142,'RUR','.'),
  (4,' ',182,'USD','$'),
  (5,'',197,'EUR','&euro;'),
  (6,' ',179,'UAH',''),
  (7,' ',181,'GBP','&pound;');

COMMIT;

#
# Data for the `egold_orders` table  (LIMIT 0,500)
#

INSERT INTO `egold_orders` (`id`, `payee_account`, `payment_metal_id`, `payment_batch_num`, `payer_account`, `actual_payment_ounces`, `usd_per_ounce`, `feeweight`, `timestampgmt`, `error`, `type`, `status`) VALUES 
  (1,'1206811',1,'','',0,0,0,0,'',0,1),
  (2,'1206811',1,'','',0,0,0,0,'',0,1),
  (3,'1206811',1,'','',0,0,0,0,'',0,1),
  (4,'111',3,'','1206811',0,0,0,0,'',1,1),
  (5,'1206811',4,'','',0,0,0,0,'',0,1),
  (6,'3985856',1,'','1206811',0,0,0,0,'',1,1),
  (7,'3985856',1,'','1206811',0,0,0,0,'',1,1),
  (8,'3845167',1,'76912782','3845167',6E-5,670.4,9E-6,1172760138,'',1,0),
  (9,'3845167',1,'76912861','3845167',0.001462,670.4,8E-5,1172760327,'',1,0),
  (10,'3845167',1,'76913080','3845167',0.000179,670.4,1.5E-5,1172760491,'',0,0),
  (11,'3845167',1,'76913511','3845167',0.013485,667.4,0.000289,1172761051,'',0,0),
  (12,'3845167',1,'76914218','3845167',0.010785,670.4,0.000255,1172761909,'',0,0),
  (13,'3845167',4,'','',0,0,0,0,'',0,1),
  (14,'3845167',1,'76915594','3845167',0.010087,670.2,0.000247,1172763327,'',0,0),
  (15,'3845167',1,'76915787','3845167',0.007455,670.7,0.000214,1172763541,'',0,0),
  (16,'3845167',2,'','',0,0,0,0,'',0,1),
  (17,'3845167',1,'','',0,0,0,0,'',0,1),
  (18,'3845167',1,'76916267','3845167',0.007456,669.3,0.000214,1172764101,'',0,0),
  (19,'3845167',1,'76916382','3845167',0.008965,669.3,0.000233,1172764323,'',0,0),
  (20,'3845167',1,'','',0,0,0,0,'',0,1),
  (21,'3845167',1,'76916695','3845167',0.00874,671.6,0.00023,1172764933,'',0,0),
  (22,'3845167',1,'76919800','3845167',0.000343,670.2,2.4E-5,1172768545,'',0,0);

COMMIT;

#
# Data for the `email_templates` table  (LIMIT 0,500)
#

INSERT INTO `email_templates` (`id`, `name`, `code`, `format`) VALUES 
  (1,' ','CLIENT_REGISTRATION','html'),
  (2,'    ','CLIENT_NEW_MAIL_NOTIF','html'),
  (3,'  ','FORGOT_PASS_CONFIRM','html'),
  (4,'  ','FORGOT_PASS_NEWPASS','html');

COMMIT;

#
# Data for the `ex_currencies` table  (LIMIT 0,500)
#

INSERT INTO `ex_currencies` (`id`, `name`, `code`, `country_id`, `currency_id`, `metal_id`, `url`, `regdate`, `position`, `amount`, `comission_min`, `who_pay_comission`, `precision`, `type`, `pincode_collection_id`, `transfare_type`, `manual_properties`, `symbol`, `input`, `output`, `status`, `payment_system_comission_perc`) VALUES 
  (1,'WebMoney RUR','WMR',142,1,0,'http://money.yandex.ru',1172760930,2,1144.91,0,0,2,'ordinary',0,'auto','','WMR',1,1,1,0.008),
  (2,'WebMoney USD','WMZ',142,4,0,'http://money.yandex.ru',1172746871,3,0.19,0.01,0,2,'ordinary',0,'auto','','',1,1,1,0.008),
  (3,'WebMoney EUR','WME',142,5,0,'http://money.yandex.ru',1172739962,4,0,0.01,0,2,'ordinary',0,'auto','','',1,1,1,0.008),
  (4,'WebMoney UAH','WMU',179,6,-1,'http://www.webmoney.ru',1156433876,5,1,0.01,0,2,'ordinary',0,'auto','','',1,1,1,NULL),
  (5,'MoneyMail','MM',142,1,0,'http://money.yandex.ru',1172662116,12,1,0.01,0,2,'ordinary',0,'manual','businessmedia@mail.ru','',1,1,1,0.12),
  (7,'E-Gold GOLD(USD)','EGOLD',0,4,2,'http://money.yandex.ru',1172751248,8,2.0914,0,1,2,'ordinary',0,'auto','','',1,1,1,0.01),
  (8,'E-Gold SILVER(USD)','ESILVER',0,4,3,'http://www.e-gold.com',1156433762,9,0,0,1,2,'ordinary',0,'auto','','',0,0,1,NULL),
  (9,'E-Gold PLATINUM(USD)','EPLATINUM',0,4,4,'http://www.e-gold.com',1156433753,10,0,0,1,2,'ordinary',0,'auto','','',0,0,1,NULL),
  (10,'E-Gold PALLADIUM(USD)','EPALLADIUM',0,1,5,'http://money.yandex.ru',1172662404,6,0,0,1,2,'ordinary',0,'pincode','','',0,0,1,0.01),
  (40,'MoneyMail','MM',142,1,0,'http://money.yandex.ru',1172662412,11,11,0,1,2,'ordinary',0,'pincode','',NULL,NULL,NULL,1,0),
  (38,'  ','MEGABIZ',0,1,0,'http://www.businessmedia.ru',0,19,0,0,0,2,'pincode',14,'pincode','',NULL,NULL,NULL,1,NULL),
  (39,'Smart PIN','SMPIN',0,4,0,'http://www.smartexchanger.ru',0,20,0.2,0,0,2,'pincode',13,'pincode','',NULL,NULL,NULL,1,NULL);

COMMIT;

#
# Data for the `ex_currency_comissions` table  (LIMIT 0,500)
#

INSERT INTO `ex_currency_comissions` (`id`, `ex_currency_id`, `amount_from`, `amount_to`, `perc`, `fix`) VALUES 
  (1,1,0,0,0,0),
  (3,3,0,0,0.008,0),
  (4,4,0,0,0.008,0),
  (5,5,0,0,0.01,0),
  (6,6,0,0,0.0075,0.01),
  (7,7,0,0.1,0.05,0.0002),
  (8,7,0.1,0.5,0.0125,0.00375),
  (9,7,0.5,1,0,0.01),
  (10,7,1,5,0.01,0),
  (11,7,5,0,0,0.05),
  (12,8,0,5,0.05,0.009),
  (13,8,5,25,0.0125,0.1875),
  (14,8,25,50,0,0.5),
  (15,8,50,250,0.01,0),
  (16,8,250,0,0,2.5),
  (17,9,0,0.1,0.05,0.0002),
  (18,9,0.1,0.5,0.0125,0.00375),
  (19,9,0.5,1,0,0.01),
  (20,9,1,5,0.01,0),
  (21,9,5,0,0,0.05),
  (22,10,0,0.1,0.05,0.0002),
  (23,10,0.1,0.5,0.0125,0.00375),
  (24,10,0.5,1,0,0.01),
  (25,10,1,5,0.01,0),
  (26,10,5,0,0,0.05),
  (27,11,0,0,0,0.25),
  (28,12,0,0,0.01,0),
  (29,13,0,0,0,0),
  (30,14,0,0,0.01,0),
  (31,16,0,10,0,0),
  (32,17,0,200,0,0),
  (33,18,0,0,0,0),
  (34,21,0,0,0,0),
  (41,2,0,0,0,0),
  (36,19,0,0,0,0),
  (37,22,0,0,0,0),
  (38,23,0,0,0,0),
  (39,24,0,0,0,0),
  (40,25,0,0,0,0),
  (42,40,0,0,0.01,0),
  (43,39,0,0,0.01,0),
  (44,38,0,0,0.01,0);

COMMIT;

#
# Data for the `ex_exchanges` table  (LIMIT 0,500)
#

INSERT INTO `ex_exchanges` (`id`, `ex_currency1_id`, `ex_currency2_id`, `sys_comission_perc`, `sys_comission_fix`, `sys_comission_min`, `min_amount`, `max_amount`, `status`, `unq`, `course`, `init_value_form`, `init_value_in`, `init_value_out`, `formula_type`, `formula_value`, `formula_perc`, `formula_fix`, `include_ps_comission`, `course_up_date`, `course_up_method`) VALUES 
  (91,10,1,0.01,0,0.01,0.01,5000,1,'10;1',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4392,39,38,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4393,38,39,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (93,10,2,0.01,0,0.01,0.01,5000,1,'10;2',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (95,10,3,0.01,0,0.01,0.01,5000,1,'10;3',0.0283,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (97,10,4,0.01,0,0.01,0.01,5000,1,'10;4',0.198,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (99,10,5,0.01,0,0.01,0.01,5000,1,'10;5',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (103,10,7,0.01,0,0.01,0.01,5000,1,'10;7',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (105,10,8,0.01,0,0.01,0.01,5000,1,'10;8',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (107,10,9,0.01,0,0.01,0.01,5000,1,'10;9',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4386,39,8,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4387,8,39,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4388,39,9,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4389,9,39,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4390,39,10,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4391,10,39,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (92,1,10,0.01,0,0.01,0.01,5000,1,'1;10',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4382,39,5,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4383,5,39,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4384,39,7,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4385,7,39,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (20,1,2,0.023,0,0,0.01,5000,1,'1;2',0.0364,'in',1,12,'formula',0,-0.01,0,1,1172753977,'  CRON'),
  (22,1,3,0.01,0,0.01,0.01,5000,1,'1;3',0.0283,'in',1,0,'formula',0,-0.01,0,0,1172753977,'  CRON'),
  (26,1,4,0.01,0,0.01,0.01,5000,1,'1;4',0.198,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (32,1,5,0.01,0,0.01,0.01,5000,1,'1;5',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (50,1,7,0.01,0,0.01,0.01,5000,1,'1;7',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (62,1,8,0.01,0,0.01,0.01,5000,1,'1;8',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (76,1,9,0.01,0,0.01,0.01,5000,1,'1;9',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (19,2,1,0.01,0,0,0.01,5000,1,'2;1',26.5179,'in',1,0,'formula',0,-0.01,0,1,1172753977,'  CRON'),
  (94,2,10,0.01,0,0.01,0.01,5000,1,'2;10',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4378,39,3,0.001,0,0.01,0.01,5000,1,'',0.7637,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4379,3,39,0.001,0,0.01,0.01,5000,1,'',1.2833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4380,39,4,0.001,0,0.01,0.01,5000,1,'',5.346,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4381,4,39,0.001,0,0.01,0.01,5000,1,'',0.1833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4416,40,39,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4417,39,40,0.001,0,0.01,3,4,0,'',26.73,'out',1,2,'formula',6,-0.01,0,0,1172753977,'  CRON'),
  (24,2,3,0.01,0,0.01,0.01,5000,1,'2;3',0.7637,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (28,2,4,0.01,0,0.01,0.01,5000,1,'2;4',5.346,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (34,2,5,0.01,0,0.01,0.01,5000,1,'2;5',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (52,2,7,0.01,0,0.01,0.01,5000,1,'2;7',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (64,2,8,0.01,0,0.01,0.01,5000,1,'2;8',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (78,2,9,0.01,0,0.01,0.01,5000,1,'2;9',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (21,3,1,0.01,0,0.01,0.01,5000,1,'3;1',34.65,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (96,3,10,0.01,0,0.01,0.01,5000,1,'3;10',34.65,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4374,39,1,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4375,1,39,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4376,39,2,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4377,2,39,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4413,10,40,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4414,40,38,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4415,38,40,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (23,3,2,0.01,0,0.01,0.01,5000,1,'3;2',1.2833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (30,3,4,0.01,0,0.01,0.01,5000,1,'3;4',6.93,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (36,3,5,0.01,0,0.01,0.01,5000,1,'3;5',34.65,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (54,3,7,0.01,0,0.01,0.01,5000,1,'3;7',1.2833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (66,3,8,0.01,0,0.01,0.01,5000,1,'3;8',1.2833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (80,3,9,0.01,0,0.01,0.01,5000,1,'3;9',1.2833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (25,4,1,0.01,0,0.01,0.01,5000,1,'4;1',4.95,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (98,4,10,0.01,0,0.01,0.01,5000,1,'4;10',4.95,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4370,38,10,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4371,10,38,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4411,9,40,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4412,40,10,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,0,'formula',0,-0.01,0,0,1172753977,'  CRON'),
  (4408,40,8,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4409,8,40,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4410,40,9,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (27,4,2,0.01,0,0.01,0.01,5000,1,'4;2',0.1833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (29,4,3,0.01,0,0.01,0.01,5000,1,'4;3',0.1414,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (38,4,5,0.01,0,0.01,0.01,5000,1,'4;5',4.95,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (56,4,7,0.01,0,0.01,0.01,5000,1,'4;7',0.1833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (68,4,8,0.01,0,0.01,0.01,5000,1,'4;8',0.1833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (82,4,9,0.01,0,0.01,0.01,5000,1,'4;9',0.1833,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (31,5,1,0.01,0,0.01,0.01,5000,1,'5;1',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (100,5,10,0.01,0,0.01,0.01,5000,1,'5;10',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4366,38,8,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4367,8,38,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4368,38,9,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4369,9,38,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4405,5,40,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4406,40,7,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4407,7,40,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (33,5,2,0.01,0,0.01,0.01,5000,1,'5;2',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (35,5,3,0.01,0,0.01,0.01,5000,1,'5;3',0.0283,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (37,5,4,0.01,0,0.01,0.01,5000,1,'5;4',0.198,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (58,5,7,0.01,0,0.01,0.01,5000,1,'5;7',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (70,5,8,0.01,0,0.01,0.01,5000,1,'5;8',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (84,5,9,0.01,0,0.01,0.01,5000,1,'5;9',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (49,7,1,0.01,0,0.01,0.01,5000,1,'7;1',25,'in',1,0,'value',25,-0.01,0,0,1172763445,' admin[ID 1]'),
  (104,7,10,0.01,0,0.01,0.01,5000,1,'7;10',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4362,38,5,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4363,5,38,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4364,38,7,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4365,7,38,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4402,40,4,0.001,0,0.01,0.01,5000,1,'',0.198,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4403,4,40,0.001,0,0.01,0.01,5000,1,'',4.95,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4404,40,5,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (51,7,2,0.01,0,0.01,0.01,5000,1,'7;2',0.99,'in',1,0.99,'formula',0,-0.01,0,0,1172755775,' admin[ID 1]'),
  (53,7,3,0.01,0,0.01,0.01,5000,1,'7;3',0.7637,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (55,7,4,0.01,0,0.01,0.01,5000,1,'7;4',5.346,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (57,7,5,0.01,0,0.01,0.01,5000,1,'7;5',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (74,7,8,0.01,0,0.01,0.01,5000,1,'7;8',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (88,7,9,0.01,0,0.01,0.01,5000,1,'7;9',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (61,8,1,0.01,0,0.01,0.01,5000,1,'8;1',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (106,8,10,0.01,0,0.01,0.01,5000,1,'8;10',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4358,38,3,0.001,0,0.01,0.01,5000,1,'',0.0283,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4359,3,38,0.001,0,0.01,0.01,5000,1,'',34.65,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4360,38,4,0.001,0,0.01,0.01,5000,1,'',0.198,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4361,4,38,0.001,0,0.01,0.01,5000,1,'',4.95,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4399,2,40,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4400,40,3,0.001,0,0.01,0.01,5000,1,'',0.0283,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4401,3,40,0.001,0,0.01,0.01,5000,1,'',34.65,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (63,8,2,0.01,0,0.01,0.01,5000,1,'8;2',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (65,8,3,0.01,0,0.01,0.01,5000,1,'8;3',0.7637,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (67,8,4,0.01,0,0.01,0.01,5000,1,'8;4',5.346,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (69,8,5,0.01,0,0.01,0.01,5000,1,'8;5',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (73,8,7,0.01,0,0.01,0.01,5000,1,'8;7',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (90,8,9,0.01,0,0.01,0.01,5000,1,'8;9',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (75,9,1,0.01,0,0.01,0.01,5000,1,'9;1',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (108,9,10,0.01,0,0.01,0.01,5000,1,'9;10',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4354,38,1,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4355,1,38,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4356,38,2,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4357,2,38,0.001,0,0.01,0.01,5000,1,'',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4396,40,1,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4397,1,40,0.001,0,0.01,0.01,5000,1,'',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (4398,40,2,0.001,0,0.01,0.01,5000,1,'',0.0367,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (77,9,2,0.01,0,0.01,0.01,5000,1,'9;2',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (79,9,3,0.01,0,0.01,0.01,5000,1,'9;3',0.7637,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (81,9,4,0.01,0,0.01,0.01,5000,1,'9;4',5.346,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (83,9,5,0.01,0,0.01,0.01,5000,1,'9;5',26.73,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (87,9,7,0.01,0,0.01,0.01,5000,1,'9;7',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON'),
  (89,9,8,0.01,0,0.01,0.01,5000,1,'9;8',0.99,'in',1,NULL,'formula',NULL,-0.01,NULL,NULL,1172753977,'  CRON');

COMMIT;

#
# Data for the `exchanger_ads` table  (LIMIT 0,500)
#

INSERT INTO `exchanger_ads` (`id`, `name`, `html_code`, `status`) VALUES 
  (1,'dsfsdf','sdfsdfsdfsdsf\r\nsfsdf\r\nsdfsdfsdf',1);

COMMIT;

#
# Data for the `exchanger_codes` table  (LIMIT 0,500)
#

INSERT INTO `exchanger_codes` (`id`, `name`, `html_code`, `status`) VALUES 
  (1,' javascript ','<script src=\"http://SITE_URL/code.php?pid=PARTNER_ID\" language=\"javascript\" type=\"text/javascript\">\r\n</script>',1),
  (2,'   ','<script src=\"http://SITE_URL/banners.php?id=1&pid=PARTNER_ID\" language=\"javascript\" type=\"text/javascript\"></script>',1),
  (3,'      ','<script src=\"http://SITE_URL/banners.php?id=3&pid=PARTNER_ID\" language=\"javascript\" type=\"text/javascript\"></script>',1);

COMMIT;

#
# Data for the `faqs` table  (LIMIT 0,500)
#

INSERT INTO `faqs` (`id`, `title`, `answer`) VALUES 
  (4,'     ?','         \\\" \\\".   ,          ,   .'),
  (3,'     ?','  ,    .              ,    .   ,  ,   ( ).  \\\"\\\"   .     !'),
  (5,'  ?','     ,   .        ,   .           ,   .    Ruchnage,     .'),
  (6,'     ,  ?','Smartex             .  ,   ,        \\\"\\\".'),
  (7,'    ?','   .'),
  (8,'    ?',',     . Smartex           .'),
  (9,'     ?','        .         Smartex.'),
  (10,'       ,  ?','       .     ,   ,   .     !');

COMMIT;

#
# Data for the `hashes` table  (LIMIT 0,500)
#

INSERT INTO `hashes` (`id`, `owner_id`, `type`, `hash`, `regdate`) VALUES 
  (236,347,1,'VIz4LDSfaeVm164QvfgLh1zhQo0961VK8XcvY875K6ffX89ChV8wWDBtDF30',1152725008),
  (237,348,1,'c35vYoZq6S8o8qsABWbSJaF8bKr6Bdb75Jd9C355VW879g1XIqOm3Gwl3yBT',1152905526),
  (238,349,1,'tV7Xsvi1Ox7h02Omp1MAtfRxZGcbSGOi76vBgz0EPrNIk03TNh0u5vHX3Dmm',1153490297),
  (239,350,1,'G2kcaAD8pxM80L6ZUNp4j13tK2Zt9991wpMJ7KHdie0EIbel0EpKttdePpy7',1153490311),
  (240,351,1,'5m508kWEEvCkeQ7tQ9E18iAD0vG65poA8C5JIrG51HoKHet3JoEV6V30XI4X',1153490327),
  (241,352,1,'6QQFvR3Mj5Ob9Z960O4iE3V9d83i4zBq0c95g9G0c9jbbNR1pux4XJgx6et2',1153490774),
  (242,353,1,'QeaOH3ysw3RH6LAHpU0SEmsQWoWw1qA12Eo04iRig0oGA9712cgJvV6k3d2m',1153490796),
  (243,354,1,'Tp17a09k7iFjjCHhd43qY9h8ML2WIVK7WyYbf35cS43y29NOhEKPZrLZbvX9',1153490879),
  (244,355,1,'rP0Ix0ERO3p10N2cr9o0T2857Cp3n8LYcPus773jLhUI2324Ri21v0rM75Xo',1153490899),
  (245,356,1,'FSbt297OOM0Z3S4m6EN5xyacSA061lz91680a0Y25ZUZ2970awk5O8HR40y3',1153490946),
  (246,357,1,'9l7eBXKG86j50dUQ9U853B4r1IcJp7YPw9j2Gux226zOgY3Y1M79Q6XPNzv2',1153490970),
  (247,358,1,'gamYW50hToP26x2a8Ezf5rq09nrQHiTtmv3OT7mP3k7Aax0t0mCKNG6GKS6W',1153491416),
  (248,359,1,'8kL5k05NGFqyTJC1grjQNs6fZiuXSPEizKy7he3q9z1nvszY7R4GMRcnRYcy',1153906688),
  (249,360,1,'ksK2uTQcg9v22wPd86k3p9SEd5t69Kzrq50zcBgqXc2W40nF0u4HpHysBtOx',1153906803),
  (250,361,1,'K328344138zv47PNS09fKnjH9MFQ9TVFKlY0KFlDyOZ162ke3CeHv8POT81t',1154375181),
  (251,362,1,'KApBd9DG7b4O430uY0Z143HAf97Ii49W9PB8u6gu0n44tixJj3zCb1xSxIqU',1154421114),
  (252,363,1,'w8h4sjpFeHsr0gpng438IjY7Y44Y2ul4G7O8f282m5Z6y8n32862k7brQ7NT',1154424498),
  (253,364,1,'J8AC9dn7m41XfMGX7Lj8U0kA4dyyec54HkpXosy8DXfJwocA52OMxgbbVXxY',1154436026),
  (254,365,1,'pG9z892ZNx3XVVc0hb4o3bwMqQ8A32HWkOW1UQ2487MbKX8Bkxa6wtViriHl',1154459839),
  (255,366,1,'s5iYNdJg8t90d446pqZd57vr87wSjo0u63u9KDRa9nk5lLetZaf05u76K2QZ',1154459858),
  (256,367,1,'qJQvXtOWh61P807W4u4n323N7R8KvfG9Qxo63unW5MJ7dcao9K0i3AfZW38m',1154506004),
  (257,368,1,'5NH5Nu8UUOJe7p222Glxs3a1f2rzET5yh632ai9G3CSrIN8c1e4mACrnh9t2',1154506091),
  (258,369,1,'SyRV66uPr2w1mx29Zd8oM67ruOZklxp8p5Adyep987Twue216gvJhwQBy5rW',1154506184),
  (259,370,1,'ukC3n8z7RIxk2o7rHj6hN2bu0jNqDeMBu3ZkAP7Jwo3BTEG5ULql9s5WU2Sy',1154507231),
  (260,371,1,'5Lk2QFYy83nwb0SyV4EiBCXEqAsy6yU5TlZBtetl54FeO75LoGprXDHZvUb7',1154507373),
  (261,372,1,'pFGXp1oJ4Bl380D4Dt864cHiWyJf9Ibhsqti3AsQd1LH59Zk09DvGjk7Wo60',1154679813),
  (262,373,1,'W72Rujq5l510LlqLuEZeAt4l98r964650vecQcFa195Ghy3F7MRa2QT6Vm33',1154679887),
  (263,374,1,'wx1Qrl86PTgY28936jGy6u2b5aRkLb5VUot92S8g38dIpwhmWA7hW1u2mdxv',1155030680),
  (264,375,1,'G7eeliK5Bcb9rfDYc34g1T0laka9Xg5f09lIS78Jm4rGq3098Zy1xtXBAL2W',1155034664),
  (265,376,1,'oupstuuL049IFWSW6n8YgJTbg4GwAXndCcE5X900oPGM57oXTlp69686Y79D',1155034858),
  (266,377,1,'U87C2Q2t7fUIe2Y2LZ9G110IgHFDA2C5HC4UC3bpL9H20v350TofUtb333JK',1155065402),
  (267,378,1,'492R6J63pNT6BLo4BzWPqM0B9gU36by56BOx0cXJyMmDBkngxe08TS4489f6',1155122042),
  (268,379,1,'0Hweq65i7l6F0DG58Lf85s1f82Iw0qhTu7Mx0V91qgy81m9052xeIZ2W4729',1155993260),
  (269,380,1,'BKfy3qH4UueN5FM3EJ4x5926zx61fTTXg8MO72hxefIm4xqZ4T4ef20SEESB',1156235431),
  (270,381,1,'Akwnt3rWEIaiOXjuVbv0Uz60chQJXvS0p84NO3rAj9ETe5kD1D3cSP868Bjl',1156238339),
  (271,382,1,'9qq6U4z7rtzr6pgmJ9EsZ670CgyQnuSe8eGfPSN53WZ2j9T988Tll67tsZ79',1156242689),
  (272,383,1,'t756K510079Z2m5Iv5sQ17epDqAKZ3t8w5PnHChUXH4oXbDigOnbdO3x7MX0',1156242806),
  (273,384,1,'IyTxpuNuC0zjvlYu069zWeJ1b44HCvzy102AQ79nkn4WC90wd921sd68NyS1',1162978115),
  (274,385,1,'g68f598U2Ura0Qz16fphOEf4TWEXSEAFDIWMu2gMxEsrA0xY19NBEBWM1277',1164993465),
  (275,386,1,'HgtMOF51BOtOS9xg1GxQ6Zi5Rc2B0sygAE1hTCZ886V1p88edguNT1XuL2I6',1164993517),
  (276,387,1,'O2f3hOFqoUNR8js27zAWtJ2a4634T9W5BoD8cZ9csTZ8kvFt1emT7pKK37y2',1164994182),
  (277,388,1,'iz3Jy6iP1y9S7uRb3y7Bt4x7I5j5NNeJbqN6Y19Hm5s8OP548CJ8hb22Q191',1165064226),
  (278,389,1,'6F14dGnh8vU0p7v3HdCq6jtqKSs9b1TOj04h0C04YdYA8ZOjsn6qanz6d777',1165064884),
  (279,390,1,'gP5m88982rD5Sw56XY6Io29rH49A6TPcx4nkfCk1I24HY04xf4Q52cm1fj9A',1165314723),
  (280,391,1,'jd8fCmt454B5T9F0J8jPM4E4Y82JgujNb7mA45h0IAb79E6mEan0y7p7HeyQ',1166100852),
  (281,392,1,'ube5Am1WKA35m2ip06q5hd80mY32G6gy80d9mo8twVzDd2zWZbzvvc7cWrQ8',1168962261),
  (282,393,1,'608JV724VRxEyb7OJ92nBRXVIKj5zHMj8OiRIL9U7faib7tv9i4uIlLTXK1O',1169025409),
  (283,394,1,'o29zB8BoZy0d8T6220lDxA3yhcCfL40OSVajM9dsuB2W68XP5p15Ex33PlqJ',1169051140),
  (284,395,1,'vIc0N8D7aVv0lPyEayU1VneZTgeaFn6BGf0nGPb295xbl7xnK1A08siK6B5A',1169132775),
  (285,396,1,'Q133yMlm4a190L25pOeH6q7zJtVFrZSiv0pIR18t8tzN6Gsg6A94p70tGi3P',1169132833),
  (286,397,1,'z0I62tZL17LT0w2x4iF0rD5WQZUDz7KE4cOHQuZ0Bu1ABgq2mGN48OIZSmiu',1169749707),
  (287,398,1,'7UFX6981NWmoo8jnsdZdvgxjh9UB3HA8tK9T82imFuAxY6GeZzAy1Oo0AgVX',1169749761),
  (288,399,1,'0IA0lDxpR2Bde8rBypRpE38uLib1iB1cv2k4B1981qIp9aX6W190hqSd1P4U',1170159767),
  (289,400,1,'FF56I9545biobv94oXlN755g314EiJCkx873M75hz3L970oPPy28OTcvVI87',1170507639),
  (290,401,1,'HuB7dqs08IaOy1Be3AaNs25mL50A5TQ6I077wo3PQgM32Woa5FprCB3TfKzC',1170508389),
  (291,402,1,'XGu0dVOJlT4L6gJ49lsGZkcV2vtG153kEB4o640Ty55V94V570B79Z5ETdR5',1170508456),
  (292,403,1,'3Y0ILNXr2k8BQTWRA9nOA6B48TW2PN4X9ZOhwB7NRlT9Wq9qvtYIeLf9G1zz',1170508567),
  (293,404,1,'SX1jFn8M7mUwInoF2c1MIzeCAg8B26N5228Zxauq1SXX0RPtP4lS9dC7914l',1170508601),
  (294,405,1,'uk8385ml9wH390EFiN73a2TzGTNSTC6Xy1BOSz4XtqW6PHmau5qdqKH1t024',1172748069),
  (295,406,1,'RWvKdISOQy1vgM5e37J9Ox8S040Ea5hzsEMBPYD266o1DD7DFQaq9tU46VJ3',1172748236),
  (296,407,1,'e9C7BHiP73OmpLj7zBD4dm20rh058BwUS0YxR9NQ80Yu4953KOC3bzTQ351t',1172749277),
  (297,408,1,'51LtBS98w9Myrljz17mS4kQ45b6D0IRlR9cFowq58QCqkqEj6G3H1PvUIlP5',1172749322),
  (298,409,1,'EvL581Fc31qH08C0823p2ILWfJ5PjZFN0rSYNw1WhNJ5G2P2400yjU69b97m',1172757344),
  (299,410,1,'Sws3KSVMT3ZLoF0UN5ndXvqtkVKFfy5WEMlV7tq4hDFFhfhFJAVIOTL82CIP',1172757368),
  (300,411,1,'M621z5KzowZ1s8DDF6Bvbhqs0QTV2UXPp1Mo8EEe8wKVMm26G8X2R9Iiz6Eu',1172760099),
  (301,412,1,'yApa08H7XCuU43yANU2cV637VHCgC0ucE3x5eslA5WfCui6q6S1R87QsmKys',1172760289),
  (302,413,1,'g02aX39vaS21jBW5jmhxgJ9sC6M9Wqy9W8HbqXv32nXFYOAwkbC3a2HIQ0Jb',1172760448),
  (303,414,1,'Yp9EcK5h1HHbZZlY4Hh54CKvsl9EEBL91H7T5H8XX9b17oM9U5sC3WUoKwjk',1172760956),
  (304,415,1,'zJg01QXP42Y2HA2kT7ScJPOKV1nv54u53zUUY7QCVXcPAC59HgGnrG2eP846',1172761877),
  (305,416,1,'FG8Lt59F3Y6Qws9A1xfnAvL7ld3KyCbI0m7at7RruvM9VMrKvK99Bb70VB9B',1172762646),
  (306,417,1,'Tb2b3mwA1BE49F9mS3pcEAa7fc8tPNoY19Y92xIQjYwYDba2RGCR23sI7V1A',1172762845),
  (307,418,1,'RF8nt526FG5JZ2Li64V5pK24tq60n3f7au9c5y3F3JfLc7gbw9KweXaGdy38',1172763292),
  (308,419,1,'0M6ot6Iu77h2ylnxH6t8Vxf9HK3kQxaeggVVwPQmJEUH1cjZ2GLcSDHjNKo6',1172763482),
  (309,420,1,'a4C9otqV5in1s2dd9dIAB0WqLbF14KzGiI5153YDQ7f2d587KwHhtGf5m0n0',1172763961),
  (310,421,1,'3QS83zW2M46208oW8ak65CT88pB1jssgb2cy02G9ZcvvIHn007vo4Hc2dW2r',1172763996),
  (311,422,1,'752I3mv017V3yn0aoY84A7vnYh4I945W74LEq9956d4RTJf9MMVy4ll7H2yl',1172764068),
  (312,423,1,'9q54LVcf1y165N5e9O7X234f02PCK3d9LWX032iO5FU6rfjhA8ML6FXl3HvS',1172764292),
  (313,424,1,'w2V1Zl83y6I9UL1XW3a6lP5v34K2a1br3yEsJTFh453xFL6tX4zc7JK6TN3O',1172764775),
  (314,425,1,'8HA2oytuw59tLoTRx2i4q4c24Qi24b2EyIwuoaFPnYFUvtgS74lTBPl4Y9x0',1172764890),
  (315,426,1,'Fc9g23V5eCj9iTC68zg56ZXWJfoNzvOu415vW3E8Iiw650yjOw1Z564U144d',1172768492);

COMMIT;

#
# Data for the `manual_orders` table  (LIMIT 0,500)
#

INSERT INTO `manual_orders` (`id`, `account`, `type`, `status`) VALUES 
  (1,'',0,1),
  (2,'',0,1),
  (3,'',0,1),
  (4,'',0,1),
  (5,'',0,1),
  (6,'',0,1);

COMMIT;

#
# Data for the `merchant_orders` table  (LIMIT 0,500)
#

INSERT INTO `merchant_orders` (`id`, `merchant_id`, `from_order_id`, `to_order_id`, `email`, `description`, `ip`, `ex_currency_from_id`, `ex_currency_to_id`, `amount_from`, `amount_to`, `sys_comission`, `ex_currency_from_comission`, `ex_currency_to_comission`, `metal_amount_from`, `metal_amount_to`, `metal_sys_comission`, `metal_ex_currency_from_comission`, `metal_ex_currency_to_comission`, `from_info`, `to_info`, `batch_from`, `batch_to`, `regdate`, `type`, `from_status`, `to_status`, `status`, `merchant_order_id`) VALUES 
  (200,1,491,0,'sdf@dasf.ff','','192.168.0.3',1,1,151.52,101,0.51,0,0,0,0,0,0,0,'','','','','1146828916',1,0,1,1,NULL),
  (201,1,492,493,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1146930935',1,0,1,1,4),
  (202,1,494,495,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1146930940',1,0,1,1,4),
  (203,1,65,496,'wdqw@wedwed.hh','','192.168.0.7',10,1,0.02,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1146932863',1,0,1,1,4),
  (204,1,497,498,'ere@fefe.ttgt','','192.168.0.7',2,1,0.02,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1146932884',1,0,1,1,4),
  (205,1,499,500,'ere@fefe.ttgt','','192.168.0.7',2,1,0.02,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1146932890',1,0,1,1,4),
  (206,1,501,502,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272152',1,0,1,1,4),
  (207,1,503,504,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272158',1,0,1,1,4),
  (208,1,505,506,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272159',1,0,1,1,4),
  (209,1,507,508,'','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272174',1,0,1,1,4),
  (210,1,509,510,'','','192.168.0.3',3,1,0.44,10,0.51,0,0,0,0,0,0,0,'','','','','1147272244',1,0,1,1,4),
  (211,1,66,511,'','','192.168.0.3',7,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272245',1,0,1,1,4),
  (212,1,512,513,'','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272247',1,0,1,1,4),
  (213,1,67,514,'','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272249',1,0,1,1,4),
  (214,1,515,516,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272254',1,0,1,1,4),
  (215,1,517,518,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272268',1,0,1,1,4),
  (216,1,519,520,'','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272270',1,0,1,1,4),
  (217,1,68,521,'','','192.168.0.3',7,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272272',1,0,1,1,4),
  (218,1,69,522,'','','192.168.0.3',8,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272274',1,0,1,1,4),
  (219,1,70,523,'','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272276',1,0,1,1,4),
  (220,1,524,525,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272310',1,0,1,1,4),
  (221,1,526,527,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272383',1,0,1,1,4),
  (222,1,528,529,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272386',1,0,1,1,4),
  (223,1,530,531,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272399',1,0,1,1,4),
  (224,1,532,533,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272427',1,0,1,1,4),
  (225,1,534,535,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272428',1,0,1,1,4),
  (226,1,536,537,'asdf@df.ff','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147272430',1,0,1,1,4),
  (227,1,71,538,'asdf@df.ff','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272431',1,0,1,1,4),
  (228,1,72,539,'asdf@df.ff','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272435',1,0,1,1,4),
  (229,1,73,540,'asdf@df.ff','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272439',1,0,1,1,4),
  (230,1,74,541,'asdf@df.ff','','192.168.0.3',9,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272485',1,0,1,1,4),
  (231,1,542,543,'asdf@df.ff','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272522',1,0,1,1,4),
  (232,1,544,545,'','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272526',1,0,1,1,4),
  (233,1,546,547,'sdf@asd.ff','','192.168.0.3',2,1,0.54,10,0.51,0,0,0,0,0,0,0,'','','','','1147272532',1,0,1,1,4),
  (234,1,548,549,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337402',1,0,1,1,4),
  (235,1,550,551,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337415',1,0,1,1,4),
  (236,1,552,553,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337432',1,0,1,1,4),
  (237,1,554,555,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337437',1,0,1,1,4),
  (238,1,556,557,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337438',1,0,1,1,4),
  (239,1,558,559,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337439',1,0,1,1,4),
  (240,1,560,561,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147337526',1,0,1,1,4),
  (241,1,562,563,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147337531',1,0,1,1,4),
  (242,1,564,565,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147337553',1,0,1,1,4),
  (243,1,566,567,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147337556',1,0,1,1,4),
  (244,1,568,569,'','','192.168.0.3',1,1,15.02,10,0.51,0,0,0,0,0,0,0,'','','','','1147337560',1,0,1,1,4),
  (245,1,570,571,'','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337972',1,0,1,1,4),
  (246,1,572,573,'asd@sdf;sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337987',1,0,1,1,4),
  (247,1,574,575,'asd@sdf;sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337992',1,0,1,1,4),
  (248,1,576,577,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337996',1,0,1,1,4),
  (249,1,578,579,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147337997',1,0,1,1,4),
  (250,1,580,581,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147338003',1,0,1,1,4),
  (251,1,582,583,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147338004',1,0,1,1,4),
  (252,1,584,585,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147338052',1,0,1,1,4),
  (253,1,586,587,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147338055',1,0,1,1,4),
  (254,1,588,589,'asd@sdf.sdf','','192.168.0.3',1,1,0.18,0.1,0.51,0,0.01,0,0,0,0,0,'','','','','1147338056',1,0,1,1,4),
  (255,1,590,591,'','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349065',1,0,1,1,0),
  (256,1,592,593,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349082',1,0,1,1,0),
  (257,1,594,595,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349084',1,0,1,1,0),
  (258,1,596,597,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349091',1,0,1,1,0),
  (259,1,598,599,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349112',1,0,1,1,0),
  (260,1,600,601,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349179',1,0,1,1,0),
  (261,1,602,603,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349180',1,0,1,1,0),
  (262,1,604,605,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349180',1,0,1,1,0),
  (263,1,606,607,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349182',1,0,0,0,0),
  (264,1,608,609,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349262',1,0,1,1,0),
  (265,1,610,611,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349263',1,0,0,0,0),
  (266,1,612,613,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349305',1,0,1,1,0),
  (267,1,614,615,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349308',1,0,1,1,0),
  (268,1,616,617,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147349313',1,0,1,1,0),
  (269,1,618,619,'sdf@asd.ff','','192.168.0.3',1,1,184.52,123,0.51,0,0,0,0,0,0,0,'','','','','1147350479',1,1,1,1,0),
  (270,1,75,620,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350483',1,1,1,1,0),
  (271,1,76,621,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350593',1,1,1,1,23),
  (272,1,77,622,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350594',1,1,1,1,23),
  (273,1,78,623,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350601',1,1,1,1,23),
  (274,1,79,624,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350615',1,1,1,1,23),
  (275,1,80,625,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147350619',1,1,1,1,23),
  (276,1,81,626,'sdf@asd.ff','','192.168.0.3',7,1,6.5,123,0.54,0,0,0,0,0,0,0,'','','','','1147359367',1,1,1,1,23),
  (277,1,629,0,'','','192.168.0.3',2,1,0,0,0.5,0,0,0,0,0,0,0,'','','','','1147367752',1,1,1,1,2),
  (278,1,630,0,'','','192.168.0.3',2,1,0,0,0.5,0,0,0,0,0,0,0,'','','','','1147367754',1,1,1,1,2),
  (279,1,631,632,'','','192.168.0.3',2,2,187.85,123,0.51,0,2.22,0,0,0,0,0,'','','','','1147367822',1,1,1,1,2),
  (280,1,633,634,'','','192.168.0.3',2,2,187.85,123,0.51,0,2.22,0,0,0,0,0,'','','','','1147367841',1,1,1,1,2),
  (281,1,635,636,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147367875',1,1,1,1,2),
  (282,1,637,638,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147367879',1,1,1,1,2),
  (283,1,639,640,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368308',1,1,1,1,2),
  (284,1,641,642,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368351',1,1,1,1,2),
  (285,1,643,644,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368358',1,1,1,1,2),
  (286,1,645,646,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368424',1,1,1,1,2),
  (287,1,647,648,'asd@aedf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368450',1,1,1,1,2),
  (288,1,649,650,'asd@aedf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368452',1,1,1,1,2),
  (289,1,651,652,'asd@aedf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368457',1,1,1,1,2),
  (290,1,653,654,'asd@aedf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368554',1,1,1,1,2),
  (291,1,655,656,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368656',1,1,1,1,2),
  (292,1,657,658,'dfg@sdf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368663',1,1,1,1,2),
  (293,1,659,660,'','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368732',1,1,1,1,2),
  (294,1,661,662,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368803',1,1,1,1,2),
  (295,1,663,664,'sdf','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368806',1,1,1,1,2),
  (296,1,665,666,'sdf','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368840',1,1,1,1,2),
  (297,1,667,668,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368843',1,1,1,1,2),
  (298,1,669,670,'sdf@sdf.sd','|','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368849',1,1,1,1,2),
  (299,1,671,672,'sdf@sdf.sd','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368857',1,1,1,1,2),
  (300,1,673,674,'sdf@sdf.sd','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368906',1,1,1,1,2),
  (301,1,675,676,'sdf@sdf.sd','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368907',1,1,1,1,2),
  (302,1,677,678,'sdf@sdf.sd','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368907',1,1,1,1,2),
  (303,1,679,680,'','|','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368914',1,1,1,1,2),
  (304,1,681,682,'sdf@sdf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368916',1,1,1,1,2),
  (305,1,683,684,'sdf@sdf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368918',1,1,1,1,2),
  (306,1,685,686,'sdf@sdf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368919',1,1,1,1,2),
  (307,1,687,688,'sdf@sdf.ff','','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368920',1,1,1,1,2),
  (308,1,689,690,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368951',1,1,1,1,2),
  (309,1,691,692,'asd@asd.ff','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368955',1,1,1,1,2),
  (310,1,693,694,'asd@asd.ff','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368956',1,1,1,1,2),
  (311,1,695,696,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368997',1,1,1,1,2),
  (312,1,697,698,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147368999',1,1,1,1,2),
  (313,1,699,700,'','<y?;?99{;{889;x','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369000',1,1,1,1,2),
  (314,1,701,702,'','z vg8uXmIO7yIOTl7O4t7ODj4Ofo7eA=','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369026',1,1,1,1,2),
  (315,1,703,704,'','z vg8uXmIO7yIOTl7O4t7ODj4Ofo7eA=','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369028',1,1,1,1,2),
  (316,1,705,706,'','  -','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369047',1,1,1,1,2),
  (317,1,707,708,'sdf@df.ff','  -','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369051',1,1,1,1,2),
  (318,1,709,710,'','  -','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369076',1,1,1,1,2),
  (319,1,711,712,'','  -','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369084',1,1,1,1,2),
  (320,1,713,714,'asd@asd.ff','  -','192.168.0.3',2,2,189.36,123.99,0.51,0,2.24,0,0,0,0,0,'','','','','1147369155',1,1,1,1,2);

COMMIT;

#
# Data for the `merchant_users` table  (LIMIT 0,500)
#

INSERT INTO `merchant_users` (`id`, `email`, `password`, `name`, `last_name`, `p_name`, `passport_series`, `passport_number`, `site_name`, `site_url`, `ex_currency_id`, `purse`, `purse_serial`, `secret_word`, `notification_url`, `notification_method`, `success_url`, `success_method`, `failure_url`, `failure_method`, `status`) VALUES 
  (1,'alexey@businessmedia.ru','3590cb8af0bbb9e78c343b52b93773c9','\'','\'1','\'','12\'34','12\'3-123',' \' ','http://pupkinshop.ru',2,'Z111111111111','111111111112','PREVED','alexey@businessmedia.ru',3,'http://ya.ru/','1','http://google.ru/','2',1),
  (2,'test@businessmedia.ru','c4ca4238a0b923820dcc509a6f75849b','','','','312','312','','http://url',2,'Z111111111111','111111111111','','',3,'','2','','2',1),
  (4,'xtrm@bk.ru','68276092a32b3006a3f825cb366f5bf3','','','','33434234','4003','','http://www.test.com',7,'232132','','ed223e23e23e23','http://dwededwe.cc',1,'http://qeqweqwe','2','http://wqeqwew','2',1),
  (5,'asd@asd.sad','c4ca4238a0b923820dcc509a6f75849b','1','1','1','1','1','1','http://',2,'Z111111111111','111111111111','dfgsdfg','http://',2,'http://','2','http://','2',1),
  (6,'sdf@asdf.sdf','c4ca4238a0b923820dcc509a6f75849b','1','1','1','1','1','1','http://',1,'R111111111111','111111111111','sdfsdf','sdf@sd.sdf',3,'http://','2','http://','2',1),
  (7,'sdf@asdf.sdfsdf','c4ca4238a0b923820dcc509a6f75849b','1','1','1','1','1','1','http://',1,'R111111111111','111111111111','','',2,'http://','2','http://','2',1),
  (8,'sdf@sdf.sdfsdf','c4ca4238a0b923820dcc509a6f75849b','1','1','1','1','1','1','http://',2,'Z111111111111','111111111111','','',2,'http://','2','http://','2',1),
  (9,'sdf@asdf.s1df','c4ca4238a0b923820dcc509a6f75849b','1','1','1','1','1','1','http://dfg',1,'R111111111111','111111111111','','',3,'http://1','2','http://','2',1);

COMMIT;

#
# Data for the `metal_prices` table  (LIMIT 0,500)
#

INSERT INTO `metal_prices` (`id`, `metal_id`, `currency_id`, `price`, `date`) VALUES 
  (24,5,4,7.587571,1074938132),
  (23,4,4,27.810375,1074938132),
  (22,3,4,0.203836,1074938132),
  (21,2,4,13.11428,1074938132),
  (20,5,4,7.587571,1074882247),
  (19,4,4,27.810375,1074882247),
  (18,3,4,0.203836,1074882247),
  (17,2,4,13.11428,1074882247),
  (9,2,4,13.11428,1074880461),
  (10,3,4,0.204479,1074880461),
  (11,4,4,27.810375,1074880461),
  (12,5,4,7.587571,1074880461),
  (25,2,4,13.12714,1075128550),
  (26,3,4,0.202871,1075128550),
  (27,4,4,27.58532,1075128550),
  (28,5,4,7.587571,1075128550),
  (57,2,4,21.55386,1172759894),
  (58,3,4,0.454612,1172759894),
  (59,4,4,40.284885,1172759894),
  (60,5,4,11.413515,1172759894);

COMMIT;

#
# Data for the `metals` table  (LIMIT 0,500)
#

INSERT INTO `metals` (`id`, `name`, `code`) VALUES 
  (2,'','GOLD'),
  (3,'','SILVER'),
  (4,'','PLATINUM'),
  (5,'','PALLADIUM');

COMMIT;

#
# Data for the `news` table  (LIMIT 0,500)
#

INSERT INTO `news` (`id`, `date`, `title`, `text`) VALUES 
  (11,1155067200,' ','');

COMMIT;

#
# Data for the `offline_payment_methods` table  (LIMIT 0,500)
#

INSERT INTO `offline_payment_methods` (`id`, `currency_id`, `name`, `who_pay_comission`, `code`, `symbol`, `position`, `precision`, `status`) VALUES 
  (7,1,'Contact',0,'CONTACT',NULL,NULL,2,1),
  (8,4,'Western Union',0,'WU',NULL,NULL,2,1),
  (9,4,'STB-',0,'STB_E',NULL,NULL,2,1),
  (10,4,'MoneyGram',0,'MONEYGRAM',NULL,NULL,2,1),
  (11,4,'ANELIK',0,'ANELIK',NULL,NULL,2,1),
  (12,4,'   USD',0,'NAL_USD',NULL,NULL,2,1),
  (13,1,'   RUR',0,'NAL_RUR',NULL,NULL,2,1),
  (14,1,'    (RUR)',0,'BANK_RUR',NULL,NULL,2,1);

COMMIT;

#
# Data for the `offline_exchange_ways` table  (LIMIT 0,500)
#

INSERT INTO `offline_exchange_ways` (`id`, `offline_method_id`, `ex_currency_id`, `sys_comission_perc`, `sys_comission_fix`, `sys_comission_min`, `min_amount`, `max_amount`, `type`, `status`) VALUES 
  (12,7,1,0.03,1,1,0,0,0,1),
  (14,7,2,0,0,0,0,0,0,1),
  (16,7,3,0,0,0,0,0,0,1),
  (18,7,4,0,0,0,0,0,0,1),
  (19,7,4,0,0,0,0,0,1,1),
  (20,7,5,0,0,0,0,0,0,1),
  (21,7,5,0,0,0,0,0,1,1),
  (22,7,7,0,0,0,0,0,0,1),
  (23,7,7,0,0,0,0,0,1,1),
  (24,7,35,0,0,0,0,0,0,1),
  (25,7,35,0,0,0,0,0,1,1),
  (26,7,36,0,0,0,0,0,0,1),
  (27,7,36,0,0,0,0,0,1,1),
  (28,7,37,0,0,0,0,0,0,1),
  (29,7,37,0,0,0,0,0,1,1),
  (30,8,1,0,0,0,0,0,0,1),
  (31,8,1,0,0,0,0,0,1,1),
  (32,8,2,0,0,0,0,0,0,1),
  (33,8,2,0,0,0,0,0,1,1),
  (34,8,3,0,0,0,0,0,0,1),
  (35,8,3,0,0,0,0,0,1,1),
  (36,8,4,0,0,0,0,0,0,1),
  (37,8,4,0,0,0,0,0,1,1),
  (38,8,5,0,0,0,0,0,0,1),
  (39,8,5,0,0,0,0,0,1,1),
  (40,8,7,0,0,0,0,0,0,1),
  (41,8,7,0,0,0,0,0,1,1),
  (42,8,35,0,0,0,0,0,0,1),
  (43,8,35,0,0,0,0,0,1,1),
  (44,8,36,0,0,0,0,0,0,1),
  (45,8,36,0,0,0,0,0,1,1),
  (46,8,37,0,0,0,0,0,0,1),
  (47,8,37,0,0,0,0,0,1,1),
  (48,9,1,0,0,0,0,0,0,1),
  (49,9,1,0,0,0,0,0,1,1),
  (50,9,2,0,0,0,0,0,0,1),
  (51,9,2,0,0,0,0,0,1,1),
  (52,9,3,0,0,0,0,0,0,1),
  (53,9,3,0,0,0,0,0,1,1),
  (54,9,4,0,0,0,0,0,0,1),
  (55,9,4,0,0,0,0,0,1,1),
  (56,9,5,0,0,0,0,0,0,1),
  (57,9,5,0,0,0,0,0,1,1),
  (58,9,7,0,0,0,0,0,0,1),
  (59,9,7,0,0,0,0,0,1,1),
  (60,9,35,0,0,0,0,0,0,1),
  (61,9,35,0,0,0,0,0,1,1),
  (62,9,36,0,0,0,0,0,0,1),
  (63,9,36,0,0,0,0,0,1,1),
  (64,9,37,0,0,0,0,0,0,1),
  (65,9,37,0,0,0,0,0,1,1),
  (66,10,1,0,0,0,0,0,0,1),
  (67,10,1,0,0,0,0,0,1,1),
  (68,10,2,0,0,0,0,0,0,1),
  (69,10,2,0,0,0,0,0,1,1),
  (70,10,3,0,0,0,0,0,0,1),
  (71,10,3,0,0,0,0,0,1,1),
  (72,10,4,0,0,0,0,0,0,1),
  (73,10,4,0,0,0,0,0,1,1),
  (74,10,5,0,0,0,0,0,0,1),
  (75,10,5,0,0,0,0,0,1,1),
  (76,10,7,0,0,0,0,0,0,1),
  (77,10,7,0,0,0,0,0,1,1),
  (78,10,35,0,0,0,0,0,0,1),
  (79,10,35,0,0,0,0,0,1,1),
  (80,10,36,0,0,0,0,0,0,1),
  (81,10,36,0,0,0,0,0,1,1),
  (82,10,37,0,0,0,0,0,0,1),
  (83,10,37,0,0,0,0,0,1,1),
  (84,11,1,0,0,0,0,0,0,1),
  (85,11,1,0,0,0,0,0,1,1),
  (86,11,2,0,0,0,0,0,0,1),
  (87,11,2,0,0,0,0,0,1,1),
  (88,11,3,0,0,0,0,0,0,1),
  (89,11,3,0,0,0,0,0,1,1),
  (90,11,4,0,0,0,0,0,0,1),
  (91,11,4,0,0,0,0,0,1,1),
  (92,11,5,0,0,0,0,0,0,1),
  (93,11,5,0,0,0,0,0,1,1),
  (94,11,7,0,0,0,0,0,0,1),
  (95,11,7,0,0,0,0,0,1,1),
  (96,11,35,0,0,0,0,0,0,1),
  (97,11,35,0,0,0,0,0,1,1),
  (98,11,36,0,0,0,0,0,0,1),
  (99,11,36,0,0,0,0,0,1,1),
  (100,11,37,0,0,0,0,0,0,1),
  (101,11,37,0,0,0,0,0,1,1),
  (102,12,1,0,0,0,0,0,0,1),
  (103,12,1,0,0,0,0,0,1,1),
  (104,12,2,0,0,0,0,0,0,1),
  (105,12,2,0,0,0,0,0,1,1),
  (106,12,3,0,0,0,0,0,0,1),
  (107,12,3,0,0,0,0,0,1,1),
  (108,12,4,0,0,0,0,0,0,1),
  (109,12,4,0,0,0,0,0,1,1),
  (110,12,5,0,0,0,0,0,0,1),
  (111,12,5,0,0,0,0,0,1,1),
  (112,12,7,0,0,0,0,0,0,1),
  (113,12,7,0,0,0,0,0,1,1),
  (114,12,35,0,0,0,0,0,0,1),
  (115,12,35,0,0,0,0,0,1,1),
  (116,12,36,0,0,0,0,0,0,1),
  (117,12,36,0,0,0,0,0,1,1),
  (118,12,37,0,0,0,0,0,0,1),
  (119,12,37,0,0,0,0,0,1,1),
  (120,13,1,0,0,0,0,0,0,1),
  (121,13,1,0,0,0,0,0,1,1),
  (122,13,2,0,0,0,0,0,0,1),
  (123,13,2,0,0,0,0,0,1,1),
  (124,13,3,0,0,0,0,0,0,1),
  (125,13,3,0,0,0,0,0,1,1),
  (126,13,4,0,0,0,0,0,0,1),
  (127,13,4,0,0,0,0,0,1,1),
  (128,13,5,0,0,0,0,0,0,1),
  (129,13,5,0,0,0,0,0,1,1),
  (130,13,7,0,0,0,0,0,0,1),
  (131,13,7,0,0,0,0,0,1,1),
  (132,13,35,0,0,0,0,0,0,1),
  (133,13,35,0,0,0,0,0,1,1),
  (134,13,36,0,0,0,0,0,0,1),
  (135,13,36,0,0,0,0,0,1,1),
  (136,13,37,0,0,0,0,0,0,1),
  (137,13,37,0,0,0,0,0,1,1),
  (138,14,1,0,0,0,0,0,0,1),
  (139,14,1,0,0,0,0,0,1,1),
  (140,14,2,0,0,0,0,0,0,1),
  (141,14,2,0,0,0,0,0,1,1),
  (142,14,3,0,0,0,0,0,0,1),
  (143,14,3,0,0,0,0,0,1,1),
  (144,14,4,0,0,0,0,0,0,1),
  (145,14,4,0,0,0,0,0,1,1),
  (146,14,5,0,0,0,0,0,0,1),
  (147,14,5,0,0,0,0,0,1,1),
  (148,14,7,0,0,0,0,0,0,1),
  (149,14,7,0,0,0,0,0,1,1),
  (150,14,35,0,0,0,0,0,0,1),
  (151,14,35,0,0,0,0,0,1,1),
  (152,14,36,0,0,0,0,0,0,1),
  (153,14,36,0,0,0,0,0,1,1),
  (154,14,37,0,0,0,0,0,0,1),
  (155,14,37,0,0,0,0,0,1,1);

COMMIT;

#
# Data for the `orders` table  (LIMIT 0,500)
#

INSERT INTO `orders` (`id`, `from_order_id`, `to_order_id`, `email`, `ip`, `ex_currency_from_id`, `ex_currency_to_id`, `amount_from`, `amount_to`, `sys_comission`, `ex_currency_from_comission`, `ex_currency_to_comission`, `metal_amount_from`, `metal_amount_to`, `metal_sys_comission`, `metal_ex_currency_from_comission`, `metal_ex_currency_to_comission`, `from_info`, `to_info`, `batch_from`, `batch_to`, `regdate`, `type`, `from_status`, `to_status`, `status`, `partner_id`, `partner_amount`, `partner_currency_id`, `real_course`, `ex_course`) VALUES 
  (347,1,10,'denisov_aleksey@mail.ru','87.255.1.16',2,24,34.7,930,0.04,0.01,1,0,0,0,0,0,'','','','','1152725007',1,1,1,1,-1,0,0,NULL,NULL),
  (348,2,11,'denisov_aleksey@mail.ru','87.255.1.16',2,24,34.7,930,0.04,0.01,1,0,0,0,0,0,'','','','','1152905526',1,1,1,1,-1,0,0,NULL,NULL),
  (349,1,3,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490297',1,1,1,1,-1,0,0,NULL,NULL),
  (350,2,4,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490311',1,1,1,1,-1,0,0,NULL,NULL),
  (351,3,5,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490327',1,1,1,1,-1,0,0,NULL,NULL),
  (352,4,6,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490774',1,1,1,1,-1,0,0,NULL,NULL),
  (353,5,7,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490796',1,1,1,1,-1,0,0,NULL,NULL),
  (354,6,8,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490879',1,1,1,1,-1,0,0,NULL,NULL),
  (355,7,9,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490899',1,1,1,1,-1,0,0,NULL,NULL),
  (356,8,10,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490946',1,1,1,1,-1,0,0,NULL,NULL),
  (357,9,11,'','80.249.176.66',5,1,0.06,0.01,0.01,0.01,0.03,0,0,0,0,0,'','','','','1153490970',1,1,1,1,-1,0,0,NULL,NULL),
  (358,12,13,'','80.249.176.66',1,3,0.02,0,0.01,0.01,0,0,0,0,0,0,'','','','','1153491416',1,1,1,1,-1,0,0,NULL,NULL),
  (359,14,12,'asdf@s.dd','80.249.176.66',1,20,930.01,930,0,0.01,0,0,0,0,0,0,'','','','','1153906688',1,1,1,1,-1,0,0,NULL,NULL),
  (360,15,13,'asdf@s.dd','80.249.176.66',1,20,930.01,930,0,0.01,0,0,0,0,0,0,'','','','','1153906803',1,1,1,1,-1,0,0,NULL,NULL),
  (361,16,17,'diny13@mail333.com','87.255.1.16',2,1,0.5,12.87,0.01,0.01,0,0,0,0,0,0,'','','','','1154375181',1,1,1,1,-1,0,0,NULL,NULL),
  (362,18,19,'','80.249.176.66',2,1,0.01,0,0,0.01,0,0,0,0,0,0,'','','','','1154421114',1,1,1,1,-1,0,0,NULL,NULL),
  (363,20,21,'','80.249.176.66',2,1,0.03,0.27,0.01,0.01,0,0,0,0,0,0,'','','','','1154424498',1,1,1,1,-1,0,0,NULL,NULL),
  (364,22,23,'','80.249.176.66',2,1,0.03,0.27,0.01,0.01,0,0,0,0,0,0,'','','','','1154436025',1,1,1,1,-1,0,0,NULL,NULL),
  (365,24,25,'phvoy@mail.ru','87.255.1.16',2,1,0.5,12.87,0.01,0.01,0,0,0,0,0,0,'','','','','1154459839',1,1,1,1,-1,0,0,NULL,NULL),
  (366,26,27,'phvoy@mail.ru','87.255.1.16',2,1,0.5,12.87,0.01,0.01,0,0,0,0,0,0,'','','30942829','30942836','1154459858',1,0,0,0,-1,0,0,NULL,NULL),
  (367,28,29,'alexey@businessmedia.ru','80.249.176.66',2,1,0.03,0.27,0.01,0.01,0,0,0,0,0,0,'','','','','1154506004',1,1,1,1,-1,0,0,NULL,NULL),
  (368,30,31,'alexey@businessmedia.ru','80.249.176.66',2,1,0.09,1.88,0.01,0.01,0,0,0,0,0,0,'','','','','1154506091',1,1,1,1,-1,0,0,NULL,NULL),
  (369,32,33,'alexey@businessmedia.ru','80.249.176.66',2,1,0.04,0.54,0.01,0.01,0,0,0,0,0,0,'','','','','1154506184',1,1,1,1,-1,0,0,NULL,NULL),
  (370,34,35,'alexey@businessmedia.ru','80.249.176.66',2,1,0.03,0.27,0.01,0.01,0,0,0,0,0,0,'','','30961786','30961791','1154507231',1,0,0,0,-1,0,0,NULL,NULL),
  (371,36,37,'alexey@businessmedia.ru','80.249.176.66',1,2,0.16,0.01,0.01,0.01,0,0,0,0,0,0,'','','30961918','30961919','1154507373',1,0,0,0,-1,0,0,NULL,NULL),
  (372,38,14,'cdv@sdf.ff','80.249.176.66',2,18,11.76,314.95,0,0.01,0,0,0,0,0,0,'','','','','1154679813',1,1,1,1,-1,0,0,NULL,NULL),
  (373,39,15,'cdv@sdf.ff','80.249.176.66',2,18,11.76,314.95,0,0.01,0,0,0,0,0,0,'','','','','1154679887',1,1,1,1,-1,0,0,NULL,NULL),
  (374,40,41,'','193.201.98.4',1,2,0.28,0.01,0.01,0.01,0,0,0,0,0,0,'','','','','1155030680',1,1,1,1,-1,0,0,NULL,NULL),
  (375,42,43,'','193.201.98.4',1,2,0.3,0.01,0.01,0.01,0,0,0,0,0,0,'','','','','1155034664',1,1,1,1,-1,0,0,NULL,NULL),
  (376,44,45,'','193.201.98.4',1,2,0.3,0.01,0.01,0.01,0,0,0,0,0,0,'','','','','1155034858',1,1,1,1,-1,0,0,NULL,NULL),
  (377,46,47,'phvoy@mail.ru','87.255.1.16',1,2,15,0.55,0.35,0.01,0,0,0,0,0,0,'','','31275497','31275500','1155065402',1,0,0,0,-1,0,0,NULL,NULL),
  (378,48,16,'asd@asd.dd','192.168.0.9',1,33,150.16,149.99,0.16,0,0.01,0,0,0,0,0,'','','','','1155122042',1,1,1,1,-1,0,0,NULL,NULL),
  (379,49,50,'','192.168.0.9',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1155993260',1,1,1,1,-1,0,0,NULL,NULL),
  (380,51,17,'sdf@asd.dd','192.168.0.9',1,33,150.16,149.99,0.16,0,0.01,0,0,0,0,0,'','','','','1156235431',1,1,1,1,-1,0,0,NULL,NULL),
  (381,52,18,'sdf@asd.dd','192.168.0.9',1,33,150.16,149.99,0.16,0,0.01,0,0,0,0,0,'','','','','1156238339',1,1,1,1,-1,0,0,NULL,NULL),
  (382,53,19,'alexey@businessmedia.ru','192.168.0.9',1,33,150.16,149.99,0.16,0,0.01,0,0,0,0,0,'','','','','1156242689',1,1,1,1,-1,0,0,NULL,NULL),
  (383,54,20,'alexey@businessmedia.ru','192.168.0.9',1,33,150.16,149.99,0.16,0,0.01,0,0,0,0,0,'','','','','1156242806',1,1,1,1,-1,0,0,NULL,NULL),
  (384,1,55,'dimadiv@businessmedia.ru','192.168.0.13',7,1,0.02,0.27,0.01,0,0,0.001524,0,0.000762,0,0,'','','','','1162978115',1,1,1,1,-1,0,0,NULL,NULL),
  (385,10,21,'xtrm@bk.ru','192.168.0.7',5,39,5.62,0.2,0.01,0,0.01,0,0,0,0,0,'','','','','1164993465',1,1,1,1,-1,0,0,NULL,NULL),
  (386,11,22,'xtrm@bk.ru','192.168.0.7',5,39,5.62,0.2,0.01,0,0.01,0,0,0,0,0,'','','','','1164993517',1,1,1,1,-1,0,0,NULL,NULL),
  (387,1,23,'xtrm@bk.ru','192.168.0.7',5,39,5.62,0.2,0.01,0,0.01,0,0,0,0,0,'','','','','1164994182',1,1,1,1,-1,0,0,NULL,NULL),
  (388,2,56,'xtrm@bk.ru','192.168.0.7',40,1,1.01,1,0.01,0,0,0,0,0,0,0,'','','','','1165064226',1,1,1,1,-1,0,0,NULL,NULL),
  (389,3,57,'xtrm@bk.ru','192.168.0.7',40,1,1.01,1,0.01,0,0,0,0,0,0,0,'','','','','1165064884',1,1,1,1,-1,0,0,NULL,NULL),
  (390,2,58,'','192.168.0.18',7,3,1,0.76,0.01,0,0.01,0.076178,0,0.000762,0,0,'','','','','1165314723',1,1,1,1,-1,0,0,NULL,NULL),
  (391,59,60,'','192.168.0.2',1,2,10,0.37,0.23,0,0,0,0,0,0,0,'','','','','1166100852',1,1,1,1,-1,0,0,NULL,NULL),
  (392,3,4,'','192.168.0.2',7,9,0.03,0.01,0.01,0,0.01,0.002285,0.000363,0.000762,0,0.000363,'','','','','1168962261',1,1,1,1,-1,0,0,NULL,NULL),
  (393,5,6,'','192.168.0.17',10,7,56,54.88,0.57,0,0.55,7.380491,4.180652,0.075123,0,0.041898,'','','','','1169025409',1,1,1,1,-1,0,0,NULL,NULL),
  (394,61,7,'','192.168.0.17',1,7,12,0.43,0.12,0,0.02,0,0.032757,0,0,0.001524,'','','','','1169051140',1,1,1,1,-1,0,0,NULL,NULL),
  (395,4,62,'','192.168.0.17',5,2,50,1.88,0.5,0,0,0,0,0,0,0,'','','','','1169132775',1,1,1,1,-1,0,0,NULL,NULL),
  (396,5,63,'','192.168.0.17',5,3,44,1.25,0.44,0,0.01,0,0,0,0,0,'','','','','1169132833',1,1,1,1,-1,0,0,NULL,NULL),
  (397,64,24,'anton@businessmedia.ru','192.168.0.2',1,39,5.53,0.2,0.01,0,0.01,0,0,0,0,0,'','','','','1169749707',1,1,1,1,24,0,4,NULL,NULL),
  (398,6,25,'anton@businessmedia.ru','192.168.0.2',5,39,5.53,0.2,0.01,0,0.01,0,0,0,0,0,'','','','','1169749761',1,1,1,1,24,0,4,NULL,NULL),
  (399,65,66,'anton@businessmedia.ru','192.168.0.2',2,1,0.02,0.26,0.01,0,0,0,0,0,0,0,'','','','','1170159767',1,1,1,1,24,0,4,NULL,NULL),
  (400,67,68,'anton@businessmedia.ru','192.168.0.2',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1170507639',1,1,1,1,24,0,4,NULL,NULL),
  (401,69,70,'anton@businessmedia.ru','192.168.0.2',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1170508389',1,1,1,1,24,0,4,NULL,NULL),
  (402,71,72,'anton@businessmedia.ru','192.168.0.2',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1170508456',1,1,1,1,-1,0,0,NULL,NULL),
  (403,73,74,'anton@businessmedia.ru','192.168.0.2',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1170508567',1,1,1,1,-1,0,0,NULL,NULL),
  (404,75,76,'anton@businessmedia.ru','192.168.0.2',1,2,1,0.04,0.03,0,0,0,0,0,0,0,'','','','','1170508601',1,1,1,1,-1,0,0,NULL,NULL),
  (405,77,78,'','192.168.0.7',1,2,50.13,1.99,0,0,0.02,0,0,0,0,0,'','','','','1172748069',1,1,1,1,-1,0,0,NULL,NULL),
  (406,79,80,'','192.168.0.7',1,2,50.13,1.99,0,0,0.02,0,0,0,0,0,'','','','','1172748236',1,1,1,1,-1,0,0,NULL,NULL),
  (407,81,82,'','192.168.0.7',1,2,50.12,2.03,-1.25,0,0.02,0,0,0,0,0,'','','','','1172749277',1,1,1,1,-1,0,0,NULL,NULL),
  (408,83,84,'','192.168.0.7',1,2,50.12,1.95,0.75,0,0.02,0,0,0,0,0,'','','','','1172749322',1,1,1,1,-1,0,0,NULL,NULL),
  (409,85,86,'','80.249.176.66',1,2,1.1,0.04,-0.27,0,0.01,0,0,0,0,0,'','','','','1172757344',1,1,1,1,-1,0,0,NULL,NULL),
  (410,87,88,'','80.249.176.66',1,2,1.1,0.04,-0.27,0,0.01,0,0,0,0,0,'','','45123761','','1172757368',1,0,1,1,-1,0,0,NULL,NULL),
  (411,89,8,'','192.168.0.7',1,7,1.09,0.04,0,0,0,0,0.001586,0,0,0.00028,'','','45128747','76912782','1172760099',1,0,0,0,-1,0,0,NULL,NULL),
  (412,90,9,'','80.249.176.66',1,7,26.7,0.98,1.05,0,0,0,0.042985,0,0,0.002488,'','','45129086','76912861','1172760289',1,0,0,0,-1,0,0,NULL,NULL),
  (413,10,91,'','80.249.176.66',7,1,0.12,3.21,-0.01,0.01,0.03,0.005568,0,-0.000597,0.000467,0,'','','76913080','','1172760448',1,0,1,1,-1,0,0,NULL,NULL),
  (414,11,92,'','80.249.176.66',7,1,9,240.57,-0.4,0.09,1.93,0.41943,0,-0.018522,0.008989,0,'','','76913511','','1172760956',1,0,1,1,-1,0,0,NULL,NULL),
  (415,12,93,'','80.249.176.66',7,1,7.23,193.26,-0.34,0.17,1.55,0.335451,0,-0.015543,0.007931,0,'','','76914218','','1172761877',1,0,1,1,-1,0,0,NULL,NULL),
  (416,94,95,'','80.249.176.66',1,2,1.1,0.04,-0.26,0,0.01,0,0,0,0,0,'','','','','1172762646',1,1,1,1,-1,0,0,0,NULL),
  (417,13,96,'','80.249.176.66',10,2,1.09,0.04,-0.26,0.02,0.01,0.095501,0,-0.02278,0.001752,0,'','','','','1172762845',1,1,1,1,-1,0,0,0.0367,NULL),
  (418,14,97,'','80.249.176.66',7,1,6.76,180.69,-0.224067,0.17,1.45,0.313741,0,-0.014787,0.007683,0,'','','76915594','','1172763292',1,0,1,1,-1,0,0,26.73,NULL),
  (419,15,98,'','80.249.176.66',7,1,5,125,-0.18,0.14,1,0.231876,0,0.003428,0.006656,0,'','','76915787','','1172763482',1,0,1,1,-1,0,0,25,NULL),
  (420,16,99,'','80.249.176.66',8,1,1,26.73,-0.03,0,0.22,2.199678,0,-0.06599,0,0,'','','','','1172763961',1,1,1,1,-1,0,0,26.1366,26.73),
  (421,17,100,'','80.249.176.66',7,1,1,25,0.03,0.01,0.2,0.046395,0,0.001392,0.000464,0,'','','','','1172763996',1,1,1,1,-1,0,0,26.1366,25),
  (422,18,101,'','80.249.176.66',7,1,4.99,124.75,0.13,0.05,1,0.231513,0,0.006031,0.00232,0,'','','','','1172764068',1,1,1,1,-1,0,0,26.1366,25),
  (423,19,102,'','80.249.176.66',7,1,6,150,0.055009,0.16,1.2,0.278843,0,0.004888,0.007247,0,'','','76916382','','1172764292',1,0,1,1,-1,0,0,26.1366,25),
  (424,20,103,'','80.249.176.66',7,1,7,175,0.18,0.07,1.4,0.324768,0,0.008351,0.003248,0,'','','','','1172764775',1,1,1,1,-1,0,0,26.1366,25),
  (425,21,104,'','80.249.176.66',7,1,5.87,146.75,0.060121,0.15,1.18,0.271844,0,0.004655,0.007154,0,'','','76916695','','1172764890',1,0,1,1,-1,0,0,26.1366,25),
  (426,22,26,'dima@businessmedia.ru','80.249.176.66',7,39,0.23,0.23,-0.02,0.02,0,0.010668,0,-0.000752,0.000746,0,'','','76919800','','1172768492',1,0,0,0,-1,0,0,1,0.99);

COMMIT;

#
# Data for the `pages` table  (LIMIT 0,500)
#

INSERT INTO `pages` (`id`, `name`, `title`, `pseudo_name`, `content`, `status`) VALUES 
  (3,' ',' ','contacts',' ',1),
  (4,' ','   SmartExchanger','buy','<P>       <A href=\\\"http://www.smartexchanger.ru\\\">www.smartexchanger.ru</A></P>',1);

COMMIT;

#
# Data for the `partner_clicks` table  (LIMIT 0,500)
#

INSERT INTO `partner_clicks` (`id`, `partner_id`, `partner_website_id`, `ip`, `ip_country_id`, `proxy_ip`, `proxy_country_id`, `proxy_type`, `regdate`, `user_agent`, `is_unique`, `partner_amount`, `partner_currency_id`, `referer`) VALUES 
  (22,0,NULL,'192.168.0.3',0,NULL,0,0,1142100088,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.1) Gecko/20060111 Firefox/1.5.0.1',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (23,3,NULL,'192.168.0.3',0,NULL,0,0,1142239286,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.1) Gecko/20060111 Firefox/1.5.0.1',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (24,3,NULL,'192.168.0.3',0,NULL,0,0,1142239350,'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (25,3,NULL,'192.168.0.3',0,NULL,0,0,1142242304,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.1) Gecko/20060111 Firefox/1.5.0.1',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (26,3,NULL,'192.168.0.7',0,NULL,0,0,1142242471,'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (27,3,NULL,'192.168.0.3',0,NULL,0,0,1142242872,'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (28,3,NULL,'192.168.0.3',0,NULL,0,0,1142243990,'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)',NULL,NULL,NULL,'http://smartex.local/xx.html'),
  (29,3,NULL,'192.168.0.3',0,NULL,0,0,1142513215,'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; MyIE2)',NULL,NULL,NULL,'http://smartex.local/partner/ads/index_c.php'),
  (30,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1169735661,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://www.aliry.com/partner/'),
  (31,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1169735992,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,''),
  (32,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1169738002,'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (33,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1169738202,'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (34,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171961279,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (35,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171961292,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (36,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171961298,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (37,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171961627,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (38,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171961634,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://aliry.com/partner/'),
  (39,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171991523,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,''),
  (40,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171991552,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://smartex.local/bannners.html'),
  (41,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171991556,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://smartex.local/bannners.html'),
  (42,24,NULL,'192.168.0.14',0,'192.168.0.2',0,1,1171991562,'Opera/9.10 (Windows NT 5.1; U; en)',NULL,NULL,NULL,'http://smartex.local/bannners.html');

COMMIT;

#
# Data for the `partner_payouts` table  (LIMIT 0,500)
#

INSERT INTO `partner_payouts` (`id`, `partner_id`, `trn_id`, `payout_method_id`, `amount`, `currency_id`, `partner_amount`, `partner_currency_id`, `regdate`, `description`, `properties`, `status`, `payee_purse`) VALUES 
  (45,3,33,NULL,100,NULL,0,0,1156785412,'',NULL,0,NULL),
  (46,3,33,NULL,100,NULL,0,0,1156785412,'',NULL,0,NULL),
  (47,3,34,NULL,100,NULL,0,0,1156791139,'',NULL,0,NULL),
  (48,3,35,NULL,100,NULL,0,0,1156791567,'',NULL,0,NULL),
  (49,3,36,NULL,900,NULL,0,0,1156847338,'',NULL,0,NULL);

COMMIT;

#
# Data for the `partner_transactions` table  (LIMIT 0,500)
#

INSERT INTO `partner_transactions` (`id`, `partner_id`, `partner_website_id`, `description`, `regdate`, `amount`, `currency_id`, `partner_amount`, `partner_currency_id`, `rest_amount`, `rest_currency_id`, `ref_partner_id`, `order_id`, `status`) VALUES 
  (21,3,NULL,'  ',1142239068,10,4,0,NULL,10,4,NULL,-1,NULL),
  (23,3,NULL,'',1156783669,1,NULL,NULL,NULL,1,NULL,NULL,0,1),
  (24,3,NULL,'',1156783709,1,NULL,NULL,NULL,1,NULL,NULL,0,1),
  (25,3,NULL,'',1156783793,1,NULL,NULL,NULL,1,NULL,NULL,0,1),
  (26,3,NULL,'',1156783993,-99,NULL,NULL,NULL,1,NULL,NULL,0,1),
  (27,3,NULL,'',1156783996,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (28,3,NULL,'',1156783997,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (29,3,NULL,'',1156783997,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (30,3,NULL,'',1156784985,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (31,3,NULL,'',1156785131,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (32,3,NULL,'',1156785219,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (33,3,NULL,'',1156785412,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (34,3,NULL,'',1156791138,-100,NULL,NULL,NULL,0,NULL,NULL,0,1),
  (35,3,NULL,'',1156791567,-100,NULL,NULL,NULL,900,NULL,NULL,0,1),
  (36,3,NULL,'',1156847338,-900,NULL,NULL,NULL,0,NULL,NULL,0,1);

COMMIT;

#
# Data for the `partners` table  (LIMIT 0,500)
#

INSERT INTO `partners` (`id`, `login`, `password`, `email`, `site_name`, `site_url`, `reg_ip`, `withdraw_properties`, `amount`, `regdate`, `program_type`, `comments`, `trans_notify`, `status`, `activation_code`, `currency_id`, `payout_perc`, `ref_partner_id`) VALUES 
  (16,'alexey','b0baee9d279d34fa1dfd71aadb908c3f','alexey@businessmedia.ru','sdf','http://www.business.ru','80.249.176.66',NULL,0,1154680203,NULL,NULL,0,1,'jVBOOTV9604Nuv6ps949nxpe1',4,'0.05',0),
  (17,'sdfasdf','b0baee9d279d34fa1dfd71aadb908c3f','alexey@businessmedia.ru','sdfsdf','http://dfg.gg','192.168.0.9',NULL,0,1155127248,NULL,NULL,0,0,'sVeEj1KHgpYyuxs9aAjQzQh7d',4,'0.05',0),
  (18,'sdf1asdf','b0baee9d279d34fa1dfd71aadb908c3f','alexey@businessmedia.ru','sdfsdf','http://dfg.gg','192.168.0.9',NULL,0,1155127303,NULL,NULL,0,0,'0lm54vTrDysQu3fx09DS61p1d',4,'0.05',0),
  (19,'alexey1','96e79218965eb72c92a549dd5a330112','alexey@businessmedia.ru','sdfsdf','http://dfg.gg','192.168.0.9',NULL,0,1155127455,NULL,NULL,0,0,'175ZU4wT9lzN1k5e3iVp20Mho',4,'0.05',0),
  (20,'dfgdfg','7fa8282ad93047a4d6fe6111c93b308a','alexey@businessmedia.ru','gg','http://asdsf.dd','192.168.0.9',NULL,0,1156236233,NULL,NULL,0,0,'MYtWNNdXPHnRTn1T30UFH375a',4,'0.05',0),
  (21,'asddfsdf','b0baee9d279d34fa1dfd71aadb908c3f','alexey@businessmedia.ru','sdf','http://asdsf.dd','192.168.0.9',NULL,0,1156236858,NULL,NULL,0,1,'',4,'0.05',0),
  (22,'mshonich','e10adc3949ba59abbe56e057f20f883e','mshonich@businessmedia.ru',' ','http://lleo.aha.ru/na/index.shtml','80.249.176.66',NULL,0,1156844967,NULL,NULL,0,0,'IgU51X4AT6f2z8645z4BxHgqR',4,'0.05',0),
  (23,'dmitrij','3dda0768a1df419e7836002b44b8edc7','dima@businessmedia.ru','','http://eee.eee.ee','192.168.0.7',NULL,0,1164992286,NULL,NULL,0,1,'',4,'0.05',0),
  (24,'admin','21232f297a57a5a743894a0e4a801fc3','anton@businessmedia.ru','businessmedia.ru','businessmedia.ru','192.168.0.14',NULL,0,1169735407,NULL,NULL,0,1,'',4,'0.05',0);

COMMIT;

#
# Data for the `payments` table  (LIMIT 0,500)
#

INSERT INTO `payments` (`id`, `client_id`, `exchange_way_id`, `in_amount`, `out_amount`, `sys_com`, `ex_from_com`, `ex_to_com`, `offline_method_params`, `ex_currency_params`, `pm_params`, `regdate`, `status`) VALUES 
  (17,3,12,1000,999.99,0,0.01,0,NULL,NULL,'a:6:{s:11:\"exch_way_id\";s:2:\"12\";s:15:\"receiver_region\";s:1:\"0\";s:4:\"city\";s:9:\"sdfsdfsdf\";s:14:\"sender_country\";s:10:\"sfsdfsdfsd\";s:8:\"wm_purse\";s:13:\"R123456789012\";s:4:\"stat\";s:1:\"3\";}',1156442658,3),
  (18,3,139,10000,9999.98,0,0.01,0.01,NULL,NULL,'a:8:{s:11:\"exch_way_id\";s:3:\"139\";s:8:\"wm_purse\";s:13:\"R111111111112\";s:9:\"bank_name\";s:7:\"werwerw\";s:3:\"inn\";s:7:\"2342342\";s:9:\"k_account\";s:19:\"3444444444442222222\";s:3:\"bic\";s:20:\"44444444444444444444\";s:7:\"account\";s:20:\"23222222222222222222\";s:6:\"ground\";s:8:\"fsfsfrwe\";}',1156494803,0),
  (19,3,12,1000,968.99,31,0.01,0,NULL,NULL,'a:5:{s:11:\"exch_way_id\";s:2:\"12\";s:15:\"receiver_region\";s:1:\"0\";s:4:\"city\";s:6:\"sdfsdf\";s:14:\"sender_country\";s:6:\"sfsdfs\";s:8:\"wm_purse\";s:13:\"R111111111112\";}',1156521694,0),
  (20,3,12,1001,969.96,31.03,0.01,0,NULL,NULL,'a:4:{s:11:\"exch_way_id\";s:2:\"12\";s:4:\"city\";s:9:\"sdfsdfsdf\";s:14:\"sender_country\";s:5:\"dfsfd\";s:8:\"wm_purse\";s:13:\"R111111111112\";}',1156592770,0),
  (21,4,102,100,2673.21,0,0.01,0,NULL,NULL,'a:2:{s:11:\"exch_way_id\";s:3:\"102\";s:8:\"wm_purse\";s:13:\"R123123123123\";}',1156845506,0),
  (22,4,121,100.01,99.99,0,0.01,0.01,NULL,NULL,'a:2:{s:11:\"exch_way_id\";s:3:\"121\";s:8:\"wm_purse\";s:13:\"R123123123123\";}',1156845740,0),
  (23,5,12,10000,9698.99,301,0.01,0,NULL,NULL,'a:4:{s:11:\"exch_way_id\";s:2:\"12\";s:4:\"city\";s:6:\"\";s:14:\"sender_country\";s:6:\"\";s:8:\"wm_purse\";s:13:\"R322959982077\";}',1156888966,0);

COMMIT;

#
# Data for the `pincode_collections` table  (LIMIT 0,500)
#

INSERT INTO `pincode_collections` (`id`, `name`, `currency_id`, `sell_price`, `buy_price`) VALUES 
  (14,'  ',1,2,1),
  (13,'SmartExchanger',4,0.2,0.1);

COMMIT;

#
# Data for the `pincode_orders` table  (LIMIT 0,500)
#

INSERT INTO `pincode_orders` (`id`, `pincode`, `type`, `status`) VALUES 
  (9,'1858391234091234',0,0),
  (8,'1628403923',0,1),
  (7,'1239874019238740',1,0),
  (10,'',1,1),
  (11,'',1,1),
  (12,'',1,1),
  (13,'',1,1),
  (14,'',1,1),
  (15,'',1,1),
  (16,'',1,1),
  (17,'',1,1),
  (18,'',1,1),
  (19,'',1,1),
  (20,'',1,1),
  (21,'',1,1),
  (22,'',1,1),
  (23,'',1,1),
  (24,'',1,1),
  (25,'',1,1),
  (26,'1',1,0);

COMMIT;

#
# Data for the `pincodes` table  (LIMIT 0,500)
#

INSERT INTO `pincodes` (`id`, `collection_id`, `code`, `status`) VALUES 
  (10,6,'1234 2341234 123412','used'),
  (24,13,'1','used'),
  (25,13,'2','valid'),
  (26,14,'2','used'),
  (27,14,'3','used');

COMMIT;

#
# Data for the `system_settings` table  (LIMIT 0,500)
#

INSERT INTO `system_settings` (`param_name`, `param_value`) VALUES 
  ('default_click_next_level_mult',''),
  ('default_click_up_limit','300'),
  ('default_click_down_limit','800'),
  ('default_click_amount_per_batch','2000'),
  ('default_click_price','0.01'),
  ('partner_payout_timeout','30'),
  ('html_editor_path','/htmleditor'),
  ('admin_pages_per_block','10'),
  ('admin_items_per_page','20'),
  ('admin_email','dima@businessmedia.ru'),
  ('default_click_up_mult','1.2'),
  ('default_sale_comission_perc','0.2'),
  ('default_sale_refund_comission_fix','2'),
  ('default_form_coeff','0.9'),
  ('partner_min_payout','3000'),
  ('clean_timeout','240'),
  ('partner_cookie_name','partner_arr'),
  ('default_sale_comission_fix','10'),
  ('cookie_timeout','30'),
  ('default_sale_currency_id','3'),
  ('use_wysiwyg','1'),
  ('site_name','SmartExchanger'),
  ('site_url',''),
  ('block_on_ip','192.168.0.2'),
  ('support_email','dima@businessmedia.ru'),
  ('billing_email','dima@businessmedia.ru'),
  ('webmaster_email','dima@businessmedia.ru'),
  ('admin_dir','/admin'),
  ('course_precision','4');

COMMIT;

#
# Data for the `system_settings_backup` table  (LIMIT 0,500)
#

INSERT INTO `system_settings_backup` (`param_name`, `param_value`) VALUES 
  ('default_click_next_level_mult',''),
  ('default_click_up_limit','300'),
  ('default_click_down_limit','800'),
  ('default_click_amount_per_batch','2000'),
  ('default_click_price','0.01'),
  ('partner_payout_timeout','30'),
  ('html_editor_path','/htmleditor'),
  ('admin_pages_per_block','10'),
  ('admin_items_per_page','20'),
  ('admin_email','dima@businessmedia.ru'),
  ('default_click_up_mult','1.2'),
  ('default_sale_comission_perc','0.2'),
  ('default_sale_refund_comission_fix','2'),
  ('default_form_coeff','0.9'),
  ('partner_min_payout','3000'),
  ('clean_timeout','240'),
  ('partner_cookie_name','partner_arr'),
  ('default_sale_comission_fix','10'),
  ('cookie_timeout','30'),
  ('default_sale_currency_id','3'),
  ('use_wysiwyg','1'),
  ('site_name','SmartExchanger'),
  ('site_url','smartex.local');

COMMIT;

#
# Data for the `turings` table  (LIMIT 0,500)
#

INSERT INTO `turings` (`session`, `code`, `heure`) VALUES 
  ('0a7aac11809a176b42e2fb16a28c4672','8718',1156937103),
  ('0b62dca66516a8a1333b38bd5920569f','5532',1156937231),
  ('0dc4948e8157c3602947f4a8daddd537','1167',1156936979),
  ('2355d41d78c760e1e36313d6668a4ffa','2315',1156936889),
  ('316908c9b59bef4bd029cdcbb37bf904','7711',1156937158),
  ('35c421e4c337ae7c7dd13f558c8e939c','9557',1156936244),
  ('3a59cd948f1fe74834215d3b7881f892','2869',1156936891),
  ('3fa7ce2216bc24458890b7f56327e8eb','1587',1156936242),
  ('4387b08b434bf79d66c93d93d2382ec4','1342',1156937102),
  ('445b4859b3877312f9e099e02470c4a1','8614',1156936878),
  ('4764f0a90a21556059a9132428eb9e0b','1749',1156936882),
  ('47e7bfbcaa0aed68c8bc2c92269490c9','7349',1156936980),
  ('4bcaff03043fc4c6f58e4433ee97bf5c','4253',1156937209),
  ('5009b646535fa27c38f5f447f28e4cae','2828',1156936945),
  ('5f857a1c51fb578a9119593b708d4e76','1245',1156936875),
  ('646421c25f1115142af6d394acd43e03','4289',1156937098),
  ('87d303b2baa7cd5c60b4c204d17ea6d0','1417',1156937156),
  ('901da298158775b5d07bca1794af8db3','6763',1156936942),
  ('991e5eba3696012a30fe6d1cbee26624','3327',1156937145),
  ('a31555e10a2205ba0c0ea0ac77467fed','8902',1156937166),
  ('a61f5b43f01b25913f921e3e620609d6','4779',1156937188),
  ('ad1b74238a7111d73449dc6dd1b2eff7','9843',1156937224),
  ('b29d55c25fbddd978a73b288d77a175e','4921',1156936986),
  ('c50fbdcbf5bc71a1dab8d071cb5f2b33','4078',1156936232),
  ('c928c13225d337332b69bd0b9de2bc7b','9201',1156936886),
  ('ca6a04744a1cd8232d0900e14a3af794','2572',1156937052),
  ('d75b096788f49443c9f1ab930e83ca3f','2414',1156936977),
  ('e2ba21732335ad9ee48dc1364fefad4d','4695',1156937150),
  ('f5cc0c4aa00c9927d059065d053e59aa','4802',1156937157),
  ('ff723c3f336ae8278063ada5a66fb49e','5493',1156936880);

COMMIT;

#
# Data for the `wm_orders` table  (LIMIT 0,500)
#

INSERT INTO `wm_orders` (`id`, `payer_purse`, `payer_wm`, `payee_purse`, `payee_wm`, `sys_invs_no`, `sys_trans_no`, `sys_trans_date`, `type`, `status`) VALUES 
  (1,'','','Z360590729781','384598374655','','','',0,1),
  (2,'','','Z360590729781','384598374655','','','',0,1),
  (3,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (4,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (5,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (6,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (7,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (8,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (9,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (10,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (11,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (12,'','','R178129517453','384598374655','','','',0,1),
  (13,'','384598374655','E111111111111','','','','',1,1),
  (14,'','','R178129517453','384598374655','','','',0,1),
  (15,'','','R178129517453','384598374655','','','',0,1),
  (16,'','','Z360590729781','384598374655','','','',0,1),
  (17,'R178129517453','384598374655','R190132222684','','','','',1,1),
  (18,'','','Z360590729781','384598374655','','','',0,1),
  (19,'R178129517453','384598374655','R111111111111','','','','',1,1),
  (20,'','','Z360590729781','384598374655','','','',0,1),
  (21,'R178129517453','384598374655','R417107351254','','','','',1,1),
  (22,'','','Z360590729781','384598374655','','','',0,1),
  (23,'R178129517453','384598374655','R428507982497','','','','',1,1),
  (24,'','','Z360590729781','384598374655','','','',0,1),
  (25,'R178129517453','384598374655','R190132222684','','','','',1,1),
  (26,'Z938328250863','816532551251','Z360590729781','384598374655','17857763','30942829','20060801 23:18:01',0,0),
  (27,'R178129517453','384598374655','R190132222684','','','30942836','',1,0),
  (28,'','','Z360590729781','384598374655','','','',0,1),
  (29,'R178129517453','384598374655','R428507982497','','','','',1,1),
  (30,'','','Z360590729781','384598374655','','','',0,1),
  (31,'R178129517453','384598374655','R428507982497','','','','',1,1),
  (32,'','','Z360590729781','384598374655','','','',0,1),
  (33,'R178129517453','384598374655','R428507982497','283088460502','','','',1,1),
  (34,'Z149558234565','108174886228','Z360590729781','384598374655','17867339','30961786','20060802 12:27:02',0,0),
  (35,'R178129517453','384598374655','R172842498977','','','30961791','',1,0),
  (36,'R172842498977','108174886228','R178129517453','384598374655','17867394','30961918','20060802 12:29:02',0,0),
  (37,'Z360590729781','384598374655','Z149558234565','','','30961919','',1,0),
  (38,'','','Z360590729781','384598374655','','','',0,1),
  (39,'','','Z360590729781','384598374655','','','',0,1),
  (40,'','','R178129517453','384598374655','','','',0,1),
  (41,'Z360590729781','384598374655','Z012345678912','','','','',1,1),
  (42,'','','R178129517453','384598374655','','','',0,1),
  (43,'Z360590729781','384598374655','Z012345678901','','','','',1,1),
  (44,'','','R178129517453','384598374655','','','',0,1),
  (45,'Z360590729781','384598374655','Z012345678901','','','','',1,1),
  (46,'R190132222684','816532551251','R178129517453','384598374655','18026293','31275497','20060808 23:30:08',0,0),
  (47,'Z360590729781','384598374655','Z938328250863','','','31275500','',1,0),
  (48,'','','R397656178472','','','','',0,1),
  (49,'','','R397656178472','','','','',0,1),
  (50,'Z397656178472','','Z111111111111','','','','',1,1),
  (51,'','','R397656178472','','','','',0,1),
  (52,'','','R397656178472','','','','',0,1),
  (53,'','','R397656178472','','','','',0,1),
  (54,'','','R397656178472','','','','',0,1),
  (55,'R397656178472','','','','','','',1,1),
  (56,'R397656178472','','','','','','',1,1),
  (57,'R397656178472','','','','','','',1,1),
  (58,'','','E116135691554','','','','',1,1),
  (59,'','','R397656178472','','','','',0,1),
  (60,'Z397656178472','','','','','','',1,1),
  (61,'','','R397656178472','','','','',0,1),
  (62,'Z397656178472','','','','','','',1,1),
  (63,'','','E394555660507','','','','',1,1),
  (64,'','','R397656178472','','','','',0,1),
  (65,'','','Z397656178472','','','','',0,1),
  (66,'R397656178472','','','','','','',1,1),
  (67,'','','R397656178472','','','','',0,1),
  (68,'Z397656178472','','','','','','',1,1),
  (69,'','','R397656178472','','','','',0,1),
  (70,'Z397656178472','','','','','','',1,1),
  (71,'','','R397656178472','','','','',0,1),
  (72,'Z397656178472','','','','','','',1,1),
  (73,'','','R397656178472','','','','',0,1),
  (74,'Z397656178472','','','','','','',1,1),
  (75,'','','R397656178472','','','','',0,1),
  (76,'Z397656178472','','','','','','',1,1),
  (77,'','','R397656178472','','','','',0,1),
  (78,'Z397656178472','','Z642588057525','','','','',1,1),
  (79,'','','R397656178472','','','','',0,1),
  (80,'Z397656178472','','Z642588057525','','','','',1,1),
  (81,'','','R397656178472','','','','',0,1),
  (82,'Z397656178472','','Z642588057525','','','','',1,1),
  (83,'','','R397656178472','','','','',0,1),
  (84,'Z397656178472','','Z642588057525','','','','',1,1),
  (85,'','','R427824053825','393703328897','','','',0,1),
  (86,'Z276527212435','393703328897','Z353069060723','','','','',1,1),
  (87,'R304179126687','393703328897','R427824053825','393703328897','24863292','45123761','20070301 16:56:01',0,0),
  (88,'Z276527212435','393703328897','Z353069060723','','','','',1,1),
  (89,'R304179126687','393703328897','R427824053825','393703328897','24865628','45128747','20070301 17:41:01',0,0),
  (90,'R304179126687','393703328897','R427824053825','393703328897','24865807','45129086','20070301 17:45:01',0,0),
  (91,'R427824053825','393703328897','R272585998238','','','','',1,1),
  (92,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (93,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (94,'','','R427824053825','393703328897','','','',0,1),
  (95,'Z276527212435','393703328897','Z353069060723','','','','',1,1),
  (96,'Z276527212435','393703328897','Z353069060723','','','','',1,1),
  (97,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (98,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (99,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (100,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (101,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (102,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (103,'R427824053825','393703328897','R304179126687','','','','',1,1),
  (104,'R427824053825','393703328897','R304179126687','','','','',1,1);

COMMIT;

#
# Data for the `yandex_orders` table  (LIMIT 0,500)
#

INSERT INTO `yandex_orders` (`id`, `shop_user_id`, `shop_user_name`, `shop_cypher`, `payer_account_id`, `payer_account`, `payer_bank`, `payee_account_id`, `payee_account`, `payee_bank`, `paymentid`, `paymentcurrency`, `contractdatetime`, `authorizationtime`, `type`, `status`) VALUES 
  (1,'','','','','','','','','1001','','643','','',0,1),
  (2,'','','','','','','','','1001','','643','','',0,1),
  (3,'','','','','','','','','1001','','643','','',0,1),
  (4,'','','','','','','','','1001','','643','','',0,1),
  (5,'','','','','','','','','1001','','643','','',0,1),
  (6,'','','','','','','','','1001','','643','','',0,1),
  (7,'','','','','','','','','1001','','643','','',0,1),
  (8,'','','','','','','','','1001','','643','','',0,1),
  (9,'','','','','','','','','1001','','643','','',0,1),
  (10,'','','','','','','','','1001','','643','','',0,1),
  (11,'','','','','','','','','1001','','643','','',0,1);

COMMIT;



/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
