<?php
/**
 * @class Pagination() - Класс постраничного разбиения контента
 * @author  mazaHELL
 * @contact ICQ 4-208-606
 * @mail    aso87@meta.ua
 * @skype   sergey.arendarchuk, mazahell
 *
 * Входные параметры
 * @param $input     - массив данных ( array() - для файлов, текста, int() - для записей из бд )
 * @param $on_page   - сколько результатов выводить на странице ( int() )
 * @param $link      - форматированная строка запроса ('file.php?dir=photo&p=:page&last') :page заменяется на нужные страницы, слеш в начале не нужен
 * @param $_GET['p'] - параметр отвечающий за считывание страницы из строки адреса
 *
 * #----------  Пример использования ----------#
 * 
 * 1.Навигация для записей в базе данных БД
 * // считаем все поля которые подходят для вывода
 * $allfield = mysql_result(mysql_query("select count(*) from `TABLE`;"),0);
 *
 * $newlist = new Pagination($allfield, // кол-во полей для вывода
 *                           5);        // выводить 5 записей на страницу
 *                           
 *  
 * $query = mysql_query("select * from `TABLE` order by `id` asc limit ". $newlist->limit().";");
 * while($res = mysql_fetch_assoc($query))
 * {
 *   echo $res['field'].'<br />';
 * }
 * echo $newlist->pagination();
 * 
 * #-------------------------------------------#
 * 2. Навигация для файлов/текста
 * 
 * $file = array('1.jpg', '2.jpg', '3.jpg', '4.jpg');
 * $newlist = new Pagination($file, // массив с файлами или текстом (разбитым по словам и загнан в массив)
 *                           5);    // 5 елементов на страницу 
 * foreach($newlist->result_array() as $val)
 * {
 *   echo $val.'<br />';
 * }
 * echo $newlist->pagination();
 * 
 * #----------   Методы                  ----------#
 * @method $newlist->result_array();    - результирующий массив файлов, на страницу
 * @method $newlist->pagination();      - выводит строку ссылок на страницы
 * @method $newlist->info();            - показывает информацию сколько всего файлов(+параметры)
 * @method $newlist->show_form();       - показывает форму быстрого перехода(+параметры)
 * @method $newlist->limit();           - лимит, при использовании БД
 *
 * #----------   Дополнительные свойства ----------#
 * 
 * 1. Чтоб при заходе на страницу с постраничной навигацией, сразу кидало
 *    на последнюю страницу - добавьте к ссылке _GET параметр "last"
 *    ( например "list.php?last" )
 *
 * 2. Ненужные или запрещенные файлы к показу, надо зараннее выбросить из массива $input
 *    ("." , ".." , ".htaccess" к примеру)
 */
class Pagination {
public function __construct($input, $on_page, $link = '')
{
    /** если входящий массив */
    if(is_array($input))
    {
        $this->rfile = array_values($input);
        $this->all_elements = count($this->rfile);
    }
    else
    {
        $this->all_elements = $input;
    }
    /** линк который цеплять к ссылкам постранички */
    $this->link = $link;
    /** сколько результатов на страницу */
    $this->on_page = $on_page < 1 ? 5 : $on_page;
    /** всего страниц */
    $this->all_pages = ceil($this->all_elements / $this->on_page);
    /** если не установлен $_GET['p'] = он равен 1, иначе равен установленному $_GET['p'] */
    $this->page = !isset($_GET['p']) || $_GET['p'] <= 0 ? 1 : abs(intval($_GET['p']));
    /** если $_GET['p'] больше всех страниц - он равен последней странице, иначе текущей */
    $this->page = $this->page > $this->all_pages ? $this->all_pages : $this->page;
    /** если установлен $_GET['last'] бросаем на последнюю страницу */
    $this->page = isset($_GET['last']) ? $this->all_pages : $this->page;    
    /** старт и конец отсчета файлов в массиве */
    $this->start = ($this->page * $this->on_page) - 1;
    /** если число больше чем файлов, знач максим число = это число файлов */
    $this->start = $this->start > $this->all_elements  ? $this->all_elements : $this->start;
    /** начальное число массива */
    $this->end   = ($this->page * $this->on_page)- $this->on_page;
    /** стили для постранички */
    $this->style = '';
    /** стрелочки по умолчанию */
    $this->right_arrow = '&gt;&gt;';
    $this->left_arrow = '&lt;&lt;';
}

/**
 * @function result_array() - результирующий массив файлов
 * @return array() отсортированный массив файлов
 */
public function result_array()
{
    $this->arr = array();
    for($i=$this->end;$i<=$this->start;$i++)
    {
        if(isset($this->rfile[$i]))
        {
            $this->arr[$i] = $this->rfile[$i];
        }
    }
    return $this->arr;
}

/**
 * @function info() выводим сколько всего файлов
 * @param    $vsego - формат вывода строки, к примеру 'В базе находится :var записей' , :var будет заменено на общее кол-во записей или файлов
 * @return   string - выводит строку в нужном нам формате
 */
public function info($vsego = false)
{
    $return = $vsego != false ? $vsego : $this->all_elements;
    $return = preg_replace("/:var/",$this->all_elements, $return);
    return $return;
}

/**
 * @function pagination() - выводим строку навигации
 * @param  (int)$radius - кол-во элементов ссылок на страницы, которые выводятся по правую или по левую сторону от текущей
 * @return (string) $return - сформированная строка постраничной навигации
 */
public function pagination($radius = 5, $style_link = '')
{
    /** если указана настройка стилей для навигационного меню */
    if(preg_match("/^(span|div):\w+:\w+$/i", $this->style))
    {
        $explode = explode(":", $this->style);
        $sd_start_link = '<'.$explode[0].' class="'.$explode[1].'">';
        $sd_start_info = '<'.$explode[0].' class="'.$explode[2].'">';
        $sd_end   = '</'.$explode[0].'>';
    }
    elseif(preg_match("/^(span|div):\w+:\w+$/i", $style_link))
    {
        $explode = explode(":", $style_link);
        $sd_start_link = '<'.$explode[0].' class="'.$explode[1].'">';
        $sd_start_info = '<'.$explode[0].' class="'.$explode[2].'">';
        $sd_end   = '</'.$explode[0].'>';
    }
    else
    {
        $sd_start_link = '';
        $sd_start_info = '';
        $sd_end   = '';
    }
    $return = ' <a href="'.preg_replace("/:page/", 1, $this->link).'">'.$sd_start_link.$this->left_arrow.$sd_end.'</a> ';
    $left_radius = $this->page - $radius;
    $right_radius = $this->page + $radius;
    for($i=$left_radius; $i<=$right_radius; $i++)
    {
        if($i > 0 && $i <= $this->all_pages)
        {
            if($i == $this->page)
            {
                $return .= ' '.$sd_start_info.$i.' из '.$this->all_pages.$sd_end.' ';
            }
            else
            {
                $return .= ' <a href="'.preg_replace("/:page/", $i, $this->link).'">'.$sd_start_link.$i.$sd_end.'</a> ';
            }
        }
    }   
    $return .=  ' <a href="'.preg_replace("/:page/", $this->all_pages, $this->link).'">'.$sd_start_link.$this->right_arrow.$sd_end.'</a> ';
    return $return;
}

/**
 * @function show_form() - показываем форму для быстрого перехода
 * @return (string) показываем готовую форму
 */
public function show_form($array = array()) 
{
    
    $hidden = '';
    /** добавляем скрытые поля к форме */
    if(count($array) > 0)
    {
        foreach($array as $key => $value)
        {
            $hidden .= '<input type="hidden" name="'.$key.'" value="'.$value.'" />';
        }
    }
    
    return '<form action="?" method="get">'.
    '<div>'.$hidden.
    '<input type="text" size="4" name="p" value="'.$this->page.'" />'.
    '<input type="submit" value="Go!" />'.    
    '</div>'.
    '</form>';
}

/**
 * @function limit() - лимитируем запросы в MySQL
 * @return (string) - строка, которая подставляется в запрос
 */
function limit() {
    // высчитываем лимиты
    return ' limit '.(($this->page*$this->on_page)-$this->on_page).' ,'.$this->on_page.';';
}
}
?>