<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=System::CurrentLang() ?>" xml:lang="<?=System::CurrentLang() ?>">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title><?=$title; ?></title>
		<link rel="shortcut icon" href="<?=Yii::app()->theme->baseUrl;?>/favicon.ico" type="image/x-icon" />
		<link rel="stylesheet" href="<?=Yii::app()->theme->baseUrl;?>/style.css" type="text/css"/>
		<link rel="stylesheet" href="/assets/css/tooltips.css" type="text/css"/>
		<meta name="description" content="<?=System::getSettings('description');?>" />
		<meta name="keywords" content="<?=System::getSettings('keywords')?>" />
		<?php Yii::app()->getClientScript()->registerCoreScript('jquery'); ?>
		<script src="/assets/js/jquery.tools.min.js"></script>
		<script type="text/javascript">
			$(function() {
			$("#mainContentWrapper a[title]").tooltip();
			$("#mainContentWrapper abbr[title]").tooltip();
			$("#mainContentWrapper img[title]").tooltip();
			});
		</script>
		</head>
<body>
<div id="mainContentWrapper" class="main">
<div class="head"><a href="/"><img src="<?=Yii::app()->theme->baseUrl;?>/images/logo.png" alt="logo" /></a>
		   <div class="navg">
			   <?php if(System::Server('request_uri') == '/' || System::Server('request_uri') == '/index.php'): ?>
					<?php if(System::backlink() !=false): ?>
						<span class="navg1"><?=System::backlink(); ?></span>
						<span class="navg2"><a href="/index/language"><?=ucwords(Lang::get(System::CurrentLang(), 'languages'));?></a></span>
					<?php else: ?>
						<span class="navg3"><a href="/index/language"><?=ucwords(Lang::get(System::CurrentLang(), 'languages'));?></a></span>
					<?php endif;?>
			   <?php else: ?>
			    <span class="navg1"><a href="/"><?=Lang::get('mainpage'); ?></a></span>
				<?php if (System::backlink() !=false): ?>
					<span class="navg"><?=System::backlink(); ?></span>
				<?php endif; ?>
				<span class="navg2"><a href="/index/language"><?=ucwords(Lang::get(System::CurrentLang(), 'languages'));?></a></span>
			   <?php endif; ?>
           </div>
</div>
<div class="perfcms">
	<?php if (User::loged()): ?>
		<span class="navg1"><a href="/user/"><?=Lang::get('panel'); ?></a></span>
		<?php if(System::notifications('mail') > 0): ?>
		<span class="navg"><a href="/user/dialogs"><?=Lang::get('dialogs_title', 'dialogs'); ?> +<?=System::notifications('mail'); ?></a></span>
		<?php endif; ?>
		<?php if(User::level() > 1): ?>
			<span class="navg"><a href="/user/logout?return=<?=System::Server('request_uri'); ?>"><?=Lang::get('logout'); ?></a></span>
			<span class="navg2"><a href="/padmin/"><?=Lang::get('padmin_title', 'padmin'); ?></a></span>
		<?php else: ?>
			<span class="navg2"><a href="/user/logout?return=<?=System::Server('request_uri'); ?>"><?=Lang::get('logout') ?></a></span>
		<?php endif ?>
	<?php else: ?>
		<span class="navg1"><a href="/user/login?return=<?=System::Server('request_uri') ?>"><?=Lang::get('login') ?></a></span>
		<span class="navg"><a href="/user/register"><?=Lang::get('register') ?></a></span>
		<span class="navg2"><a href="/user/recovery"><?=Lang::get('recovery') ?></a></span>
	<?php endif ?>
</div>
<?=$this->widgets('header') ?>

<table>
<tr>
	<?php include('sidebar.php');?>
