<?php

class InstallLanguage
{
	/*
	 * @var array $languages Array with all languages
	 */
	public $languages = array();
	
	/*
	 * @var string $language Current language
	 */
	public $language = 'en';
	
	/*
	 * @var array $data Array with language phrases
	 */
	public $data = array();
	
	/*
	 * @var string $category Filename with phrases, default = main
	 */
	public $category = 'install';

	/*
	 * @function __construct Initalize language
	 */
	public function __construct($lang) 
	{
		$this->language = $lang;
		if(file_exists(root.'/protected/messages/'. $this->language))
		{
			$dir = opendir(root.'/protected/messages/'. $this->language);
		}
		else
		{
			$dir = opendir(root.'/protected/messages/'. $this->language);
		}
		while ($file = readdir($dir)) {
			if ($file == '.' OR $file == '..' OR $file == 'php.ini') continue;
			$data = include(root.'/protected/messages/'. $this->language .'/'.$this->category.'.php');
			$this->data = array_merge($this->data, $data);
		}
	}

	/*
	 * @param string $key Key from language file
	 * @return string $data Translated key
	 */
	public function get($key, $category = 'install') 
	{
		if (empty($this->data[$key])) $data = $key;
		else $data = $this->data[$key];
		if (is_string($key)) {
			$lgr = include(root.'/protected/messages/'. $this->language .'/'.$category.'.php');
			$data = $lgr[$key];
		}

		return $data;
	}	
}