<div class="title"><?=$topic['name']; ?></div>
<?php foreach($posts as $post): ?>
<div class="post">
	
	<?=User::nick($post['user_id'], '<small class="gray">'.Filters::viewTime($post['time']).'</small> '); ?> 
	
	<?php if(User::loged() and $topic['closed'] == 0): ?>
		<span style="float: right; font-size: small;">
		<?php if(User::id() != $post['user_id']): ?>
		[
		<a href="/forum/posting-<?=$topic['id']; ?>?to_id=<?=$post['user_id']; ?>"><?=Lang::get('forum_post_reply', 'forum'); ?></a> 
			|
			<a href="/forum/posting-<?=$topic['id']; ?>?quote_id=<?=$post['id']; ?>"><?=Lang::get('forum_post_quote', 'forum'); ?></a>
		]
		<?php endif; ?>
		
		<?php if(User::level() >= 1 or User::id() == $post['user_id']): ?>
		[
			<a href="/forum/edit_post-<?=$post['id'];?>">+</a> 
			| 
			<a href="/forum/edit_post-<?=$post['id'];?>?action=delete">x</a>
		]
		<?php endif; ?>
		</span>
	<?php endif; ?>

	<?=Filters::output($post['text']); ?>
	<?php if($post['file'] != ''): ?>
	<br/><div style="border: dotted 1px;">
	<a href="/files/forum/<?=$post['file']; ?>"><?=$post['file']; ?></a>
	</div>
	<?php endif; ?>
</div>
<?php endforeach ?>
<?php $pages->view(); ?>

<?php $this->fastForm($topic['id']); ?>

<?php if(User::loged()): ?>
<div class="block">
<?php if($topic['closed'] == 0): ?>
<?=System::image('nav.png'); ?> <a href="/forum/posting-<?=$topic['id']?>"><?=Lang::get('forum_add_post', 'forum'); ?></a><br/>
<?php endif; ?>

<?php if (User::level() >= 1 or User::id() == $topic['user_id']): ?>
	<?php if($topic['closed'] == 0): ?>
		<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=close"><?=Lang::get('forum_close_topic', 'forum'); ?></a><br/>
	<?php else: ?>
		<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=open"><?=Lang::get('forum_open_topic', 'forum'); ?></a><br/>
	<?php endif; ?>
<?php endif; ?>

<?php if(User::level() > 1): ?>
	<?php if($topic['attach'] == 0): ?>
		<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=pin"><?=Lang::get('forum_pin_topic', 'forum'); ?></a><br/>
	<?php else: ?>
		<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=unpin"><?=Lang::get('forum_unpin_topic', 'forum'); ?></a><br/>
	<?php endif; ?>
	<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=delete"><?=Lang::get('forum_delete_topic', 'forum'); ?></a>
<?php endif; ?>
<?php if(User::level() >= 1): ?>
<br/>
	<?=System::image('nav.png'); ?> <a href="/forum/topic_actions-<?=$topic['id']; ?>?do=edit"><?=Lang::get('forum_edit', 'forum'); ?></a>
<?php endif; ?>
</div>
<?php endif; ?>
<div class="block">
<?=$this->topicNav($topic['id']); ?>
<?=System::image('back.png'); ?> <a href="/"><?=Lang::get('mainpage'); ?></a>
</div>