<?php
/*
* Padmin Module
* @package: PerfCMS
*/

class IndexController extends Controller
{
	public function actionIndex()
	{
		
		if(!User::loged() || User::level() < 2) 
		{
			header('location: /');
			exit;
		}
		
		$this->getHeader(array('title' => Lang::get('padmin_title', 'padmin')));
		$this->render('index');
		$this->getFooter();
	}
	
	public function actionSettings()
	{
		
		if(!User::loged() || User::level() < 2) 
		{
			header('location: /');
			exit;
		}
		
		if(isset($_GET['act']) && $_GET['act'] == 'save')
		{
			$saveConf = PadminSettings::model()->findByPk('auto');
			$saveConf->pts = (empty($_POST['pts']) || $_POST['pts'] < 5 ? 10 : substr(Filters::num($_POST['pts']), 0, 2));
			$saveConf->open_site = substr(Filters::num($_POST['open_site']), 0, 1);
			$saveConf->open_reg = substr(Filters::num($_POST['site_signup']), 0, 1);
			$saveConf->access_site = substr(Filters::num($_POST['access_site']), 0, 1);
			$saveConf->language = substr(Filters::input($_POST['language']), 0, 7);
			// $saveConf->copyright = substr(Filters::input($_POST['copyright']), 0, 12);
			$saveConf->timezone = Filters::input($_POST['timezone']);
			$saveConf->keywords = Filters::input($_POST['keywords']);
			$saveConf->description = Filters::input($_POST['description']);
			$saveConf->copyright = Filters::input($_POST['title']);
			$saveConf->save();
			//var_dump($saveConf);
			header('location: /padmin/index/settings?');
			exit();
		}
		$system = System::getSettings();
		$this->getHeader(array('title' => Lang::get('padmin_general_settings', 'padmin')));
		$langsDir = scandir(APP_ROOT.'/protected/messages');
		$this->render('settings', array('langs' => $langsDir, 'timezone' => $system['timezone']));
		$this->getFooter();
	}
	
	public function actionInfo()
	{
		
		if(!User::loged() || User::level() < 2) 
		{
			header('location: /');
			exit;
		}
		
		$serverSoftware = explode('/', System::Server('server_software'));
		$this->getHeader(array('title' => Lang::get('padmin_system_info', 'padmin')));
		$this->render('info', array('YiiVersion' => Yii::getVersion(), 'PHPVersion' => PHP_VERSION, 'server_software' => $serverSoftware));
		$this->getFooter();
	}
	
	public function versionInfo($version = 'remote')
	{
		$internalVersion = file_get_contents(APP_SYS.'/data/info/system_version.txt');
		$remoteVersion = file_get_contents('http://perfcms.net/perfcms/system_version.txt');
		
		$internalData = explode('|', $internalVersion);
		$remoteData = explode('|', $remoteVersion);
		
		switch($version)
		{
			case 'remote':
				echo $remoteData[0];
			break;
			
			case 'status':
				echo $remoteData[1];
			break;
			
			case 'name':
				echo $remoteData[2];
			break;
			
			case 'build':
				echo $remoteData[3];
			break;
			
			case 'compare':
				if($internalData[0] < $remoteData[0])
				{
					echo '[<a href="/padmin/index/info?changelog"><b>New version! ('.$remoteData[0].')</b></a>]';
					if(isset($_GET['changelog']))
					{
						$changelog = file_get_contents('http://perfcms.net/perfcms/system_version.txt');
						echo '<br/>'.Filters::output($changelog);
					}
				}
			break;
			
			default:
				echo $remoteData[0];
			break;
		}
	}
	
	public function actionDesign()
	{
		
		if(!User::loged() || User::level() < 2) 
		{
			header('location: /');
			exit;
		}
		if(isset($_GET['act']) && $_GET['act'] == 'save')
		{
			$saveConf = PadminSettings::model()->findByPk('auto');
			$saveConf->wap_theme = Filters::input($_POST['wap_theme']);
			$saveConf->web_theme = Filters::input($_POST['web_theme']);
			$saveConf->touch_theme = Filters::input($_POST['touch_theme']);
			$saveConf->active_switch = substr(Filters::num($_POST['active_switch']), 0, 1);
			$saveConf->default_type = substr(Filters::num($_POST['def_type']), 0, 1);
			$saveConf->save();
			header('location: /padmin/index/design?');
			exit();
		}
		
		$wapDir = scandir(APP_ROOT .'/design/themes/wap');
		$webDir = scandir(APP_ROOT .'/design/themes/web');
		$touchDir = scandir(APP_ROOT .'/design/themes/touch');
		$this->getHeader(array('title' => Lang::get('padmin_design_settings', 'padmin')));
		$this->render('design', array('waps' => $wapDir, 'webs' => $webDir, 'touchs' => $touchDir));
		$this->getFooter();
	}
	
	public function actionStats()
	{
		
		if(!User::loged() || User::level() < 2) 
		{
			header('location: /');
			exit;
		}
		
		$db = PerfDb::init();
		$this->getHeader(array('title' => Lang::get('padmin_stats_info', 'padmin')));
		$users = $db->query("SELECT * FROM `users` WHERE `time` > '".(time()-60*60*24)."' ORDER BY time DESC LIMIT 5");
		$regs = $db->query("SELECT * FROM `users` ORDER BY reg_time DESC LIMIT 5");
		$guests = $db->query("SELECT * FROM `guests` LIMIT 5");
		$all = $db->query("SELECT * FROM `users` WHERE `time` > '".(time()-60*60*24)."'")->rowCount();
		$this->render('stats', array('users' => $users, 'regs' => $regs, 'guests' => $guests, 'all' => $all));
		$this->getFooter();
	}
	
	public function actionThemes()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$this->getHeader(Lang::get('padmin_themes_manager', 'padmin'));
		$this->render('themes');
		$this->getFooter();
	}
	
	public function listOfThemes()
	{
		echo '<div class="post">'. System::image('mobile-phone.png').' <a href="/padmin/index/themes?wap"><b>'.Lang::get('padmin_themes_wap', 'padmin').'</b></a></br/>';
		if(isset($_GET['wap']))
		{
			$wapThemesDir = scandir(APP_ROOT.'/design/themes/wap');
			foreach($wapThemesDir as $wapTheme)
			{
				if($wapTheme != '.' && $wapTheme != '..' && $wapTheme != '.htaccess')
				{
					$wap = new Ini(APP_ROOT.'/design/themes/wap/'.$wapTheme.'/theme.ini');
					echo Lang::get('name').': '.$wap->read('theme_name').'<br/>'.
					(file_exists(APP_ROOT.'/design/themes/wap/'.$wapTheme.'/preview.png') ? '<a href="/design/themes/wap/'.$wapTheme.'/preview.png"><img src="/design/themes/wap/'.$wapTheme.'/preview.png" alt="preview" height="150px" /></a><br/>' : false).'
						'.($wap->read('theme_author') != false ? Lang::get('padmin_author', 'padmin').': '.$wap->read('theme_author') : false).' '.($wap->read('theme_site') !=false ? '(<a href="'.$wap->read('theme_site').'">'.str_replace('http://', '', $wap->read('theme_site').')').'</a><br/>' : false).'<br/>';
				}
			}
		}
		echo '</div>';
		
		echo '<div class="post">'. System::image('android.png').' <a href="/padmin/index/themes?touch"><b>'.Lang::get('padmin_themes_touch', 'padmin').'</b></a><br/>';
		if(isset($_GET['touch']))
		{
			$touchThemesDir = scandir(APP_ROOT.'/design/themes/touch');
			foreach($touchThemesDir as $touchTheme)
			{
				if($touchTheme != '.' && $touchTheme != '..' && $touchTheme != '.htaccess')
				{
					$touch = new Ini(APP_ROOT.'/design/themes/touch/'.$touchTheme.'/theme.ini');
					echo Lang::get('name').': '.$touch->read('theme_name').'<br/>'.
					(file_exists(APP_ROOT.'/design/themes/touch/'.$touchTheme.'/preview.png') ? '<a href="/design/themes/touch/'.$touchTheme.'/preview.png"><img src="/design/themes/touch/'.$touchTheme.'/preview.png" alt="preview" height="150px" /></a><br/>' : false).'
						'.($touch->read('theme_author') != false ? Lang::get('padmin_author', 'padmin').':'.$touch->read('theme_author') : false).' '.($touch->read('theme_site') !=false ? '(<a href="'.$touch->read('theme_site').'">'.str_replace('http://', '', $touch->read('theme_site').')').'</a><br/>' : false).'<br/>';
				}
			}
		}
		echo '</div>';
		
		echo '<div class="post">'. System::image('computer.png').' <a href="/padmin/index/themes?web"><b>'.Lang::get('padmin_themes_web', 'padmin').'</b></a><br/>';
		if(isset($_GET['web']))
		{
			$webThemesDir = scandir(APP_ROOT.'/design/themes/web');
			foreach($webThemesDir as $webTheme)
			{
				if($webTheme != '.' && $webTheme != '..' && $webTheme != '.htaccess')
				{
					$web = new Ini(APP_ROOT.'/design/themes/web/'.$webTheme.'/theme.ini');
					echo Lang::get('name').': '.$web->read('theme_name').'<br/>'.
					(file_exists(APP_ROOT.'/design/themes/web/'.$webTheme.'/preview.png') ? '<a href="/design/themes/web/'.$webTheme.'/preview.png"><img src="/design/themes/web/'.$webTheme.'/preview.png" alt="preview" height="150px" /></a><br/>' : false).
					($web->read('theme_author') != false ? Lang::get('padmin_author', 'padmin').': '.$web->read('theme_author') : false).' '.($web->read('theme_site') !=false ? '(<a href="'.$web->read('theme_site').'">'.str_replace('http://', '', $web->read('theme_site').')').'</a><br/>' : false).'<br/>';
				}
			}
		}
		echo '</div>';
	}
		
	public function actionInstall_theme()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$themeError = '';
		
		if(isset($_GET['upload']) && $_FILES['themeZip'])
		{
			$zipDir = APP_ROOT.'/tmp/';
			$themeType = '';
			$themeCDir = '';
						
			$themeZip = new Upload($_FILES['themeZip']);
			if($themeZip->uploaded)
			{
				$themeZip->allowed = array('application/zip');
				$themeZip->process($zipDir);
				if($themeZip->processed)
				{
					$zip = new PclZip($zipDir.$themeZip->file_src_name);
					$config = $zip->extract(PCLZIP_OPT_BY_NAME, "theme.ini", PCLZIP_OPT_PATH, APP_ROOT.'/tmp/');
					if($config != 0)
					{
						$zip->extract(PCLZIP_OPT_BY_NAME, "theme.ini", PCLZIP_OPT_PATH, APP_ROOT.'/tmp/');
						$ini = new Ini($zipDir."theme.ini");
						if($ini->read('theme_name') == false)
						{
							$themeError = 'Error #1: Argument <b>theme_name</b> is missed!';
						}
						elseif($ini->read('theme_dir') == false)
						{
							$themeError = 'Error #2: Argument <b>theme_dir</b> is missed!';
						}
						elseif($ini->read('theme_type') == false)
						{
							$themeError = 'Error #3: Argument <b>theme_type</b> is missed!';
						}
						elseif($ini->read('theme_author') == false)
						{
							$ini->write('theme_author', 'Unknown');
							$ini->updateFile();
						}
						
						if($themeError == '')
						{
							$themeType = $ini->read('theme_type');
							$themeCDir = $ini->read('theme_dir');
						}
					}
					else
					{
						$themeError = 'Error #4: Theme\'s descriptor is missed! ('.$zip->errorInfo(true).')';
					}
										
					if($themeError == '')
					{
						$zip->extract(PCLZIP_OPT_PATH, APP_ROOT.'/design/themes/'.$themeType.'/'.$themeCDir);
						unlink($zipDir.$themeZip->file_src_name);
						unlink($zipDir.'theme.ini');
						$themeZip->clean();
						$this->redirect('/padmin/index/themes#'.$themeCDir);
					}
				}
			}
		}
		
		$this->getHeader(Lang::get('padmin_themes_manager', 'padmin'));
		$this->render('install_theme');
		$this->getFooter();
	}
	
	public function actionWidgets()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$this->getHeader(Lang::get('padmin_widgets_manager', 'padmin'));
		$widgets = scandir(APP_ROOT.'/protected/widgets');
		if(isset($_GET['config']) && in_array($_GET['config'], $widgets))
		{
			require_once(APP_ROOT.'/protected/widgets/'.Filters::input($_GET['config']).'/pages/settings.php');
			$this->getFooter();
			exit;
		}
		$this->render('widgets');
		$this->getFooter();
	}
	
	public function listOfWidgets()
	{
		$widgets = scandir(APP_ROOT.'/protected/widgets');
		foreach($widgets as $widget)
		{
			if($widget != '.' && $widget != '..' && $widget != '.htaccess')
			{
				$ini = new Ini(APP_ROOT.'/protected/widgets/'.$widget.'/widget.ini');
				echo '<div class="post">'. System::image('arrow.png').' <a href="/padmin/index/widgets?'.$widget.'"><b>'.$widget.' </b></a><br/>';
				if(isset($_GET[$widget]))
				{
					if(isset($_GET['activate']))
					{
						$ini->write('widget_active', 'true');
						$ini->updateFile();
						$this->redirect('/padmin/index/widgets?'.$widget);
					}
					elseif(isset($_GET['deactivate']))
					{
						$ini->write('widget_active', 'false');
						$ini->updateFile();
						$this->redirect('/padmin/index/widgets?'.$widget);
					}
					
					echo ($ini->read('widget_author') != false ? Lang::get('padmin_author', 'padmin').': '.$ini->read('widget_author') : false).' '.($ini->read('widget_link') !=false ? '(<a href="'.$ini->read('widget_link').'">'.str_replace('http://', '', $ini->read('widget_link').')').'</a>' : false).'<br/>
					'.($ini->read('widget_version') !=false ? Lang::get('padmin_version', 'padmin').': '.$ini->read('widget_version') : false).'<br/> 
					'.($ini->read('widget_type') !=false ? Lang::get('padmin_type', 'padmin').': '.$ini->read('widget_type') : false).'<br/> 
					'.($ini->read('widget_active') == 'true' ? '[<a href="/padmin/index/widgets?'.$widget.'&deactivate">'.Lang::get('padmin_deactive', 'padmin').'</a>]' : '[<a href="/padmin/index/widgets?'.$widget.'&activate">'.Lang::get('padmin_active', 'padmin').'</a>]').'<br/>
					'.(file_exists(APP_ROOT.'/protected/widgets/'.$widget.'/pages/settings.php') ? '[<a href="/padmin/index/widgets?config='.$widget.'">'. Lang::get('padmin_widgets_config', 'padmin') .'</a>]' : false);
				}
				echo '</div>';
			}
		}
	}
	
	public function actionInstall_widget()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$widgetError = '';
		
		if(isset($_GET['upload']) && $_FILES['widgetZip'])
		{
			$zipDir = APP_ROOT.'/tmp/';
			$widgetCDir = '';
						
			$widgetZip = new Upload($_FILES['widgetZip']);
			if($widgetZip->uploaded)
			{
				$widgetZip->allowed = array('application/zip');
				$widgetZip->process($zipDir);
				if($widgetZip->processed)
				{
					$zip = new PclZip($zipDir.$widgetZip->file_src_name);
					$config = $zip->extract(PCLZIP_OPT_BY_NAME, "widget.ini", PCLZIP_OPT_PATH, APP_ROOT.'/tmp/');
					if($config != 0)
					{
						$zip->extract(PCLZIP_OPT_BY_NAME, "widget.ini", PCLZIP_OPT_PATH, APP_ROOT.'/tmp/');
						$ini = new Ini($zipDir."widget.ini");
						if($ini->read('widget_name') == false)
						{
							$widgetError = 'Error #1: Argument <b>widget_name</b> is missed!';
						}
						elseif($ini->read('widget_author') == false)
						{
							$ini->write('widget_author', 'Unknown');
							$ini->updateFile();
						}
						elseif($ini->read('widget_active') == false)
						{
							$ini->write('widget_active', 'true');
							$ini->updateFile();
						}
						
						if($widgetError == '')
						{
							$widgetCDir = $ini->read('widget_dir');
						}
					}
					else
					{
						$widgetError = 'Error #4: Widget\'s descriptor is missed! ('.$zip->errorInfo(true).')';
					}
										
					if($widgetError == '')
					{
						$zip->extract(PCLZIP_OPT_PATH, APP_ROOT.'/protected/widgets/'.$widgetCDir);
						unlink($zipDir.$widgetZip->file_src_name);
						unlink($zipDir.'widget.ini');
						$widgetZip->clean();
						$this->redirect('/padmin/index/widgets#'.$widgetCDir);
					}
				}
			}
		}
		
		$this->getHeader(Lang::get('padmin_widgets_install', 'padmin'));
		$this->render('install_widget');
		$this->getFooter();
	}
	
	public function actionMainpage()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		if(isset($_GET['save']))
		{
			$tags = array('<script(.*)>', '</script>', '<iframe(.*)>', '</iframe>', '<object(.*)>', '</object>');
			$content = str_replace($tags, '', $_POST['source']);
			$source = Filters::input($content);
			if($content != '')
			{
				$db = PerfDb::init();
				$db->query("UPDATE `system` SET `mainpage` = '$source'");
				$this->redirect('/padmin/index/mainpage');
			}
		}

		$this->getHeader(Lang::get('padmin_index_manager', 'padmin'));
		$this->render('mainpage');
		$this->getFooter();
	}
	
	public function actionAds()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$this->getHeader(Lang::get('padmin_ads_manager', 'padmin'));
		$this->render('ads');
		$this->getFooter();
	}
	
	public function linksList()
	{
		$db = PerfDb::init();
		echo '<div class="menu">'.
		System::image('arrow.png').' <a href="/padmin/index/ads?header"><b>'. Lang::get('padmin_ads_header', 'padmin') .'</b></a></div>';
		if(isset($_GET['header']))
		{
			$headerLinks = $db->query("SELECT * FROM `ads` WHERE `type` = '1'");
			foreach($headerLinks as $link)
			{
				echo '<div class="post">» <a href="/padmin/index/link_edit?id='.$link['id'].'">'. $link['name'] .'</a></div>';
			}
		}
		
		echo '<div class="menu">'.
		System::image('arrow.png').' <a href="/padmin/index/ads?footer"><b>'. Lang::get('padmin_ads_footer', 'padmin') .'</b></a></div>';
		if(isset($_GET['footer']))
		{
			$footerLinks = $db->query("SELECT * FROM `ads` WHERE `type` = '2'");
			foreach($footerLinks as $link)
			{
				echo '<div class="post">» <a href="/padmin/index/link_edit?id='.$link['id'].'">'. $link['name'] .'</a></div>';
			}
		}
	}
	
	public function actionLink_add()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$db = PerfDb::init();
		$error = false;
		if(isset($_GET['add']))
		{
			$linkUrl = Filters::input($_POST['link_url']);
			$linkName = Filters::input($_POST['link_name']);
			$linkImage = Filters::input($_POST['link_image']);
			$linkType = Filters::num($_POST['link_type']);
			if($linkType < 1 || $linkType > 2)
			{
				$linkType = 2;
			}
			$linkRedirect = (isset($_POST['link_redirect']) ? 1 : 0);
			if(!empty($linkUrl) && !empty($linkName))
			{
				$db->query("INSERT INTO `ads` SET `name` = '$linkName', `link` = '$linkUrl', `image` = '$linkImage', `type` = '$linkType', `redirect` = '$linkRedirect'");
				$this->redirect('/padmin/index/ads?'.($linkType == 1 ? 'header' : 'footer'));
			}
		}
			
			
		$this->getHeader(Lang::get('padmin_ads_add', 'padmin'));
		$this->render('link_add');
		$this->getFooter();
	}
	
	public function actionLink_edit()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$db = PerfDb::init();
		
		if(!isset($_GET['id']) || $db->query("SELECT * FROM `ads` WHERE `id` = '".Filters::num($_GET['id'])."'")->rowCount() != 1)
		{
			$this->redirect('/padmin/index/ads?');
		}
		
		$error = false;
		
		if(isset($_GET['save']))
		{
			$linkUrl = Filters::input($_POST['link_url']);
			$linkName = Filters::input($_POST['link_name']);
			$linkImage = Filters::input($_POST['link_image']);
			$linkType = Filters::num($_POST['link_type']);
			if($linkType < 1 || $linkType > 2)
			{
				$linkType = 2;
			}
			$linkRedirect = (isset($_POST['link_redirect']) ? 1 : 0);
			// print_r($_POST);
			if(!empty($linkUrl) && !empty($linkName))
			{
				$db->query("UPDATE `ads` SET `name` = '$linkName', `link` = '$linkUrl', `image` = '$linkImage', `type` = '$linkType', `redirect` = '$linkRedirect' WHERE `id` = '".Filters::num($_GET['id'])."'");
				$this->redirect('/padmin/index/ads?'.($linkType == 1 ? 'header' : 'footer'));
			}
		}
		elseif(isset($_GET['delete']))
		{
			$db->query("DELETE FROM `ads` WHERE `id` = '".Filters::num($_GET['id'])."' LIMIT 1");
			$this->redirect('/padmin/index/ads');
		}
		
		$linkData = $db->query("SELECT * FROM `ads` WHERE `id` = '".Filters::num($_GET['id'])."'")->fetch();
		
		$this->getHeader(Lang::get('padmin_ads_edit', 'padmin'));
		$this->render('link_edit', array('link' => $linkData));
		$this->getFooter();
	}
	
	public function actionStatic_pages()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$db = PerfDb::init();
		
		$pages = $db->query("SELECT * FROM `pages` ORDER BY name ASC");
		
		$this->getHeader(Lang::get('padmin_static_pages', 'padmin'));
		$this->render('pages', array('pages' => $pages));
		$this->getFooter();
	}
	
	public function actionPage_add()
	{
		if(!User::loged() || User::level() < 2) 
		{
			$this->redirect('/');
		}
		
		$db = PerfDb::init();
		
		if(isset($_GET['add']))
		{
			$name = Filters::input($_POST['page_name']);
			$code = Filters::input($_POST['text']);
			
			
			$_name = strtr($name, array("Ґ" => "G", "Ё" => "YO", "Є" => "YE", "Ї" => "YI", "І" => "I",
				"і" => "i", "ґ" => "g", "ё" => "yo", "є" => "ye",
				"ї" => "yi", "А" => "A", "Б" => "B", "В" => "V", "Г" => "G",
				"Д" => "D", "Е" => "E", "Ж" => "ZH", "З" => "Z", "И" => "I",
				"Й" => "Y", "К" => "K", "Л" => "L", "М" => "M", "Н" => "N",
				"О" => "O", "П" => "P", "Р" => "R", "С" => "S", "Т" => "T",
				"У" => "U", "Ф" => "F", "Х" =>  "H","Ц" => "TS", "Ч" => "CH",
				"Ш" => "SH", "Щ" => "SCH", "Ъ" => "", "Ы" => "I", "Ь" => "",
				"Э" => "E", "Ю" => "YU", "Я" => "YA", "а" => "a", "б" => "b",
				"в" => "v", "г" => "g", "д" => "d", "е" => "e", "ж" => "zh",
				"з" => "z", "и" => "i", "й" => "y", "к" => "k", "л" => "l",
				"м" => "m", "н" => "n", "о" => "o", "п" => "p", "р" => "r",
				"с" => "s", "т" => "t", "у" => "u", "ф" => "f", "х" => "h",
				"ц" => "ts", "ч" => "ch", "ш" => "sh", "щ" => "sch", "ъ" => "",
				"ы" => "i", "ь" => "", "э" => "e", "ю" => "yu", "я" => "ya",
				" " => "-", "_" => "-"));
			
			$_name = preg_replace('/[^а-яА-Яa-zA-Z0-9_-]/is', '', $_name);
			if(!empty($name) && !empty($code))
			{
				$db->query("INSERT INTO `pages` SET `name` = '$name', `translit_name` = '".strtolower($_name)."', `content` = '$code'");
				$this->redirect('/padmin/index/static_pages');
			}
		}
		
		$this->getHeader(Lang::get('padmin_static_pages', 'padmin'));
		$this->render('page_add');
		$this->getFooter();
	}
	
	public function actionPage_edit()
	{
		$db = PerfDb::init();
	
		if(!User::loged() || User::level() < 2 || $db->query("SELECT * FROM `pages` WHERE `id` = '". Filters::input($_GET['id']) ."'")->rowCount() != 1) 
		{
			$this->redirect('/');
		}
		
		if(isset($_GET['save']))
		{
			$name = Filters::input($_POST['page_name']);
			$code = Filters::input($_POST['text']);
			
			
			$_name = strtr($name, array("Ґ" => "G", "Ё" => "YO", "Є" => "YE", "Ї" => "YI", "І" => "I",
				"і" => "i", "ґ" => "g", "ё" => "yo", "є" => "ye",
				"ї" => "yi", "А" => "A", "Б" => "B", "В" => "V", "Г" => "G",
				"Д" => "D", "Е" => "E", "Ж" => "ZH", "З" => "Z", "И" => "I",
				"Й" => "Y", "К" => "K", "Л" => "L", "М" => "M", "Н" => "N",
				"О" => "O", "П" => "P", "Р" => "R", "С" => "S", "Т" => "T",
				"У" => "U", "Ф" => "F", "Х" =>  "H","Ц" => "TS", "Ч" => "CH",
				"Ш" => "SH", "Щ" => "SCH", "Ъ" => "", "Ы" => "I", "Ь" => "",
				"Э" => "E", "Ю" => "YU", "Я" => "YA", "а" => "a", "б" => "b",
				"в" => "v", "г" => "g", "д" => "d", "е" => "e", "ж" => "zh",
				"з" => "z", "и" => "i", "й" => "y", "к" => "k", "л" => "l",
				"м" => "m", "н" => "n", "о" => "o", "п" => "p", "р" => "r",
				"с" => "s", "т" => "t", "у" => "u", "ф" => "f", "х" => "h",
				"ц" => "ts", "ч" => "ch", "ш" => "sh", "щ" => "sch", "ъ" => "",
				"ы" => "i", "ь" => "", "э" => "e", "ю" => "yu", "я" => "ya",
				" " => "-", "_" => "-"));
			
			$_name = preg_replace('/[^а-яА-Яa-zA-Z0-9_-]/is', '', $_name);
			if(!empty($name) && !empty($code))
			{
				$db->query("UPDATE `pages` SET `name` = '$name', `translit_name` = '".strtolower($_name)."', `content` = '$code' WHERE `id` = '". Filters::input($_GET['id']) ."'");
				$this->redirect('/padmin/index/static_pages');
			}
		}
		elseif(isset($_GET['delete']))
		{
			$db->query("DELETE FROM `pages` WHERE `id` = '". Filters::input($_GET['id']) ."' LIMIT 1");
				$this->redirect('/padmin/index/static_pages');
		}
		
		$page = $db->query("SELECT * FROM `pages` WHERE `id` = '". Filters::input($_GET['id']) ."'")->fetch();
		
		$this->getHeader(Lang::get('padmin_static_pages_edit', 'padmin'));
		$this->render('page_edit', array('page' => $page));
		$this->getFooter();
	}
	
}
