<?php
/*
* Controller class
* @package: PerfCMS
*/
class Controller extends CController
{
	public function getHeader($params = array(), $location_id = '/index::site_somewhere_location')
	{
		User::setLocation($location_id, User::Id());
		
		if(is_array($params))
		{
			$params['title'] = $params['title'].' - '.PerfSystem::getSettings('copyright');
			$this->renderFile(Yii::app()->theme->basePath.'/views/layouts/header.php', $params);
		}
		else
		{
			$params = $params.' - '.PerfSystem::getSettings('copyright');
			$this->renderFile(Yii::app()->theme->basePath.'/views/layouts/header.php', array('title' => $params));
		}
		
		$data = User::$data;
		
		if(User::loged() && $data['ban_time'] > time() && $data['ban_time'] != 0)
		{
			$this->render('block');
			$this->getFooter();
			exit;
		}
				
		if(isset($this->module->id))
		{
			$config = new Ini(APP_ROOT.'/modules/'.$this->module->id.'/config.ini');
			if($config->read('open') == 0)
			{
				echo '<div class="error">'. Lang::get('module_closed', 'main') .'</div>';
				echo '<div class="block"> '.System::image('back.png').' <a href="/">'.Lang::get('mainpage').'</a></div>';
				$this->getFooter();
				exit;
			}
			elseif($config->read('access') == 1 && !User::loged())
			{
				echo '<div class="error">'. Lang::get('module_for_authorised', 'main') .'</div>';
				echo '<div class="block"> '.System::image('back.png').' <a href="/">'.Lang::get('mainpage').'</a></div>';
				$this->getFooter();
				exit;
			}
			elseif($config->read('access') == 2 && User::level() < 2)
			{
				echo '<div class="error">'. Lang::get('module_for_administration', 'main') .'</div>';
				echo '<div class="block"> '.System::image('back.png').' <a href="/">'.Lang::get('mainpage').'</a></div>';
				$this->getFooter();
				exit;
			}
		}
		elseif(System::getSettings('open_site') == 1 && User::level() < 2 && !preg_match('#\/user\/login#si', System::Server('request_uri')))
		{
			echo '<div class="error">'. Lang::get('site_is_closed') .'</div>';
			$this->getFooter();
			exit;
		}
		elseif(System::getSettings('access_site') == 1 && User::level() < 0 && !preg_match('#\/user\/(login|register|recovery)#si', System::Server('request_uri')))
		{
			echo '<div class="error">'. Lang::get('site_is_closed_for_guests') .'</div>';
			$this->getFooter();
			exit;
		}
		elseif(System::getSettings('access_site') == 2 && User::level() < 1 && !preg_match('#\/user\/(login|register|recovery)#si', System::Server('request_uri')))
		{
			echo '<div class="error">'. Lang::get('site_is_closed_for_all') .'</div>';
			$this->getFooter();
			exit;
		}
		elseif(System::getSettings('open_reg') == 1 && preg_match('#\/user\/register#si', System::Server('request_uri')) )
		{
			echo '<div class="error">'. Lang::get('registration_is_cosed') .'</div>';
			$this->getFooter();
			exit;
		}
	}
	
	public function getFooter($params = array())
	{
		$db = PerfDb::init();
		$users = $db->query("SELECT * FROM `users` WHERE `time` > '".(time()-300)."'")->rowCount();
		$guests = $db->query("SELECT * FROM `guests` WHERE `time` > '".(time()-300)."'")->rowCount();
		$this->renderFile(Yii::app()->theme->basePath.'/views/layouts/footer.php', array('users' => $users, 'guests' => $guests));
	}
	
	public function widgets($type = '')
	{
		if($type != '')
		{
			$widgets = scandir(APP_ROOT.'/protected/widgets');
			foreach($widgets as $widget)
			{
				if($widget != '.' && $widget != '..' && $widgets != '.htaccess')
				{
					$ini = parse_ini_file(APP_ROOT.'/protected/widgets/'.$widget.'/widget.ini');
					if($ini['widget_type'] == $type && $ini['widget_active'] == 'true')
					{
						$this->widget('application.widgets.'.$widget.'.'.$widget);
					}
				}
			}
		}
	}
	
	public function widget($path = '', $properties = Array(), $captureOutput = false)
	{
		if($path != '')
		{
			$array = explode('.', $path);
			$array[0] = str_replace('application', '/protected', $array[0]);
			
			if(file_exists(APP_ROOT.$array[0].'/'.$array[1].'/'.$array[2].'/widget.ini'))
			{
				$ini = parse_ini_file(APP_ROOT.$array[0].'/'.$array[1].'/'.$array[2].'/widget.ini');
				if($ini['widget_active'] == 'true')
				{
					return parent::widget($path, $properties, $captureOutput);
				}
			}
			else
			{
				return parent::widget($path, $properties, $captureOutput);
			}
		}
	}
	
	public function render($view, $data = null, $return = false)
	{
		if(isset($this->module->id) && file_exists(Yii::app()->theme->baseUrl.'/views/'.$this->module->id.'/'.$this->id.'/'.$view.'.php'))
		{
			parent::renderFile(Yii::app()->theme->baseUrl.'/views/'.$this->module->id.'/'.$this->id.'/'.$view.'.php', $data, $return);
		}
		else
		{
			parent::render($view, $data, $return);
		}
	}
}
