<?php
$dbData = include(APP_SYS.'/data/ini/db.php');
return array(
	'name' => 'PerfCMS Application',
	'basePath' => APP_ROOT .'/protected',
	'modulePath' => APP_ROOT .'/modules',
	'runtimePath' => APP_ROOT .'/tmp',
	// 'preload' => array('log'),

	// autoloading model and component classes
	'import' => array(
		'application.components.*',
		'application.models.*',
		'application.models.modules.*',
		'application.widgets.*.*',
	),
	
	'onBeginRequest'=>create_function('$event', 'return ob_start("ob_gzhandler");'),
	'onEndRequest'=>create_function('$event', 'return ob_end_flush();'),
	
	'modules' => require('modules.php'),
	
	'defaultController' => 'Index',

	// application components
	'components' => array(

		'themeManager' => array(
			'basePath' => APP_ROOT.'/design/themes/'.PerfSystem::browserType(),
			'baseUrl' => '/design/themes/'.PerfSystem::browserType(),
		),

		'urlManager' => require('routes.php'),
		
		'db' => array(
            'class'=>'CDbConnection',
            'connectionString' => 'mysql:host='.$dbData['db_host'].';dbname='.$dbData['db_name'],
            'username' => $dbData['db_user'],
            'password' => $dbData['db_pass'],
            'emulatePrepare' => true,
			'charset' => 'utf8',
			'schemaCachingDuration' => 3600,
        ),
		// 'log' => array(
			// 'class' => 'CLogRouter',
			// 'routes' => array(
				// array(
					// 'class' => 'CFileLogRoute',
					// 'levels' => 'error, warning',
				// ),
			// ),
		// ),
	),
	'theme' => PerfSystem::getTheme(),
	// 'sourceLanguage' => PerfSystem::getSettings('language'),
	'language' => PerfSystem::CurrentLang(),
);
