<?php
/*
* Mainpage controller
* @package: PerfCMS
*/
class IndexController extends Controller
{
	public function actionIndex()
	{
		// print_r($_COOKIE);
		
		$this->getHeader(array('title' => Lang::get('mainpage')));
		$this->render('main');
		$this->getFooter();
	}
		
	public function actionError()
	{
		
		$this->getHeader(array('title' => Lang::get('error')));
		$this->render('error');
		$this->getFooter();
	}
		
	public function actionLanguage()
	{
		if(User::loged())
		{
			header('location: /user/settings/');
			exit;
		}
		if(isset($_GET['lang']) && !empty($_GET['lang']))
		{
			setcookie('lang', Filters::input($_GET['lang']), time()+60*60*24*365, '/');
			header('location: /');
			exit;
		}
		
		$this->getHeader(array('title' => Lang::get('language')));
		$lngdir = scandir(APP_ROOT.'/protected/messages');
		$this->render('language', array('langs' => $lngdir));
		$this->getFooter();
	}
	
	public function actionType()
	{
		$content = ($_GET['content'] == 'wap' || $_GET['content'] == 'touch' || $_GET['content'] == 'web' ? Filters::input($_GET['content']) : System::browserType());
		$return = (!empty($_GET['return']) ? Filters::input($_GET['return']) : '/');
		setcookie('styleType', $content, time()+60*60*24*365, '/');
		header('location: '.$return);
		exit;
	}
	
	public function actionGuests()
	{
		$lang = new Lang();
		$db = PerfDb::init();
		$this->getHeader(array('title' => Lang::get('guests_online')), '/user/list::guests_online_location');
		$listAm = $db->query("SELECT * FROM `guests` WHERE `time` > '".(time()-300)."'")->rowCount();
		$pages = new Paginator($listAm, System::pages());
		global $start;
		$listArray = $db->query("SELECT * FROM `guests` WHERE `time` > '".(time()-300)."' ORDER BY time DESC LIMIT $start, 15");
		$this->render('guests', array('list' => $listArray, 'pages' => $pages));
		$this->getFooter();
	}
	
	public function actionOut()
	{
		if(isset($_GET['url']))
		{
			$url = Filters::input(urldecode($_GET['url']));
			$this->redirect($url);
		}
	}
	
	public function actionPage()
	{
		$db = PerfDb::init();
		if(!isset($_GET['page_id']) || !isset($_GET['page_name']) || $db->query("SELECT * FROM `pages` WHERE `id` = '".Filters::num($_GET['page_id'])."' AND `translit_name` = '".Filters::input($_GET['page_name'])."'")->rowCount() != 1)
		{
			$this->redirect('/');
		}
		
		$page = $db->query("SELECT * FROM `pages` WHERE `id` = '".Filters::num($_GET['page_id'])."' AND `translit_name` = '".Filters::input($_GET['page_name'])."'")->fetch();
		
		$this->getHeader($page['name']);
		echo '<div class="title">'.$page['name'].'</div>
		<div class="post">'.Filters::output($page['content']).'</div>
		<div class="block">'. System::image('back.png').' <a href="/">'. Lang::get('mainpage') .'</a></div>';
		$this->getFooter();
	}
	
}
