<?php
class NewsWidget extends Widget
{
	public function run()
	{
		$db = PerfDb::init();
		$newsCount = $db->query("SELECT * FROM `news`")->rowCount();
		if($newsCount == 0)
		{
			echo '<div class="error">'.Lang::get('news_no_articles', 'news').'</div>';
		}
		else
		{
			$config = $this->getConfig(__CLASS__);
			$newsArray = $db->query("select * from `news` order by time desc limit ".$config['posts']."");
			while($news = $newsArray->fetch())
			{
				$comments = $db->query("SELECT * FROM `news_comments` WHERE `news_id` = '".$news['id']."'")->rowCount();
				$newComments = $db->query("SELECT * FROM `news_comments` WHERE `news_id` = '".$news['id']."' AND `time` > '".(time()-60*60*24)."'")->rowCount();
				echo '<div class="post">
				<a href="/news/article-'.$news['id'].'"><b>'. $news['name'].'</b></a> ('.Filters::viewTime($news['time']).')<br/>
				'.(mb_strlen($news['text']) >=350 ? mb_substr(Filters::output($news['text']), 0, 350) : Filters::output($news['text'])).'<br/>
				'.($news['category_id'] == 0 ? '<b>'.Lang::get('news_no_category', 'news').'</b>' : '<a href="/news/category-'.$news['category_id'].'">'.$db->query("select `name` from `news_categories` where `id` ='".$news['category_id']."' limit 1")->fetchColumn().'</a>').' | <a href="/news/comments-'.$news['id'].'">'. Lang::get('news_comments', 'news').'</a> ('.$comments.') '.($newComments > 0 ? ' <span class="green">+'.$newComments.'</span>' : null).'
				</div>';
			}
		}
	}
	
	public function init()
	{
		//
	}
}