<?php
// Copyright 2011 Toby Zerner, Simon Zerner
// This file is part of esoTalk. Please see the included license file for usage information.

ET::$languageInfo["English"] = array(
	"locale" => "en-US",
	"name" => "English",
	"description" => "A casual English language pack.",
	"version" => ESOTALK_VERSION,
	"author" => "esoTalk Team",
	"authorEmail" => "support@esotalk.org",
	"authorURL" => "http://esotalk.org",
	"license" => "GPLv2"
);

// Define the character set that this language uses.
$definitions["charset"] = "utf-8";

$definitions["date.full"] = "%c";

$definitions["%d day ago"] = "yesterday";
$definitions["%d days ago"] = "%d days ago";
$definitions["%d hour ago"] = "1 hour ago";
$definitions["%d hours ago"] = "%d hours ago";
$definitions["%d minute ago"] = "1 minute ago";
$definitions["%d minutes ago"] = "%d minutes ago";
$definitions["%d month ago"] = "1 month ago";
$definitions["%d months ago"] = "%d months ago";
$definitions["%d second ago"] = "1 second ago";
$definitions["%d seconds ago"] = "%d seconds ago";
$definitions["%d week ago"] = "last week";
$definitions["%d weeks ago"] = "%d weeks ago";
$definitions["%d year ago"] = "last year";
$definitions["%d years ago"] = "%d years ago";

$definitions["%s and %s"] = "%s and %s";
$definitions["%s can view this conversation."] = "%s can view this conversation.";
$definitions["%s changed %s's group to %s."] = "%s changed %s's group to %s.";
$definitions["%s changed your group to %s."] = "%s changed your group to %s.";
$definitions["%s conversation"] = "%s conversation";
$definitions["%s conversations"] = "%s conversations";
$definitions["%s has registered and is awaiting approval."] = "%s has registered and is awaiting approval.";
$definitions["%s invited you to %s."] = "%s invited you to %s.";
$definitions["%s joined the forum."] = "%s joined the forum.";
$definitions["%s mentioned you in %s."] = "%s mentioned you in %s.";
$definitions["%s post"] = "%s post";
$definitions["%s posted %s"] = "%s posted %s";
$definitions["%s posted in %s."] = "%s posted in %s.";
$definitions["%s posts"] = "%s posts";
$definitions["%s reply"] = "%s reply";
$definitions["%s replies"] = "%s replies";
$definitions["%s Settings"] = "%s Settings";
$definitions["%s started the conversation %s."] = "%s started the conversation %s.";
$definitions["%s will be able to view this conversation."] = "%s will be able to view this conversation.";
$definitions["%s will be able to:"] = "%s will be able to:";

$definitions["A new version of esoTalk (%s) is available."] = "A new version of esoTalk (%s) is available.";
$definitions["a private conversation"] = "a private conversation";
$definitions["Automatically follow conversations that I reply to"] = "Automatically follow conversations that I reply to";
$definitions["Automatically follow private conversations that I'm added to"] = "Automatically follow private conversations that I'm added to";
$definitions["Access the administrator control panel."] = "Access the administrator control panel.";
$definitions["Account type"] = "Account type";
$definitions["Activate"] = "Activate";
$definitions["Activity"] = "Activity";
$definitions["Add"] = "Add";
$definitions["Administration"] = "Administration";
$definitions["Administrator email"] = "Administrator email";
$definitions["Administrator password"] = "Administrator password";
$definitions["Administrator username"] = "Administrator username";
$definitions["Advanced options"] = "Advanced options";
$definitions["All Channels"] = "All Channels";
$definitions["Allow members to edit their own posts:"] = "Allow members to edit their own posts:";
$definitions["Already have an account? <a href='%s' class='link-login'>Log in!</a>"] = "Already have an account? <a href='%s' class='link-login'>Log in!</a>";
$definitions["Appearance"] = "Appearance";
$definitions["Approve"] = "Approve";
$definitions["Automatically star conversations that I reply to"] = "Automatically follow conversations that I reply to";
$definitions["Avatar"] = "Avatar";

$definitions["Back to channels"] = "Back to channels";
$definitions["Back to conversation"] = "Back to conversation";
$definitions["Back to member"] = "Back to member";
$definitions["Back to members"] = "Back to members";
$definitions["Back to search"] = "Back to search";
$definitions["Background color"] = "Background color";
$definitions["Background image"] = "Background image";
$definitions["Base URL"] = "Base URL";
$definitions["Bold"] = "Bold";
$definitions["By %s"] = "By %s";

$definitions["Can suspend/unsuspend members"] = "Can suspend/unsuspend members";
$definitions["Cancel"] = "Cancel";
$definitions["Change"] = "Change";
$definitions["Change %s's Permissions"] = "Change %s's Permissions";
$definitions["Change avatar"] = "Change avatar";
$definitions["Change Channel"] = "Change Channel";
$definitions["Change channel"] = "Change channel";
$definitions["Change username"] = "Change username";
$definitions["Change Password or Email"] = "Change Password or Email";
$definitions["Change Password"] = "Change Password";
$definitions["Change password"] = "Change password";
$definitions["Change permissions"] = "Change permissions";
$definitions["Channel description"] = "Channel description";
$definitions["Channel List"] = "Channel List";
$definitions["Channel title"] = "Channel title";
$definitions["Channel slug"] = "Channel slug";
$definitions["Channels"] = "Channels";
$definitions["Choose a secure password of at least %s characters"] = "Choose a secure password of at least %s characters";
$definitions["Choose what people will see when they first visit your forum."] = "Choose what people will see when they first visit your forum.";
$definitions["Click on a member's name to remove them."] = "Click on a member's name to remove them.";
$definitions["Close registration"] = "Close registration";
$definitions["Confirm password"] = "Confirm password";
$definitions["Controls"] = "Controls";
$definitions["Conversation"] = "Conversation";
$definitions["Conversations participated in"] = "Conversations participated in";
$definitions["Conversations started"] = "Conversations started";
$definitions["Conversations"] = "Conversations";
$definitions["Copy permissions from"] = "Copy permissions from";
$definitions["Create Channel"] = "Create Channel";
$definitions["Create Group"] = "Create Group";
$definitions["Create Member"] = "Create Member";
$definitions["Customize how users can become members of your forum."] = "Customize how users can become members of your forum.";
$definitions["Customize your forum's appearance"] = "Customize your forum's appearance";

$definitions["Dashboard"] = "Dashboard";
$definitions["Default forum language"] = "Default forum language";
$definitions["<strong>Delete</strong> all conversations forever."] = "<strong>Delete</strong> all conversations forever.";
$definitions["Delete Channel"] = "Delete Channel";
$definitions["Delete conversation"] = "Delete conversation";
$definitions["Delete member"] = "Delete member";
$definitions["Delete Member"] = "Delete Member";
$definitions["<strong>Delete this member's posts.</strong> All of this member's posts will be marked as deleted, but will be able to be restored manually."] = "<strong>Delete this member's posts.</strong> All of this member's posts will be marked as deleted, but will be able to be restored manually.";
$definitions["Delete"] = "Delete";
$definitions["Deleted %s by %s"] = "Deleted %s by %s";
$definitions["Deny"] = "Deny";
$definitions["Disable"] = "Disable";
$definitions["Discard"] = "Discard";
$definitions["Don't allow other users to see when I am online"] = "Don't allow other users to see when I am online";
$definitions["Don't have an account? <a href='%s' class='link-join'>Sign up!</a>"] = "Don't have an account? <a href='%s' class='link-join'>Sign up!</a>";
$definitions["Don't repeat"] = "Don't repeat";
$definitions["Don't require users to confirm their account"] = "Don't require users to confirm their account";

$definitions["Edit Channel"] = "Edit Channel";
$definitions["Edit Group"] = "Edit Group";
$definitions["Edit member groups"] = "Edit member groups";
$definitions["Edit your profile"] = "Edit your profile";
$definitions["Edit"] = "Edit";
$definitions["Edited %s by %s"] = "Edited %s by %s";
$definitions["Editing permissions"] = "Editing permissions";
$definitions["Email me when I'm added to a private conversation"] = "Email me when I'm added to a private conversation";
$definitions["Email me when someone mentions me in a post"] = "Email me when someone mentions me in a post";
$definitions["Email me when someone posts in a channel I have followed"] = "Email me when someone posts in a channel I have followed";
$definitions["Email me when someone posts in a conversation I have followed"] = "Email me when someone posts in a conversation I have followed";
$definitions["Email me when there is a new post by a member I have followed"] = "Email me when there is a new post by a member I have followed";
$definitions["Email"] = "Email";
$definitions["Enable"] = "Enable";
$definitions["Enabled"] = "Enabled";
$definitions["Enter a conversation title"] = "Enter a conversation title";
$definitions["Error"] = "Error";
$definitions["esoTalk version"] = "esoTalk version";
$definitions["Everyone"] = "Everyone";

$definitions["Fatal Error"] = "Something Went Wrong";
$definitions["Feed"] = "Feed";
$definitions["Filter by name or group..."] = "Filter by name or group...";
$definitions["Find this post"] = "Find this post";
$definitions["First posted"] = "First posted";
$definitions["Follow"] = "Follow";
$definitions["Follow to receive notifications"] = "Follow to receive notifications";
$definitions["Following"] = "Following";
$definitions["For %s seconds"] = "For %s seconds";
$definitions["Forever"] = "Forever";
$definitions["Forgot?"] = "Forgot?";
$definitions["Forgot Password"] = "Forgot Password";
$definitions["Forum"] = "Forum";
$definitions["Forum header"] = "Forum header";
$definitions["Forum language"] = "Forum language";
$definitions["Forum privacy"] = "Forum privacy";
$definitions["Forum Settings"] = "Forum Settings";
$definitions["Forum Statistics"] = "Forum Statistics";
$definitions["Forum title"] = "Forum title";
$definitions["forumDescription"] = "%s is a web-forum discussing %s, and %s.";

$definitions["Give this group the 'moderate' permission on all existing channels"] = "Give this group the 'moderate' permission on all existing channels";
$definitions["Global permissions"] = "Global permissions";
$definitions["Go to top"] = "Go to top";
$definitions["Group name"] = "Group name";
$definitions["group.administrator"] = "Administrator";
$definitions["group.administrator.plural"] = "Administrators";
$definitions["group.guest"] = "Guest";
$definitions["group.guest.plural"] = "Guests";
$definitions["group.member"] = "Member";
$definitions["group.member.plural"] = "Members";
$definitions["group.Moderator"] = "Moderator";
$definitions["group.Moderator.plural"] = "Moderators";
$definitions["group.suspended"] = "Suspended";
$definitions["Groups can be used to categorize members and give them certain privileges."] = "Groups can be used to categorize members and give them certain privileges.";
$definitions["Groups"] = "Groups";
$definitions["Guests can view the:"] = "Guests can view the:";

$definitions["Header"] = "Header";
$definitions["Header color"] = "Header color";
$definitions["Heads Up!"] = "Heads Up!";
$definitions["Hide"] = "Hide";
$definitions["Home page"] = "Home page";
$definitions["HTML is allowed."] = "HTML is allowed.";

$definitions["If you run into any other problems or just want some help with the installation, feel free to ask for assistance at the <a href='%s'>esoTalk support forum</a>."] = "If you run into any other problems or just want some help with the installation, feel free to ask for assistance at the <a href='%s'>esoTalk support forum</a>.";
$definitions["Install esoTalk"] = "Install esoTalk";
$definitions["Install My Forum"] = "Install My Forum";
$definitions["Installed Languages"] = "Installed Languages";
$definitions["Installed Plugins"] = "Installed Plugins";
$definitions["Installed plugins"] = "Installed plugins";
$definitions["Installed Skins"] = "Installed Skins";
$definitions["Installed skins"] = "Installed skins";
$definitions["is %s"] = "is %s";

$definitions["Joined"] = "Joined";
$definitions["just now"] = "just now";

$definitions["Keep me logged in"] = "Keep me logged in";
$definitions["<strong>Keep this member's posts.</strong> All of this member's posts will remain intact, but will show [deleted] as the author."] = "<strong>Keep this member's posts.</strong> All of this member's posts will remain intact, but will show [deleted] as the author.";

$definitions["label.draft"] = "Draft";
$definitions["label.locked"] = "Locked";
$definitions["label.ignored"] = "Ignored";
$definitions["label.private"] = "Private";
$definitions["label.sticky"] = "Sticky";
$definitions["Labels"] = "Labels";
$definitions["Last active"] = "Last active";
$definitions["Last active %s"] = "Last active %s";
$definitions["Latest"] = "Latest";
$definitions["Latest News"] = "Latest News";
$definitions["Loading..."] = "Loading...";
$definitions["Lock"] = "Lock";
$definitions["Log In"] = "Log In";
$definitions["Log Out"] = "Log Out";

$definitions["Make member and online list visible to:"] = "Make member and online list visible to:";
$definitions["Manage Channels"] = "Manage Channels";
$definitions["Manage Groups"] = "Manage Groups";
$definitions["Manage Languages"] = "Manage Languages";
$definitions["Manage your forum's channels (categories)"] = "Manage your forum's channels (categories)";
$definitions["Mark as read"] = "Mark as read";
$definitions["Mark as unread"] = "Mark as unread";
$definitions["Mark all as read"] = "Mark all as read";
$definitions["Mark listed as read"] = "Mark listed as read";
$definitions["Maximum size of %s. %s."] = "Maximum size of %s. %s.";
$definitions["Member groups"] = "Member groups";
$definitions["Member list"] = "Member list";
$definitions["Member List"] = "Member List";
$definitions["Member privacy"] = "Member privacy";
$definitions["Members"] = "Members";
$definitions["Members Allowed to View this Conversation"] = "Members Allowed to View this Conversation";
$definitions["Members Awaiting Approval"] = "Members Awaiting Approval";
$definitions["Members Online"] = "Members Online";
$definitions["Members who are part of this group can be listed by searching for the group name in the member list."] = "Members who are part of this group can be listed by searching for the group name in the member list.";
$definitions["Mobile skin"] = "Mobile skin";
$definitions["Moderate"] = "Moderate";
$definitions["<strong>Move</strong> conversations to the following channel:"] = "<strong>Move</strong> conversations to the following channel:";
$definitions["Mute conversation"] = "Mute conversation";
$definitions["MySQL database"] = "MySQL database";
$definitions["MySQL host address"] = "MySQL host address";
$definitions["MySQL password"] = "MySQL password";
$definitions["MySQL queries"] = "MySQL queries";
$definitions["MySQL table prefix"] = "MySQL table prefix";
$definitions["MySQL username"] = "MySQL username";
$definitions["MySQL version"] = "MySQL version";

$definitions["Name"] = "Name";
$definitions["never"] = "never";
$definitions["%s new"] = "%s new";
$definitions["New conversation"] = "New conversation";
$definitions["New Conversation"] = "New Conversation";
$definitions["New conversations in the past week"] = "New conversations in the past week";
$definitions["New email"] = "New email";
$definitions["New members in the past week"] = "New members in the past week";
$definitions["New password"] = "New password";
$definitions["New posts in the past week"] = "New posts in the past week";
$definitions["New username"] = "New username";
$definitions["Next Step"] = "Next Step";
$definitions["Next"] = "Next";
$definitions["No preview"] = "No preview";
$definitions["No"] = "No";
$definitions["Notifications"] = "Notifications";
$definitions["Now"] = "Now";

$definitions["OK"] = "OK";
$definitions["Online"] = "Online";
$definitions["online"] = "online";
$definitions["Only allow members of this group to see who else is in it"] = "Only allow members of this group to see who else is in it";
$definitions["Open registration"] = "Open registration";
$definitions["optional"] = "optional";
$definitions["Order By:"] = "Order By:";
$definitions["Original Post"] = "Original Post";

$definitions["Page Not Found"] = "Page Not Found";
$definitions["Password"] = "Password";
$definitions["PHP version"] = "PHP version";
$definitions["Plugins"] = "Plugins";
$definitions["Post a Reply"] = "Post a Reply";
$definitions["Post count"] = "Post count";
$definitions["Posts"] = "Posts";
$definitions["Powered by"] = "Powered by";
$definitions["Preview"] = "Preview";
$definitions["Previous"] = "Previous";

$definitions["Quote"] = "Quote";
$definitions["quote"] = "quote";

$definitions["Read more"] = "Read more";
$definitions["Recent posts"] = "Recent posts";
$definitions["Recover Password"] = "Recover Password";
$definitions["Registered members"] = "Registered members";
$definitions["Registration"] = "Registration";
$definitions["Registration Closed"] = "Registration Closed";
$definitions["Remove avatar"] = "Remove avatar";
$definitions["Rename Member"] = "Rename Member";
$definitions["Reply"] = "Reply";
$definitions["Report a bug"] = "Report a bug";
$definitions["Require administrator approval"] = "Require administrator approval";
$definitions["Require users to confirm their email address"] = "Require users to confirm their email address";
$definitions["Restore"] = "Restore";
$definitions["restore"] = "restore";
$definitions["Reset"] = "Reset";

$definitions["Save Changes"] = "Save Changes";
$definitions["Save Draft"] = "Save Draft";
$definitions["Search conversations..."] = "Search conversations...";
$definitions["Search within this conversation..."] = "Search within this conversation...";
$definitions["Search"] = "Search";
$definitions["See the private conversations I've had with %s"] = "See the private conversations I've had with %s";
$definitions["Set a New Password"] = "Set a New Password";
$definitions["Settings"] = "Settings";
$definitions["Show an image in the header"] = "Show an image in the header";
$definitions["Show in context"] = "Show in context";
$definitions["Show matching posts"] = "Show matching posts";
$definitions["Show the channel list by default"] = "Show the channel list by default";
$definitions["Show the conversation list by default"] = "Show the conversation list by default";
$definitions["Show the forum title in the header"] = "Show the forum title in the header";
$definitions["Sign Up"] = "Sign Up";
$definitions["Skins"] = "Skins";
$definitions["Sort By"] = "Sort By";
$definitions["Specify Setup Information"] = "Specify Setup Information";
$definitions["Star to receive notifications"] = "Follow to receive notifications";
$definitions["Starred"] = "Following";
$definitions["Start"] = "Start";
$definitions["Start a conversation"] = "Start a conversation";
$definitions["Start a new conversation"] = "Start a new conversation";
$definitions["Start a private conversation with %s"] = "Start a private conversation with %s";
$definitions["Start Conversation"] = "Start Conversation";
$definitions["Starting a conversation"] = "Starting a conversation";
$definitions["Statistics"] = "Statistics";
$definitions["statistic.conversation.plural"] = "%s conversations";
$definitions["statistic.conversation"] = "%s conversation";
$definitions["statistic.member.plural"] = "%s members";
$definitions["statistic.member"] = "%s member";
$definitions["statistic.online.plural"] = "%s online";
$definitions["statistic.online"] = "%s online";
$definitions["statistic.post.plural"] = "%s posts";
$definitions["statistic.post"] = "%s post";
$definitions["Sticky"] = "Sticky";
$definitions["Subscribe"] = "Subscribe";
$definitions["Subscribed"] = "Subscribed";
$definitions["Subscription"] = "Subscription";
$definitions["Success!"] = "Success!";
$definitions["Suspend member"] = "Suspend member";
$definitions["Suspend members."] = "Suspend members.";
$definitions["Suspend"] = "Suspend";

$definitions["To get started with your forum, you might like to:"] = "To get started with your forum, you might like to:";

$definitions["Unapproved"] = "Unapproved";
$definitions["Unhide"] = "Unhide";
$definitions["Uninstall"] = "Uninstall";
$definitions["Unlock"] = "Unlock";
$definitions["Unmute conversation"] = "Unmute conversation";
$definitions["Unstarred"] = "Not following";
$definitions["Unsticky"] = "Unsticky";
$definitions["Unsubscribe new users by default"] = "Unsubscribe new users by default";
$definitions["Unsubscribe"] = "Unsubscribe";
$definitions["Unsubscribed"] = "Unsubscribed";
$definitions["Unsuspend member"] = "Unsuspend member";
$definitions["Unsuspend"] = "Unsuspend";
$definitions["Until someone replies"] = "Until someone replies";
$definitions["Untitled conversation"] = "Untitled conversation";
$definitions["Upgrade esoTalk"] = "Upgrade esoTalk";
$definitions["Use a background image"] = "Use a background image";
$definitions["Use for mobile"] = "Use for mobile";
$definitions["Use friendly URLs"] = "Use friendly URLs";
$definitions["Used to verify your account and subscribe to conversations"] = "Used to verify your account and subscribe to conversations";
$definitions["Username"] = "Username";
$definitions["Username or Email"] = "Username or Email";

$definitions["View %s's profile"] = "View %s's profile";
$definitions["View all notifications"] = "View all notifications";
$definitions["View more"] = "View more";
$definitions["View your profile"] = "View your profile";
$definitions["View"] = "View";
$definitions["Viewing: %s"] = "Viewing: %s";
$definitions["viewingPosts"] = "<b>%s-%s</b> of %s posts";

$definitions["Warning"] = "Warning";
$definitions["Welcome to esoTalk!"] = "Welcome to esoTalk!";
$definitions["We've logged you in and taken you straight to your forum's administration panel. You're welcome."] = "We've logged you in and taken you straight to your forum's administration panel. You're welcome.";
$definitions["Write a reply..."] = "Write a reply...";

$definitions["Yes"] = "Yes";
$definitions["You can manage channel-specific permissions on the channels page."] = "You can manage channel-specific permissions on the channels page.";
$definitions["Your current password"] = "Your current password";


// Messages.
$definitions["message.404"] = "Oh dear - the page you requested could not be found! Try going back and clicking a different link. Or something else.";
$definitions["message.accountNotYetApproved"] = "The administrator hasn't yet approved your account. Patience is a virtue!";
$definitions["message.ajaxDisconnected"] = "Unable to communicate with the server. Wait a few seconds and <a href='javascript:jQuery.ETAjax.resumeAfterDisconnection()'>try again</a>, or <a href='' onclick='window.location.reload();return false'>refresh the page</a>.";
$definitions["message.ajaxRequestPending"] = "Hey! We're still processing some of your stuff! If you navigate away from this page you might lose any recent changes you've made.";
$definitions["message.avatarError"] = "There was a problem uploading your avatar. Make sure you're using a valid image type (like .jpg, .png, or .gif) and the file isn't really really huge.";
$definitions["message.cannotDeleteLastChannel"] = "Hey, wait up, you can't delete the last channel! Where would your conversations go? That's just silly.";
$definitions["message.cannotEditSinceReply"] = "You can't edit your post because someone has replied since you posted it.";
$definitions["message.changesSaved"] = "Your changes were saved.";
$definitions["message.channelsHelp"] = "Channels are used to categorize conversations on your forum. You can create as many channels as needed, and rearrange/nest them by dragging and dropping below.";
$definitions["message.channelSlugTaken"] = "This slug is already in use by another channel.";
$definitions["message.confirmDelete"] = "Are you sure you want to delete this? Seriously, you won't be able to get it back.";
$definitions["message.confirmDiscardPost"] = "You have not saved your post as a draft. Do you wish to discard it?";
$definitions["message.confirmEmail"] = "Before you can start using your newly-created account, you'll need to confirm your email address. Within the next minute or two you should receive an email from us containing a link to activate your account.";
$definitions["message.confirmLeave"] = "Woah, you haven't saved the stuff you are editing! If you leave this page, you'll lose any changes you've made. Is this ok?";
$definitions["message.connectionError"] = "esoTalk could not connect to the MySQL server. The error returned was:<br/>%s";
$definitions["message.conversationDeleted"] = "The conversation was deleted. Didn't that feel good?";
$definitions["message.conversationNotFound"] = "For some reason this conversation cannot be viewed. It may not exist, or you may not have permission to view it.";
$definitions["message.cookieAuthenticationTheft"] = "For security reasons, we couldn't log you in with your 'remember me' cookie. Please log in manually!";
$definitions["message.deleteChannelHelp"] = "Woah, hold up there! If you delete this channel, there'll be no way to get it back. Unless you build a time machine. But, uh, there'll be no <em>easy</em> way to get it back. All of the conversations in this channel can be moved to another of your choice.";
$definitions["message.emailConfirmed"] = "Cool! Your account has been validated and you can now start participating in conversations. Why not <a href='".URL("conversation/start")."'>start one</a> yourself?";
$definitions["message.emailDoesntExist"] = "That email address doesn't match any members in the database. Did you make a typo?";
$definitions["message.emailNotYetConfirmed"] = "You need to confirm your email before you can log in with it! If you didn't receive the confirmation email, please check your spam folder or <a href='%s'>click here to get it sent again</a>.";
$definitions["message.emailTaken"] = "Curses, there is already a member with this email!";
$definitions["message.empty"] = "You must fill out this field.";
$definitions["message.emptyPost"] = "Yeah... uh, you should probably type something in your post.";
$definitions["message.emptyTitle"] = "The title of your conversation can't be blank. I mean, how can anyone click on a blank title? Think about it.";
$definitions["message.esoTalkAlreadyInstalled"] = "<strong>esoTalk is already installed.</strong> To reinstall esoTalk, you must remove <code>config/config.php</code>.";
$definitions["message.esoTalkUpdateAvailable"] = "A new version of esoTalk, %s, is now available.";
$definitions["message.esoTalkUpdateAvailableHelp"] = "It's recommended to always have the latest version of esoTalk installed to reduce security risk. And hey, there might be some cool new features!";
$definitions["message.esoTalkUpToDate"] = "Your version of esoTalk is up-to-date.";
$definitions["message.esoTalkUpToDateHelp"] = "esoTalk is developed in the spare time of a college student. Please consider <a href='%s' target='_blank'>donating</a> to keep it alive!";
$definitions["message.fatalError"] = "esoTalk has encountered a fatal error. Try again, or <a href='%1\$s' target='_blank'>get help</a>.";
$definitions["message.fileUploadFailed"] = "Something went wrong and the file you selected could not be uploaded. Perhaps it's too big, or in the wrong format?";
$definitions["message.fileUploadFailedMove"] = "The file you uploaded could not be copied to its destination. Please contact the forum administrator.";
$definitions["message.fileUploadNotImage"] = "The file you uploaded is not an image in an acceptable format.";
$definitions["message.fileUploadTooBig"] = "The file you selected could not be uploaded because it is too big.";
$definitions["message.forgotPasswordHelp"] = "So, you forgot your password! Don't worry, it happens all the time. Simply enter your email address and we'll send you instructions on how to set up a new one.";
$definitions["message.fulltextKeywordWarning"] = "Note that keywords less than 4 characters in length, and common English words such as 'the' and 'for', aren't included in the search criteria.";
$definitions["message.gambitsHelp"] = "Gambits are phrases that describe what you are looking for. Click on a gambit to insert it into the search field. Double-click on a gambit to instantly search for it. Normal search keywords work too!";
$definitions["message.gdNotEnabledWarning"] = "<strong>The GD extension is not enabled.</strong> This is required to resize and save avatars. Get your host or administrator to install/enable it.";
$definitions["message.greaterMySQLVersionRequired"] = "<strong>You must have MySQL 4 or greater installed and the <a href='http://php.net/manual/en/mysql.installation.php' target='_blank'>MySQL extension enabled in PHP</a>.</strong> Please install/upgrade both of these requirements or request that your host or administrator install them.";
$definitions["message.greaterPHPVersionRequired"] = "<strong>Your server must have PHP %s or greater installed to run esoTalk.</strong> Please upgrade your PHP installation or request that your host or administrator upgrade the server.";
$definitions["message.incorrectLogin"] = "Your login details were incorrect.";
$definitions["message.incorrectPassword"] = "Your current password is incorrect.";
$definitions["message.installerAdminHelp"] = "esoTalk will use the following information to set up your administrator account on your forum.";
$definitions["message.installerFilesNotWritable"] = "<strong>esoTalk cannot write to the following files/folders: %s.</strong> To resolve this, you must navigate to these files/folders in your FTP client and <code>chmod</code> them to <code>0777</code>.";
$definitions["message.installerWelcome"] = "Set up your fat-free forum but by filling out the form below.<br>If you have any trouble, get help on the <a href='%s' target='_blank'>esoTalk website</a>.";
$definitions["message.invalidChannel"] = "You selected an invalid channel!";
$definitions["message.invalidEmail"] = "Seems this email address isn't valid...";
$definitions["message.invalidUsername"] = "You must choose a username between 3 and 20 alphanumeric characters.";
$definitions["message.javascriptRequired"] = "This page requires JavaScript to function properly. Please enable it!";
$definitions["message.languageUninstalled"] = "The language was uninstalled.";
$definitions["message.locked"] = "Hm, looks like this conversation is <strong>locked</strong>, so you can't reply to it.";
$definitions["message.loginToParticipate"] = "To start conversations or reply to posts, please log in.";
$definitions["message.logInToReply"] = "<a href='%1\$s' class='link-login'>Log In</a> or <a href='%2\$s' class='link-join'>Sign Up</a> to reply!";
$definitions["message.logInToSeeAllConversations"] = "<a href='".URL("user/login")."' class='link-login'>Log in</a> to expose some channels/conversations that may be hidden to guests.";
$definitions["message.memberNotFound"] = "Hm, there doesn't seem to be a member with that name.";
$definitions["message.memberNoPermissionView"] = "That member can't be added because they don't have permission to view the channel that this conversation is in.";
$definitions["message.nameTaken"] = "The name you have entered is taken or is a reserved word.";
$definitions["message.newSearchResults"] = "There has been new activity that has affected your search results. <a href='%s'>Refresh</a>";
$definitions["message.noActivity"] = "%s hasn't done anything on this forum yet!";
$definitions["message.noChannels"] = "No channels are visible.";
$definitions["message.noMembersOnline"] = "No members are currently online.";
$definitions["message.noNotifications"] = "You have no notifications.";
$definitions["message.noPermission"] = "You do not have permission to perform this action.";
$definitions["message.noPermissionToReplyInChannel"] = "You don't have permission to reply to conversations in this channel.";
$definitions["message.noPluginsInstalled"] = "No plugins are currently installed.";
$definitions["message.noSearchResults"] = "No conversations matching your search were found.";
$definitions["message.noSearchResultsMembers"] = "No members matching your search were found.";
$definitions["message.noSearchResultsPosts"] = "No posts matching your search were found.";
$definitions["message.noSkinsInstalled"] = "No skins are currently installed.";
$definitions["message.notWritable"] = "<code>%s</code> is not writeable. Try <code>chmod</code>ing it to <code>777</code>, or if it doesn't exist, <code>chmod</code> the folder it is contained within.";
$definitions["message.pageNotFound"] = "The page you're looking for could not be found.";
$definitions["message.passwordChanged"] = "Alright, your password has been changed. Now you can log in! Hey, try not to forget it again, OK?";
$definitions["message.passwordEmailSent"] = "Ok, we've sent you an email containing a link to reset your password. Check your spam folder if you don't receive it within the next minute or two. Yeah, some times we get put through to spam - can you believe it?!";
$definitions["message.passwordsDontMatch"] = "Your passwords do not match.";
$definitions["message.passwordTooShort"] = "Your password is too short.";
$definitions["message.pluginCannotBeEnabled"] = "The plugin <em>%s</em> cannot be enabled: %s";
$definitions["message.pluginDependencyNotMet"] = "To enable this plugin, you must have %s version %s installed and enabled.";
$definitions["message.pluginUninstalled"] = "The plugin was uninstalled.";
$definitions["message.postNotFound"] = "The post you're looking for could not be found.";
$definitions["message.postTooLong"] = "Your post is really, really long! Too long! The maximum number of characters allowed is %s. That's really long!";
$definitions["message.preInstallErrors"] = "These errors must be resolved before you can continue the installation.";
$definitions["message.preInstallWarnings"] = "You can continue the esoTalk install without resolving the following warnings, but some esoTalk functionality may be limited.";
$definitions["message.reduceNumberOfGambits"] = "Reduce the number of gambits or search keywords you're using to find a broader range of conversations.";
$definitions["message.registerGlobalsWarning"] = "<strong>PHP's register_globals setting is enabled.</strong> While esoTalk can run with this setting on, it is recommended that it be turned off to increase security and to prevent esoTalk from having problems.";
$definitions["message.registrationClosed"] = "Registration on this forum is not open to the public.";
$definitions["message.removeDirectoryWarning"] = "Hey! Looks like you haven't deleted the <code>%s</code> directory like we told you to! You probably should, just to make sure those hackers can't do anything naughty.";
$definitions["message.safeModeWarning"] = "<strong>Safe mode is enabled.</strong> This could potentially cause problems with esoTalk, but you can still proceed if you cannot turn it off.";
$definitions["message.searchAllConversations"] = "Try searching for this term across all conversations.";
$definitions["message.setNewPassword"] = "Alright! Now, what do you want your new password to be?";
$definitions["message.skinUninstalled"] = "The skin was uninstalled.";
$definitions["message.suspended"] = "Ouch! A forum moderator has <strong>suspended</strong> your account. It sucks, but until the suspension is lifted you won't be able to do much around here. Hey, screw them!";
$definitions["message.suspendMemberHelp"] = "Suspending %s will prevent them from replying to conversations, starting conversations, and viewing private conversations. They will effectively have the same permissions as a guest.";
$definitions["message.tablePrefixConflict"] = "The installer has detected that there is another installation of esoTalk in the same MySQL database with the same table prefix.<br>• To overwrite this installation, click 'Install' again. <strong>All data will be lost.</strong><br>• To create a new installation alongside this one, change the table prefix.";
$definitions["message.unsuspendMemberHelp"] = "Unsuspending %s will enable them to participate in conversations on this forum again.";
$definitions["message.upgradeSuccessful"] = "esoTalk was successfully upgraded.";
$definitions["message.waitForApproval"] = "Before you can start using your newly-created account, an administrator must approve your account. We'll send you an email when you've been approved!";
$definitions["message.waitToReply"] = "You must wait at least %s seconds between starting or replying to conversations. Take a deep breath and try again.";
$definitions["message.waitToSearch"] = "Woah, slow down! Looks like you're trying to perform a few too many searches. Wait %s seconds and try again.";


// Emails.
$definitions["email.header"] = "<p>Hey %s!</p>";
$definitions["email.footer"] = "<p>(If you don't want to receive any emails like this again, you can <a href='%s'>change your notification preferences</a>.)</p>";

$definitions["email.confirmEmail.subject"] = "%1\$s, please confirm your email address";
$definitions["email.confirmEmail.body"] = "<p>Someone (hopefully you!) has signed up to the forum '%1\$s' with this email address.</p><p>If this was you, simply visit the following link and your account will be activated:<br>%2\$s</p>";

$definitions["email.approved.subject"] = "%1\$s, your account has been approved";
$definitions["email.approved.body"] = "<p>Your account on %1\$s has been approved.</p><p>Visit the following link to log in and start talking:<br>%2\$s</p>";

$definitions["email.forgotPassword.subject"] = "Did you forget your password, %1\$s?";
$definitions["email.forgotPassword.body"] = "<p>Someone (hopefully you!) has submitted a forgotten password request for your account on the forum '%1\$s'. If you do not wish to change your password, just ignore this email and nothing will happen.</p><p>However, if you did forget your password and wish to set a new one, visit the following link:<br>%2\$s</p>";

$definitions["email.mention.subject"] = "[Mentioned by %1\$s] %2\$s";
$definitions["email.mention.body"] = "<p><strong>%1\$s</strong> mentioned you in a post in the conversation <strong>%2\$s</strong>.</p><hr>%3\$s<hr><p>To view the post in context, check out the following link:<br>%4\$s</p>";

$definitions["email.privateAdd.subject"] = "[Private] %1\$s";
$definitions["email.privateAdd.body"] = "<p>You have been added to a private conversation titled <strong>%1\$s</strong>.</p><hr>%2\$s<hr><p>To view this conversation, check out the following link:<br>%3\$s</p>";

$definitions["email.post.subject"] = "[New Reply] %1\$s";
$definitions["email.post.body"] = "<p><strong>%1\$s</strong> has replied to a conversation which you followed: <strong>%2\$s</strong></p><hr>%3\$s<hr><p>To view the new activity, check out the following link:<br>%4\$s</p>";


// Translating the gambit system can be quite complex, but we'll do our best to get you through it. :)
// Note: Don't use any html entities in these definitions, except for: &lt; &gt; &amp; &#39;

// Simple gambits
// These gambits are pretty much evaluated as-they-are.
// tag:, author:, contributor:, and quoted: are combined with a value after the colon (:).
// For example: tag:video games, author:myself
$definitions["gambit.author:"] = "author:";
$definitions["gambit.contributor:"] = "contributor:";
$definitions["gambit.member"] = "member";
$definitions["gambit.myself"] = "myself";
$definitions["gambit.draft"] = "draft";
$definitions["gambit.locked"] = "locked";
$definitions["gambit.order by newest"] = "order by newest";
$definitions["gambit.order by replies"] = "order by replies";
$definitions["gambit.private"] = "private";
$definitions["gambit.random"] = "random";
$definitions["gambit.reverse"] = "reverse";
$definitions["gambit.starred"] = "followed";
$definitions["gambit.ignored"] = "ignored";
$definitions["gambit.sticky"] = "sticky";
$definitions["gambit.unread"] = "unread";
$definitions["gambit.limit:"] = "limit:";

// Aliases
// These are gambits which tell the gambit system to use another gambit.
// In other words, when you type "active today", the gambit system interprets it as if you typed "active 1 day".
// The first of each pair, the alias, can be anything you want.
// The second, however, must fit with the regular expression pattern defined below (more on that later.)
$definitions["gambit.active today"] = "active today"; // what appears in the gambit cloud
$definitions["gambit.active 1 day"] = "active 1 day"; // what it actually evaluates to

$definitions["gambit.has replies"] = "has replies";
$definitions["gambit.has >0 replies"] = "has >0 replies";
$definitions["gambit.has >10 replies"] = "has >10 replies";

$definitions["gambit.has no replies"] = "has no replies";
$definitions["gambit.has 0 replies"] = "has 0 replies";

$definitions["gambit.dead"] = "dead";
$definitions["gambit.active >30 day"] = "active >30 day";

// Units of time
// These are used in the active gambit.
// ex. "[active] [>|<|>=|<=|last] 180 [second|minute|hour|day|week|month|year]"
$definitions["gambit.second"] = "second";
$definitions["gambit.minute"] = "minute";
$definitions["gambit.hour"] = "hour";
$definitions["gambit.day"] = "day";
$definitions["gambit.week"] = "week";
$definitions["gambit.month"] = "month";
$definitions["gambit.year"] = "year";
$definitions["gambit.last"] = "last"; // as in "active last 180 days"
$definitions["gambit.active"] = "active"; // as in "active last 180 days"

// Now the hard bit. This is a regular expression to test for the "active" gambit.
// The group (?<a> ... ) is the comparison operator (>, <, >=, <=, or last).
// The group (?<b> ... ) is the number (ex. 24).
// The group (?<c> ... ) is the unit of time.
// The languages of "last" and the units of time are defined above.
// However, if you need to reorder the groups, do so carefully, and make sure spaces are written as " *".
$definitions["gambit.gambitActive"] = "/^{$definitions["gambit.active"]} *(?<a>>|<|>=|<=|{$definitions["gambit.last"]})? *(?<b>\d+) *(?<c>{$definitions["gambit.second"]}|{$definitions["gambit.minute"]}|{$definitions["gambit.hour"]}|{$definitions["gambit.day"]}|{$definitions["gambit.week"]}|{$definitions["gambit.month"]}|{$definitions["gambit.year"]})/";

// These appear in the tag cloud. They must fit the regular expression pattern where the ? is a number.
// If the regular expression pattern has been reordered, these gambits must also be reordered (as well as the ones in aliases.)
$definitions["gambit.active last ? hours"] = "{$definitions["gambit.active"]} {$definitions["gambit.last"]} ? {$definitions["gambit.hour"]}s";
$definitions["gambit.active last ? days"] = "{$definitions["gambit.active"]} {$definitions["gambit.last"]} ? {$definitions["gambit.day"]}s";

// This is similar to the regular expression for the active gambit, but for the "has n reply(s)" gambit.
// Usually you just need to change the "has" and "repl".
$definitions["gambit.gambitHasNReplies"] = "/^has *(?<a>>|<|>=|<=)? *(?<b>\d+) *repl/";
