--
-- Table structure for table `admlog`
--

DROP TABLE IF EXISTS `admlog`;
CREATE TABLE `admlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admlog`
--

LOCK TABLES `admlog` WRITE;
/*!40000 ALTER TABLE `admlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `admlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `antimat`
--

DROP TABLE IF EXISTS `antimat`;
CREATE TABLE `antimat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `string` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `antimat`
--

LOCK TABLES `antimat` WRITE;
/*!40000 ALTER TABLE `antimat` DISABLE KEYS */;
/*!40000 ALTER TABLE `antimat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ban`
--

DROP TABLE IF EXISTS `ban`;
CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ban`
--

LOCK TABLES `ban` WRITE;
/*!40000 ALTER TABLE `ban` DISABLE KEYS */;
/*!40000 ALTER TABLE `ban` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `banhist`
--

DROP TABLE IF EXISTS `banhist`;
CREATE TABLE `banhist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `send` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `term` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `banhist`
--

LOCK TABLES `banhist` WRITE;
/*!40000 ALTER TABLE `banhist` DISABLE KEYS */;
/*!40000 ALTER TABLE `banhist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank`
--

DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sum` int(11) unsigned NOT NULL DEFAULT '0',
  `oper` int(11) unsigned NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `bank`
--

LOCK TABLES `bank` WRITE;
/*!40000 ALTER TABLE `bank` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blacklist`
--

DROP TABLE IF EXISTS `blacklist`;
CREATE TABLE `blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `value` (`value`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `blacklist`
--

LOCK TABLES `blacklist` WRITE;
/*!40000 ALTER TABLE `blacklist` DISABLE KEYS */;
INSERT INTO `blacklist` VALUES (1,3,'asdasd.ru',NULL,1482942521);
/*!40000 ALTER TABLE `blacklist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `tags` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rating` mediumint(9) NOT NULL DEFAULT '0',
  `visits` int(11) unsigned NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bookmarks`
--

DROP TABLE IF EXISTS `bookmarks`;
CREATE TABLE `bookmarks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic_id` mediumint(8) unsigned NOT NULL,
  `forum_id` smallint(5) unsigned NOT NULL,
  `posts` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_id` (`topic_id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `bookmarks`
--

LOCK TABLES `bookmarks` WRITE;
/*!40000 ALTER TABLE `bookmarks` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookmarks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cats`
--

DROP TABLE IF EXISTS `cats`;
CREATE TABLE `cats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0',
  `parent` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `folder` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cats`
--

LOCK TABLES `cats` WRITE;
/*!40000 ALTER TABLE `cats` DISABLE KEYS */;
/*!40000 ALTER TABLE `cats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catsblog`
--

DROP TABLE IF EXISTS `catsblog`;
CREATE TABLE `catsblog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `catsblog`
--

LOCK TABLES `catsblog` WRITE;
/*!40000 ALTER TABLE `catsblog` DISABLE KEYS */;
/*!40000 ALTER TABLE `catsblog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `changemail`
--

DROP TABLE IF EXISTS `changemail`;
CREATE TABLE `changemail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mail` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `changemail`
--

LOCK TABLES `changemail` WRITE;
/*!40000 ALTER TABLE `changemail` DISABLE KEYS */;
/*!40000 ALTER TABLE `changemail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat`
--

DROP TABLE IF EXISTS `chat`;
CREATE TABLE `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `edit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edit_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `chat`
--

LOCK TABLES `chat` WRITE;
/*!40000 ALTER TABLE `chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `relate_type` enum('blog','event','down','news','offer','gallery') COLLATE utf8mb4_unicode_ci NOT NULL,
  `relate_category_id` int(11) unsigned NOT NULL,
  `relate_id` int(11) unsigned NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relate_type` (`relate_type`,`relate_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact`
--

DROP TABLE IF EXISTS `contact`;
CREATE TABLE `contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `contact`
--

LOCK TABLES `contact` WRITE;
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter`
--

DROP TABLE IF EXISTS `counter`;
CREATE TABLE `counter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hours` mediumint(8) unsigned NOT NULL,
  `days` mediumint(8) unsigned NOT NULL,
  `allhosts` int(11) unsigned NOT NULL,
  `allhits` int(11) unsigned NOT NULL,
  `dayhosts` mediumint(8) unsigned NOT NULL,
  `dayhits` mediumint(8) unsigned NOT NULL,
  `hosts24` mediumint(8) unsigned NOT NULL,
  `hits24` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `counter`
--

LOCK TABLES `counter` WRITE;
/*!40000 ALTER TABLE `counter` DISABLE KEYS */;
INSERT INTO `counter` VALUES (1,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `counter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter24`
--

DROP TABLE IF EXISTS `counter24`;
CREATE TABLE `counter24` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hour` mediumint(8) unsigned NOT NULL,
  `hosts` mediumint(8) unsigned NOT NULL,
  `hits` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hour` (`hour`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `counter24`
--

LOCK TABLES `counter24` WRITE;
/*!40000 ALTER TABLE `counter24` DISABLE KEYS */;
/*!40000 ALTER TABLE `counter24` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter31`
--

DROP TABLE IF EXISTS `counter31`;
CREATE TABLE `counter31` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `days` mediumint(8) unsigned NOT NULL,
  `hosts` mediumint(8) unsigned NOT NULL,
  `hits` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `days` (`days`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `counter31`
--

LOCK TABLES `counter31` WRITE;
/*!40000 ALTER TABLE `counter31` DISABLE KEYS */;
/*!40000 ALTER TABLE `counter31` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `downs`
--

DROP TABLE IF EXISTS `downs`;
CREATE TABLE `downs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `link` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `site` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `screen` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rating` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rated` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `loads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_load` int(11) NOT NULL DEFAULT '0',
  `app` tinyint(1) NOT NULL DEFAULT '0',
  `notice` text COLLATE utf8mb4_unicode_ci,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `time` (`time`),
  FULLTEXT KEY `text` (`text`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `downs`
--

LOCK TABLES `downs` WRITE;
/*!40000 ALTER TABLE `downs` DISABLE KEYS */;
/*!40000 ALTER TABLE `downs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `error`
--

DROP TABLE IF EXISTS `error`;
CREATE TABLE `error` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num` smallint(6) NOT NULL,
  `request` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `num_time` (`num`,`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `error`
--

LOCK TABLES `error` WRITE;
/*!40000 ALTER TABLE `error` DISABLE KEYS */;
/*!40000 ALTER TABLE `error` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `top` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files_forum`
--

DROP TABLE IF EXISTS `files_forum`;
CREATE TABLE `files_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` mediumint(8) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `hash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(11) unsigned NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic_id` (`topic_id`),
  KEY `post_id` (`post_id`),
  KEY `user` (`user`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `files_forum`
--

LOCK TABLES `files_forum` WRITE;
/*!40000 ALTER TABLE `files_forum` DISABLE KEYS */;
/*!40000 ALTER TABLE `files_forum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flood`
--

DROP TABLE IF EXISTS `flood`;
CREATE TABLE `flood` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flood`
--

LOCK TABLES `flood` WRITE;
/*!40000 ALTER TABLE `flood` DISABLE KEYS */;
/*!40000 ALTER TABLE `flood` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forums`
--

DROP TABLE IF EXISTS `forums`;
CREATE TABLE `forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0',
  `parent` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desc` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics` int(11) unsigned NOT NULL DEFAULT '0',
  `posts` int(11) unsigned NOT NULL DEFAULT '0',
  `last_id` int(11) unsigned NOT NULL DEFAULT '0',
  `last_themes` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_time` int(11) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `forums`
--

LOCK TABLES `forums` WRITE;
/*!40000 ALTER TABLE `forums` DISABLE KEYS */;
/*!40000 ALTER TABLE `forums` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guest`
--

DROP TABLE IF EXISTS `guest`;
CREATE TABLE `guest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `reply` text COLLATE utf8mb4_unicode_ci,
  `edit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edit_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `guest`
--

LOCK TABLES `guest` WRITE;
/*!40000 ALTER TABLE `guest` DISABLE KEYS */;
/*!40000 ALTER TABLE `guest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ignoring`
--

DROP TABLE IF EXISTS `ignoring`;
CREATE TABLE `ignoring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ignoring`
--

LOCK TABLES `ignoring` WRITE;
/*!40000 ALTER TABLE `ignoring` DISABLE KEYS */;
/*!40000 ALTER TABLE `ignoring` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inbox`
--

DROP TABLE IF EXISTS `inbox`;
CREATE TABLE `inbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inbox`
--

LOCK TABLES `inbox` WRITE;
/*!40000 ALTER TABLE `inbox` DISABLE KEYS */;
/*!40000 ALTER TABLE `inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invite`
--

DROP TABLE IF EXISTS `invite`;
CREATE TABLE `invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invited` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `used` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`),
  KEY `used` (`used`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `invite`
--

LOCK TABLES `invite` WRITE;
/*!40000 ALTER TABLE `invite` DISABLE KEYS */;
/*!40000 ALTER TABLE `invite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `loads`
--

DROP TABLE IF EXISTS `loads`;
CREATE TABLE `loads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `down` mediumint(8) unsigned NOT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `loads`
--

LOCK TABLES `loads` WRITE;
/*!40000 ALTER TABLE `loads` DISABLE KEYS */;
/*!40000 ALTER TABLE `loads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `login`
--

DROP TABLE IF EXISTS `login`;
CREATE TABLE `login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `login`
--

LOCK TABLES `login` WRITE;
/*!40000 ALTER TABLE `login` DISABLE KEYS */;
/*!40000 ALTER TABLE `login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lotinfo`
--

DROP TABLE IF EXISTS `lotinfo`;
CREATE TABLE `lotinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` smallint(5) unsigned NOT NULL,
  `sum` int(11) unsigned NOT NULL DEFAULT '0',
  `newnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `oldnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `winners` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `lotinfo`
--

LOCK TABLES `lotinfo` WRITE;
/*!40000 ALTER TABLE `lotinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `lotinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lotusers`
--

DROP TABLE IF EXISTS `lotusers`;
CREATE TABLE `lotusers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `lotusers`
--

LOCK TABLES `lotusers` WRITE;
/*!40000 ALTER TABLE `lotusers` DISABLE KEYS */;
/*!40000 ALTER TABLE `lotusers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL,
  `migration_name` varchar(100) DEFAULT NULL,
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `breakpoint` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (20161216115019,'CreateAdmlogTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115201,'CreateAntimatTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115222,'CreateBanTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115301,'CreateBanhistTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115501,'CreateBankTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115644,'CreateBlacklistTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115732,'CreateBlogsTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115912,'CreateBookmarksTable','2016-12-28 16:21:55','2016-12-28 16:21:55',0),(20161216115924,'CreateCatsTable','2016-12-28 16:21:55','2016-12-28 16:21:56',0),(20161216115945,'CreateCatsblogTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120203,'CreateChangemailTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120211,'CreateChatTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120219,'CreateCommentsTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120248,'CreateContactTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120259,'CreateCounterTable','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120310,'CreateCounter24Table','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120320,'CreateCounter31Table','2016-12-28 16:21:56','2016-12-28 16:21:56',0),(20161216120359,'CreateDownsTable','2016-12-28 16:21:56','2016-12-28 16:21:57',0),(20161216120409,'CreateErrorTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120430,'CreateEventsTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120452,'CreateFilesForumTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120503,'CreateFloodTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120511,'CreateForumsTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120524,'CreateGuestTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120539,'CreateIgnoringTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120546,'CreateInboxTable','2016-12-28 16:21:57','2016-12-28 16:21:57',0),(20161216120553,'CreateInviteTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120600,'CreateLoadsTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120610,'CreateLoginTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120637,'CreateLotinfoTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120648,'CreateLotusersTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120656,'CreateNewsTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120704,'CreateNoteTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120711,'CreateNotebookTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120717,'CreateNoticeTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120723,'CreateOffersTable','2016-12-28 16:21:58','2016-12-28 16:21:58',0),(20161216120741,'CreateOnlineTable','2016-12-28 16:21:58','2016-12-28 16:21:59',0),(20161216120750,'CreateOutboxTable','2016-12-28 16:21:59','2016-12-28 16:21:59',0),(20161216120757,'CreatePhotoTable','2016-12-28 16:21:59','2016-12-28 16:21:59',0),(20161216120808,'CreatePollingsTable','2016-12-28 16:21:59','2016-12-28 16:21:59',0),(20161216120820,'CreatePostsTable','2016-12-28 16:21:59','2016-12-28 16:22:00',0),(20161216120835,'CreateRatingTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120844,'CreateReadblogTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120851,'CreateRekuserTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120859,'CreateRulesTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120907,'CreateSettingTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120918,'CreateSmilesTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120927,'CreateSocialsTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216120949,'CreateSpamTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216121004,'CreateStatusTable','2016-12-28 16:22:00','2016-12-28 16:22:00',0),(20161216121013,'CreateTopicsTable','2016-12-28 16:22:00','2016-12-28 16:22:01',0),(20161216121022,'CreateTransfersTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121030,'CreateTrashTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121040,'CreateUsersTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121054,'CreateVisitTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121101,'CreateVoteTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121107,'CreateVoteanswerTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121116,'CreateVotepollTable','2016-12-28 16:22:01','2016-12-28 16:22:01',0),(20161216121123,'CreateWallTable','2016-12-28 16:22:01','2016-12-28 16:22:02',0);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `news`
--

DROP TABLE IF EXISTS `news`;
CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `top` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `news`
--

LOCK TABLES `news` WRITE;
/*!40000 ALTER TABLE `news` DISABLE KEYS */;
/*!40000 ALTER TABLE `news` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `note`
--

DROP TABLE IF EXISTS `note`;
CREATE TABLE `note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `edit` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `note`
--

LOCK TABLES `note` WRITE;
/*!40000 ALTER TABLE `note` DISABLE KEYS */;
/*!40000 ALTER TABLE `note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notebook`
--

DROP TABLE IF EXISTS `notebook`;
CREATE TABLE `notebook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notebook`
--

LOCK TABLES `notebook` WRITE;
/*!40000 ALTER TABLE `notebook` DISABLE KEYS */;
/*!40000 ALTER TABLE `notebook` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notice`
--

DROP TABLE IF EXISTS `notice`;
CREATE TABLE `notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL,
  `protect` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notice`
--

LOCK TABLES `notice` WRITE;
/*!40000 ALTER TABLE `notice` DISABLE KEYS */;
INSERT INTO `notice` VALUES (1,'Приветствие при регистрации в приват','Добро пожаловать, %USERNAME%!\nТеперь Вы полноправный пользователь сайта, сохраните ваш пароль и логин в надежном месте, они пригодятся вам для входа на наш сайт.\nПеред посещением сайта рекомендуем вам ознакомиться с [url=%SITENAME%/rules]правилами сайта[/url], это поможет Вам избежать неприятных ситуаций.\nЖелаем приятно провести время.\nС уважением, администрация сайта!',NULL,1482942521,1);
/*!40000 ALTER TABLE `notice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `offers`
--

DROP TABLE IF EXISTS `offers`;
CREATE TABLE `offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `votes` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `text_reply` text COLLATE utf8mb4_unicode_ci,
  `user_reply` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_reply` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `votes` (`votes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `offers`
--

LOCK TABLES `offers` WRITE;
/*!40000 ALTER TABLE `offers` DISABLE KEYS */;
/*!40000 ALTER TABLE `offers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `online`
--

DROP TABLE IF EXISTS `online`;
CREATE TABLE `online` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `online`
--

LOCK TABLES `online` WRITE;
/*!40000 ALTER TABLE `online` DISABLE KEYS */;
/*!40000 ALTER TABLE `online` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `outbox`
--

DROP TABLE IF EXISTS `outbox`;
CREATE TABLE `outbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `outbox`
--

LOCK TABLES `outbox` WRITE;
/*!40000 ALTER TABLE `outbox` DISABLE KEYS */;
/*!40000 ALTER TABLE `outbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photo`
--

DROP TABLE IF EXISTS `photo`;
CREATE TABLE `photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `link` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `rating` mediumint(9) NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `comments` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `photo`
--

LOCK TABLES `photo` WRITE;
/*!40000 ALTER TABLE `photo` DISABLE KEYS */;
/*!40000 ALTER TABLE `photo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pollings`
--

DROP TABLE IF EXISTS `pollings`;
CREATE TABLE `pollings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `relate_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `relate_id` int(11) NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vote` tinyint(1) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relate_type` (`relate_type`,`relate_id`,`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `pollings`
--

LOCK TABLES `pollings` WRITE;
/*!40000 ALTER TABLE `pollings` DISABLE KEYS */;
/*!40000 ALTER TABLE `pollings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(5) unsigned NOT NULL,
  `topic_id` mediumint(8) unsigned NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `rating` smallint(6) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brow` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `edit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edit_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_time` (`topic_id`,`time`),
  KEY `user` (`user`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rating`
--

DROP TABLE IF EXISTS `rating`;
CREATE TABLE `rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `vote` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rating`
--

LOCK TABLES `rating` WRITE;
/*!40000 ALTER TABLE `rating` DISABLE KEYS */;
/*!40000 ALTER TABLE `rating` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `readblog`
--

DROP TABLE IF EXISTS `readblog`;
CREATE TABLE `readblog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blog` int(11) unsigned NOT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `readblog`
--

LOCK TABLES `readblog` WRITE;
/*!40000 ALTER TABLE `readblog` DISABLE KEYS */;
/*!40000 ALTER TABLE `readblog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rekuser`
--

DROP TABLE IF EXISTS `rekuser`;
CREATE TABLE `rekuser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rekuser`
--

LOCK TABLES `rekuser` WRITE;
/*!40000 ALTER TABLE `rekuser` DISABLE KEYS */;
/*!40000 ALTER TABLE `rekuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rules`
--

DROP TABLE IF EXISTS `rules`;
CREATE TABLE `rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rules`
--

LOCK TABLES `rules` WRITE;
/*!40000 ALTER TABLE `rules` DISABLE KEYS */;
INSERT INTO `rules` VALUES (1,'Незнание этих Правил не только не освобождает Вас от ответственности за их нарушение, но и само по себе является нарушением!\n\n[b]Общие правила для пользователей сайта %SITENAME%[/b]\n\n[b]1. Общие положения:[/b]\nа) Сайт посвящен вопросам призванным помочь wap/web-мастеру в разработке сайта, проекта или приложения для сайта.\nб) На сайте строго запрещены обсуждения связанные с взломом сайтов, e-mail адресов, ICQ-номеров (и прочего).\nв) Все материалы и сообщения, размещаемые на сайте, отражают исключительно мнения их авторов, администрация сайта не дает каких-либо гарантий, выраженных явно, или подразумеваемых, что они полны, полезны или правдивы.\n\n[b]2. Порядок поведения на сайте:[/b]\nа) Публикация ссылок на другие сайты допустима исключительно при условии, что страница, находящаяся по указанному адресу имеет непосредственное отношение к теме, приведена в качестве иллюстрации утверждения, высказанного автором сообщения.\nб) На сайте применяется пост-модерация. Сообщения, нарушающие настоящие правила, удаляются. Не следует воспринимать исчезновение своих сообщений следствием технического сбоя и помещать сообщения еще раз.\nв) Не одобряются попытки обратить внимание на низкий уровень знаний какого-либо участника сайта. Все когда-то не знали простых вещей.\nг) Вы обязаны соблюдать уважительное отношение к собеседнику, правильное (грамотное) и доходчивое изложение мыслей и фактов.\nд) Не обращайте внимания на маргиналов и прочих брутальных личностей. Не дразните и не подначивайте их - отсутствие внимания сразу сводит дискуссию на нет. Не стоит отвечать им той же монетой, даже если Вы считаете, что Вас оскорбили. Остальное - забота администрации сайта.\nе) Если Вы видите сообщение, нарушающее любое правило сайта, сообщите об этом администрации в \"Приват\", не стоит об этом кричать на форуме во всеуслышание.\n\n[b]3. При создании новых тем в форуме необходимо придерживаться следующих правил:[/b]\nа) Название темы должно быть информативным. Заголовки тем типа: \"Подскажите\", \"Знающие люди, зайдите!\", \"Есть вопрос\", \"Вопрос по php-коду\" и подобные, лишь демонстрируют Ваше неуважение к остальным посетителям сайта.\nб) Тема должна соответствовать теме раздела, в котором она находится. Не следует открывать тему в определенном разделе только потому, что Вы хотите получить быстрый ответ в более посещаемом разделе.\nв) Запрещается создание тем обращенных к конкретным участникам конференции (для этого существует \"Приват\").\nг) Запрещается продолжение обсуждений вопросов из тем, закрытых/удалённых администрацией. Перед тем как задать вопрос, настоятельно рекомендуем пользоваться поиском по форуму, наверняка Ваш вопрос уже обсуждался ранее.\n\n[b]4. Запрещается помещение сообщений, содержащих:[/b]\nа) Призывы к нарушению действующего законодательства, высказывания расистского характера, разжигание межнациональной розни, нагнетание обстановки на форуме и всего прочего, что попадает под действие УК РФ.\nб) Грубые, нецензурные выражения и оскорбления в любой форме (флейм) - сообщения, грубые по тону, содержащие \"наезды\" на личности.\nв) Бессмысленную или малосодержательную информацию, которая не несет смысловой нагрузки - пустую болтовню (флуд).\nг) Оффтоп, т.е. уход от основного обсуждения в рамках отдельной темы.\nд) Ложнyю инфоpмацию, клеветy, а также нечестные приемы ведения дискуссий в виде \"передергиваний\" высказываний собеседников.\nе) Откровенное рекламное содержание, в том числе с просьбой \"Посетите/оцените мой сайт\".\nж) Безосновательные утверждения, что \"это\" лучше, а \"это\" хуже, а также глупые советы типа \"выпей йаду\", \"полюби гугл\" и т.д.\nз) Чрезмерное количество грамматических ошибок и жаргонных слов.\nи) Обсуждение и выражение своих недовольств к действиям модераторов форума. Для этого существует \"Приват\".\n\nЗа выполнением требований правил следит администрация, а также специально назначенные модераторы. Администрация имеет право не предупреждать пользователей о принимаемых мерах.\n\n[b]5. Копирование или любое несанкционированное использование материалов сайта запрещено.[/b]\n\n[b][color=#ff0000]Внимание! Если пользователь пренебрегает данными Правилами, его аккуант блокируется на срок от 1 часа до %MAXBAN% дней.\nЕсли пользователь систематически игнорирует предупреждения администрации, то его учётная запись удаляется.[/color][/b]',1482942521);
/*!40000 ALTER TABLE `rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `setting`
--

DROP TABLE IF EXISTS `setting`;
CREATE TABLE `setting` (
  `name` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `setting`
--

LOCK TABLES `setting` WRITE;
/*!40000 ALTER TABLE `setting` DISABLE KEYS */;
INSERT INTO `setting` VALUES ('addbansend','1'),('addofferspoint','50'),('advertpoint','2000'),('allowextload','zip,rar,txt,jpg,jpeg,gif,png,mp3,mp4,3gp,wav,mmf,mid,midi,sis,jar,jad'),('allvotes','10'),('anonymity','1'),('avtorlist','10'),('banlist','10'),('blacklist','10'),('blogcomm','10'),('blogexprated','72'),('blogexpread','72'),('blogpost','10'),('blogvotepoint','50'),('boarddays','30'),('boardspost','5'),('bonusmoney','500'),('bookadds','1'),('bookpost','10'),('bookscores','0'),('buildversion','0'),('captcha_angle','20'),('captcha_distortion','1'),('captcha_interpolation','1'),('captcha_maxlength','5'),('captcha_offset','5'),('captcha_spaces','0'),('captcha_symbols','0123456789'),('chatpost','10'),('closedsite','0'),('contactlist','10'),('copy','© RotorCMS'),('copyfoto','1'),('description','Краткое описание вашего сайта'),('doslimit','0'),('downcomm','10'),('downlist','10'),('downupload','1'),('editforumpoint','500'),('editnickpoint','300'),('editratingpoint','150'),('editstatus','0'),('editstatusmoney','3000'),('editstatuspoint','1000'),('emails','admin@site.ru'),('errorlog','1'),('eventpoint','50'),('expiresloads','72'),('expiresmail','3'),('expiresrated','72'),('filesize','5242880'),('fileupfoto','3000'),('fileupload','33554432'),('floodstime','30'),('forumextload','zip,rar,txt,jpg,jpeg,gif,png,mp3,mp4,3gp,wav,pdf'),('forumloadpoints','150'),('forumloadsize','1048576'),('forumpost','10'),('forumtem','10'),('forumtextlength','3000'),('fotolist','5'),('guestsuser','Гость'),('guesttextlength','1000'),('home','http://rotor.ll'),('ignorlist','10'),('includenick','1'),('incount','5'),('invite','0'),('ipbanlist','10'),('keywords','Ключевые слова вашего сайта'),('lastnews','5'),('lastusers','100'),('lifelist','10'),('limitcontact','50'),('limitignore','50'),('limitmail','300'),('limitoutmail','100'),('listbanhist','10'),('listinvite','20'),('listtransfers','10'),('loginauthlist','10'),('loglist','10'),('logos','Сайт на движке RotorCMS'),('logotip','http://rotor.ll/assets/img/images/logo.png'),('maildriver','sendmail'),('mailhost','smtp.yandex.ru'),('mailpassword',''),('mailport','465'),('mailsecurity','ssl'),('mailusername',''),('maxbantime','43200'),('maxblogcomm','300'),('maxblogpost','50000'),('maxdowncomm','300'),('maxkommevents','500'),('maxkommnews','500'),('maxlogdat','100'),('maxpostbook','500'),('maxpostchat','500'),('maxpostgallery','100'),('maxpostoffers','300'),('moneyname','рублей,рубля,рубль'),('nickname','admin'),('nocheck','txt,dat,gif,jpg,jpeg,png,zip'),('onlinelist','10'),('onlines','1'),('openreg','1'),('performance','1'),('photoexprated','72'),('photogroup','10'),('postcommoffers','10'),('postevents','10'),('postgallery','10'),('postnews','10'),('postoffers','10'),('previewsize','150'),('privatpost','10'),('privatprotect','50'),('proxy',''),('registermoney','1000'),('regkeys','1'),('reglist','10'),('regmail','0'),('rekuseroptprice','100'),('rekuserpost','10'),('rekuserprice','1000'),('rekusershow','1'),('rekusertime','12'),('rekusertotal','10'),('resmiles','5'),('scorename','баллов,балла,балл'),('screensize','500'),('screenupload','2097152'),('screenupsize','5000'),('sendmail','0'),('sendmailpacket','20'),('sendmoneypoint','150'),('sendprivatmailday','3'),('session','1'),('showuser','10'),('smilelist','10'),('smilemaxsize','10240'),('smilemaxweight','100'),('smileminweight','16'),('spamlist','10'),('statusdef','Дух'),('statusname','Суперадмин,Админ,Старший модер,Модератор,Пользователь'),('themes','default'),('timeonline','600'),('timezone','Europe/Moscow'),('title','RotorCMS'),('touchthemes','0'),('userlist','10'),('usersearch','30'),('wallmaxpost','100'),('wallpost','10'),('webthemes','motor'),('ziplist','20');
/*!40000 ALTER TABLE `setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `smiles`
--

DROP TABLE IF EXISTS `smiles`;
CREATE TABLE `smiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cats` smallint(5) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cats` (`cats`),
  KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `smiles`
--

LOCK TABLES `smiles` WRITE;
/*!40000 ALTER TABLE `smiles` DISABLE KEYS */;
INSERT INTO `smiles` VALUES (1,1,').gif',':)'),(2,1,'(.gif',':('),(3,1,'4moks.gif',':4moks'),(4,1,'D.gif',':d'),(5,1,'E.gif',':E'),(6,1,'aaa.gif',':aaa'),(7,1,'agree.gif',':agree'),(8,1,'airkiss.gif',':airkiss'),(9,1,'atlet.gif',':atlet'),(10,1,'baby.gif',':baby'),(11,1,'bant.gif',':bant'),(12,1,'be.gif',':be'),(13,1,'blin.gif',':blin'),(14,1,'blum.gif',':blum'),(15,1,'bomba.gif',':bomba'),(16,1,'bounce.gif',':bounce'),(17,1,'bugaga.gif',':bugaga'),(18,1,'buhoj.gif',':buhoj'),(19,1,'bwink.gif',':bwink'),(20,1,'cold.gif',':cold'),(21,1,'cool.gif',':cool'),(22,1,'cry.gif',':cry'),(23,1,'ded.gif',':ded'),(24,1,'derisive.gif',':derisive'),(25,1,'drool.gif',':drool'),(26,1,'duma.gif',':duma'),(27,1,'exercise.gif',':exercise'),(28,1,'faq.gif',':faq'),(29,1,'fermer.gif',':fermer'),(30,1,'fingal.gif',':fingal'),(31,1,'flirt.gif',':flirt'),(32,1,'fuck.gif',':fuck'),(33,1,'girl_blum.gif',':girl_blum'),(34,1,'girl_bye.gif',':girl_bye'),(35,1,'girl_cry.gif',':girl_cry'),(36,1,'girl_hide.gif',':girl_hide'),(37,1,'girl_wink.gif',':girl_wink'),(38,1,'girls.gif',':girls'),(39,1,'happy.gif',':happy'),(40,1,'heart.gif',':heart'),(41,1,'hello.gif',':hello'),(42,1,'help.gif',':help'),(43,1,'help2.gif',':help2'),(44,1,'hi.gif',':hi'),(45,1,'infat.gif',':infat'),(46,1,'kiss.gif',':kiss'),(47,1,'kiss2.gif',':kiss2'),(48,1,'klass.gif',':klass'),(49,1,'krut.gif',':krut'),(50,1,'krutoy.gif',':krutoy'),(51,1,'ku.gif',':ku'),(52,1,'kuku.gif',':kuku'),(53,1,'kulak.gif',':kulak'),(54,1,'lamer.gif',':lamer'),(55,1,'love.gif',':love'),(56,1,'love2.gif',':love2'),(57,1,'mail.gif',':mail'),(58,1,'mister.gif',':mister'),(59,1,'money.gif',':money'),(60,1,'moped.gif',':moped'),(61,1,'musik.gif',':musik'),(62,1,'nea.gif',':nea'),(63,1,'net.gif',':net'),(64,1,'neznaju.gif',':neznaju'),(65,1,'ninja.gif',':ninja'),(66,1,'no.gif',':no'),(67,1,'nono.gif',':nono'),(68,1,'nozh.gif',':nozh'),(69,1,'nyam.gif',':nyam'),(70,1,'nyam2.gif',':icecream'),(71,1,'obana.gif',':obana'),(72,1,'ogogo.gif',':ogogo'),(73,1,'oops.gif',':oops'),(74,1,'opa.gif',':opa'),(75,1,'otstoy.gif',':otstoy'),(76,1,'oy.gif',':oy'),(77,1,'pirat.gif',':pirat'),(78,1,'pirat2.gif',':pirat2'),(79,1,'pistolet.gif',':pistolet'),(80,1,'pistolet2.gif',':pistolet2'),(81,1,'pizdec.gif',':shok3'),(82,1,'poisk.gif',':poisk'),(83,1,'proud.gif',':proud'),(84,1,'puls.gif',':puls'),(85,1,'queen.gif',':queen'),(86,1,'rap.gif',':rap'),(87,1,'read.gif',':read'),(88,1,'respekt.gif',':respekt'),(89,1,'rok.gif',':rok'),(90,1,'rok2.gif',':rok2'),(91,1,'senjor.gif',':senjor'),(92,1,'shok.gif',':shok'),(93,1,'shok2.gif',':shok2'),(94,1,'skull.gif',':skull'),(95,1,'smert.gif',':smert'),(96,1,'smoke.gif',':smoke'),(97,1,'spy.gif',':spy'),(98,1,'strela.gif',':strela'),(99,1,'svist.gif',':svist'),(100,1,'tiho.gif',':tiho'),(101,1,'vau.gif',':vau'),(102,1,'victory.gif',':victory'),(103,1,'visavi.gif',':visavi'),(104,1,'visavi2.gif',':visavi2'),(105,1,'vtopku.gif',':vtopku'),(106,1,'wackogirl.gif',':wackogirl'),(107,1,'xaxa.gif',':xaxa'),(108,1,'xmm.gif',':xmm'),(109,1,'yu.gif',':yu'),(110,1,'zlo.gif',':zlo'),(111,1,'ban.gif',':ban'),(112,1,'ban2.gif',':ban2'),(113,1,'banned.gif',':banned'),(114,1,'closed.gif',':closed'),(115,1,'closed2.gif',':closed2'),(116,1,'devil.gif',':devil'),(117,1,'flood.gif',':flood'),(118,1,'flood2.gif',':flood2'),(119,1,'huligan.gif',':huligan'),(120,1,'ment.gif',':ment'),(121,1,'ment2.gif',':ment2'),(122,1,'moder.gif',':moder'),(123,1,'nika.gif',':girlmoder'),(124,1,'offtop.gif',':offtop'),(125,1,'pravila.gif',':pravila'),(126,1,'zona.gif',':zona'),(127,1,'zub.gif',':zub'),(128,1,'crazy.gif',':crazy'),(129,1,'paratrooper.gif',':moder2'),(130,1,'bug.gif',':bug'),(131,1,'facepalm.gif',':facepalm'),(132,1,'wall.gif',':wall'),(133,1,'boss.gif',':boss');
/*!40000 ALTER TABLE `smiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `socials`
--

DROP TABLE IF EXISTS `socials`;
CREATE TABLE `socials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `network` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `socials`
--

LOCK TABLES `socials` WRITE;
/*!40000 ALTER TABLE `socials` DISABLE KEYS */;
/*!40000 ALTER TABLE `socials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `spam`
--

DROP TABLE IF EXISTS `spam`;
CREATE TABLE `spam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `relate` tinyint(1) NOT NULL,
  `idnum` int(11) unsigned NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  `addtime` int(11) NOT NULL,
  `link` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relate` (`relate`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `spam`
--

LOCK TABLES `spam` WRITE;
/*!40000 ALTER TABLE `spam` DISABLE KEYS */;
/*!40000 ALTER TABLE `spam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `status`
--

DROP TABLE IF EXISTS `status`;
CREATE TABLE `status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topoint` mediumint(8) unsigned NOT NULL,
  `point` mediumint(8) unsigned NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `point` (`point`),
  KEY `topoint` (`topoint`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `status`
--

LOCK TABLES `status` WRITE;
/*!40000 ALTER TABLE `status` DISABLE KEYS */;
INSERT INTO `status` VALUES (1,0,249,'Новичок',NULL),(2,250,499,'Местный',NULL),(3,500,999,'Продвинутый',NULL),(4,1000,1999,'Бывалый',NULL),(5,2000,3999,'Специалист','#FF8800'),(6,4000,5999,'Знаток','#DC143C'),(7,6000,7999,'Мастер','#0080FF'),(8,8000,9999,'Профессионал','#000000'),(9,10000,14999,'Гуру','#32608A'),(10,15000,100000,'Легенда','#ff0000');
/*!40000 ALTER TABLE `status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `topics`
--

DROP TABLE IF EXISTS `topics`;
CREATE TABLE `topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(5) unsigned NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `posts` int(11) unsigned NOT NULL DEFAULT '0',
  `last_user` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_time` int(11) NOT NULL DEFAULT '0',
  `moderators` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `forum_id` (`forum_id`),
  KEY `last_time` (`last_time`),
  KEY `locked` (`locked`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `topics`
--

LOCK TABLES `topics` WRITE;
/*!40000 ALTER TABLE `topics` DISABLE KEYS */;
/*!40000 ALTER TABLE `topics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
CREATE TABLE `transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `summ` int(11) unsigned NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `login` (`login`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trash`
--

DROP TABLE IF EXISTS `trash`;
CREATE TABLE `trash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  `del` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `trash`
--

LOCK TABLES `trash` WRITE;
/*!40000 ALTER TABLE `trash` DISABLE KEYS */;
/*!40000 ALTER TABLE `trash` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `joined` int(11) NOT NULL,
  `level` smallint(5) unsigned NOT NULL DEFAULT '107',
  `nickname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `info` text COLLATE utf8mb4_unicode_ci,
  `site` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icq` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `birthday` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visits` int(11) unsigned NOT NULL DEFAULT '0',
  `newprivat` smallint(5) unsigned NOT NULL DEFAULT '0',
  `newwall` smallint(5) unsigned NOT NULL DEFAULT '0',
  `allforum` int(11) unsigned NOT NULL DEFAULT '0',
  `allguest` int(11) unsigned NOT NULL DEFAULT '0',
  `allcomments` int(11) unsigned NOT NULL DEFAULT '0',
  `themes` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `point` int(11) unsigned NOT NULL DEFAULT '0',
  `money` int(11) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timeban` int(11) NOT NULL DEFAULT '0',
  `timelastban` int(11) NOT NULL DEFAULT '0',
  `reasonban` text COLLATE utf8mb4_unicode_ci,
  `loginsendban` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `totalban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `explainban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `status` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `picture` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` mediumint(9) NOT NULL DEFAULT '0',
  `posrating` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `negrating` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `keypasswd` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timepasswd` int(11) NOT NULL DEFAULT '0',
  `timelastlogin` int(11) NOT NULL DEFAULT '0',
  `timebonus` int(11) NOT NULL DEFAULT '0',
  `sendprivatmail` tinyint(1) NOT NULL DEFAULT '0',
  `confirmreg` tinyint(1) NOT NULL DEFAULT '0',
  `confirmregkey` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `secquest` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `secanswer` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timenickname` int(11) NOT NULL DEFAULT '0',
  `newchat` int(11) unsigned NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `apikey` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscribe` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sumcredit` int(11) unsigned NOT NULL DEFAULT '0',
  `timecredit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `login` (`login`),
  KEY `level` (`level`),
  KEY `nickname` (`nickname`),
  KEY `themes` (`themes`),
  KEY `point` (`point`),
  KEY `money` (`money`),
  KEY `rating` (`rating`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `visit`
--

DROP TABLE IF EXISTS `visit`;
CREATE TABLE `visit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `self` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` int(11) unsigned NOT NULL DEFAULT '0',
  `nowtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`),
  KEY `nowtime` (`nowtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `visit`
--

LOCK TABLES `visit` WRITE;
/*!40000 ALTER TABLE `visit` DISABLE KEYS */;
/*!40000 ALTER TABLE `visit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vote`
--

DROP TABLE IF EXISTS `vote`;
CREATE TABLE `vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `vote`
--

LOCK TABLES `vote` WRITE;
/*!40000 ALTER TABLE `vote` DISABLE KEYS */;
/*!40000 ALTER TABLE `vote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `voteanswer`
--

DROP TABLE IF EXISTS `voteanswer`;
CREATE TABLE `voteanswer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vote_id` smallint(5) unsigned NOT NULL,
  `option` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `voteanswer`
--

LOCK TABLES `voteanswer` WRITE;
/*!40000 ALTER TABLE `voteanswer` DISABLE KEYS */;
/*!40000 ALTER TABLE `voteanswer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `votepoll`
--

DROP TABLE IF EXISTS `votepoll`;
CREATE TABLE `votepoll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vote_id` smallint(5) unsigned NOT NULL,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `votepoll`
--

LOCK TABLES `votepoll` WRITE;
/*!40000 ALTER TABLE `votepoll` DISABLE KEYS */;
/*!40000 ALTER TABLE `votepoll` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wall`
--

DROP TABLE IF EXISTS `wall`;
CREATE TABLE `wall` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `wall`
--

LOCK TABLES `wall` WRITE;
/*!40000 ALTER TABLE `wall` DISABLE KEYS */;
/*!40000 ALTER TABLE `wall` ENABLE KEYS */;
UNLOCK TABLES;
