<?php
#-----------------------------------------------------#
#          ********* ROTORCMS *********               #
#              Made by  :  VANTUZ                     #
#               E-mail  :  visavi.net@mail.ru         #
#                 Site  :  http://pizdec.ru           #
#             WAP-Site  :  http://visavi.net          #
#                  ICQ  :  36-44-66                   #
#  Вы не имеете право вносить изменения в код скрипта #
#        для его дальнейшего распространения          #
#-----------------------------------------------------#
require_once ('../includes/start.php');
require_once ('../includes/functions.php');
require_once ('../includes/header.php');
include_once ('../themes/header.php');

$act = (isset($_GET['act'])) ? check($_GET['act']) : 'index';

show_title('site.png', 'Мои настройки');

if (is_user()) {
switch ($act):
############################################################################################
##                                    Главная страница                                    ##
############################################################################################
case 'index':

	echo '<img src="/images/img/document.gif" alt="image" /> ';
	echo '<a href="user.php?'.SID.'">Моя анкета</a> / ';
	echo '<a href="profile.php?'.SID.'">Мой профиль</a> / ';
	echo '<a href="account.php?'.SID.'">Мои данные</a> / ';
	echo '<b>Настройки</b><hr />';

	echo '<div class="form">';
	echo '<form method="post" action="setting.php?act=edit&amp;uid='.$_SESSION['token'].'&amp;'.SID.'">';

	echo 'Wap-тема по умолчанию:<br />';
	echo '<select name="themes">';
	echo '<option value="0">Автоматически</option>';
	$globthemes = glob(BASEDIR."themes/*", GLOB_ONLYDIR);
	foreach ($globthemes as $themes) {
		$selected = ($udata['users_themes'] == basename($themes)) ? ' selected="selected"' : '';
		echo '<option value="'.basename($themes).'"'.$selected.'>'.basename($themes).'</option>';
	}
	echo '</select><br />';

	echo 'Сообщений в гостевой:<br /><input name="postguest" value="'.$udata['users_postguest'].'" /><br />';
	echo 'Новостей на стр.:<br /><input name="postnews" value="'.$udata['users_postnews'].'" /><br />';
	echo 'Писем в привате на стр.:<br /><input name="postprivat" value="'.$udata['users_postprivat'].'" /><br />';
	echo 'Сообщений в форуме:<br /><input name="postforum" value="'.$udata['users_postforum'].'" /><br />';
	echo 'Тем в форуме:<br /><input name="themesforum" value="'.$udata['users_themesforum'].'" /><br />';
	echo 'Объявлений на стр.:<br /><input name="postboard" value="'.$udata['users_postboard'].'" /><br />';

	echo 'Быстрый переход:<br /><select name="navigation">';
	$arrnav = array('Выключить', 'Обычный список', 'Список без кнопки');

	echo '<option value="'.$udata['users_navigation'].'">'.$arrnav[$udata['users_navigation']].'</option>';
	foreach($arrnav as $k => $v) {
		if ($k != $udata['users_navigation']) {
			echo '<option value="'.$k.'">'.$v.'</option>';
		}
	}
	echo '</select><br />';

	$arrtimezone = range(-12, 12);

	echo 'Временной сдвиг:<br />';
	echo '<select name="timezone">';
	foreach($arrtimezone as $zone) {
		$selected = ($udata['users_timezone'] == $zone) ? ' selected="selected"' : '';
		echo '<option value="'.$zone.'"'.$selected.'>'.$zone.'</option>';
	}
	echo '</select> - '.date_fixed(SITETIME, 'H:i').'<br />';

	$checked = ($udata['users_javascript'] == 1) ? ' checked="checked"' : '';
	echo '<input name="javascript" id="javascript" type="checkbox" value="1"'.$checked.' title="Разрешает использование скриптов" /> <label for="javascript">Вкл. javascript</label><br />';

	$checked = ($udata['users_ipbinding'] == 1) ? ' checked="checked"' : '';
	echo '<input name="ipbinding" id="ipbinding" type="checkbox" value="1"'.$checked.' title="IP привязывается к сессии, улучшается надежность" /> <label for="ipbinding">Привязка к IP</label><br />';

	$checked = ($udata['users_privacy'] == 1) ? ' checked="checked"' : '';
	echo '<input name="privacy" id="privacy" type="checkbox" value="1"'.$checked.' title="Писать в приват и на стену смогут только пользователи из контактов" /> <label for="privacy">Режим приватности</label><br />';

	echo '<input value="Изменить" type="submit" /></form></div><br />';

	echo '* Значение всех полей (max.50)<br /><br />';
break;

############################################################################################
##                                       Изменение                                        ##
############################################################################################
case 'edit':

	$uid = check($_GET['uid']);
	$themes = check($_POST['themes']);
	$postguest = abs(intval($_POST['postguest']));
	$postnews = abs(intval($_POST['postnews']));
	$postprivat = abs(intval($_POST['postprivat']));
	$postforum = abs(intval($_POST['postforum']));
	$themesforum = abs(intval($_POST['themesforum']));
	$postboard = abs(intval($_POST['postboard']));
	$navigation = abs(intval($_POST['navigation']));
	$timezone = check($_POST['timezone']);
	$javascript = (empty($_POST['javascript'])) ? 0 : 1;
	$ipbinding = (empty($_POST['ipbinding'])) ? 0 : 1;
	$privacy = (empty($_POST['privacy'])) ? 0 : 1;

	$validation = new Validation;

	$validation -> addRule('equal', array($uid, $_SESSION['token']), 'Неверный идентификатор сессии, повторите действие!')
		-> addRule('regex', array($themes, '|^[a-z0-9_\-]+$|i'), 'Недопустимое название темы!', true)
		-> addRule('numeric', $postguest, 'Количество сообщений в гостевой. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $postnews, 'Количество новостей на страницу. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $postprivat, 'Количество приватных сообщений. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $postforum, 'Количество сообщения в форуме. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $themesforum, 'Количество тем в форуме. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $postboard, 'Количество объявлений на страницу. (Допустимое значение от 3 до 50)!', true, 3, 50)
		-> addRule('numeric', $navigation, 'Недопустимое значение данных быстрого перехода!', true, 0, 2)
		-> addRule('regex', array($timezone, '|^[\-\+]{0,1}[0-9]{1,2}$|'), 'Недопустимое значение временного сдвига. (Допустимый диапазон -12 — +12 часов)!', true);

	if ($validation->run()) {
		if (file_exists(BASEDIR."themes/$themes/index.php") || $themes==0) {

		DB::run() -> query("UPDATE `users` SET `users_themes`=?, `users_postguest`=?, `users_postnews`=?, `users_postprivat`=?, `users_postforum`=?, `users_themesforum`=?, `users_postboard`=?, `users_timezone`=?, `users_javascript`=?, `users_ipbinding`=?, `users_navigation`=?, `users_privacy`=? WHERE users_login=?", array($themes, $postguest, $postnews, $postprivat, $postforum, $themesforum, $postboard, $timezone, $javascript, $ipbinding, $navigation, $privacy, $log));

		if (!empty($_SESSION['my_themes'])) {
			unset($_SESSION['my_themes']);
		}

		notice('Настройки успешно изменены!');
		redirect("setting.php?".SID);

		} else {
			show_error('Ошибка! Данный скин не установлен на сайте!');
		}
	} else {
		show_error($validation->errors);
	}

	echo '<img src="/images/img/back.gif" alt="image" /> <a href="setting.php?'.SID.'">Вернуться</a><br />';
break;

default:
	redirect("setting.php?".SID);
endswitch;
} else {
	show_login('Вы не авторизованы, чтобы изменять настройки, необходимо');
}

include_once ('../themes/footer.php');
?>
