<?php
header("Content-type:text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html>
<head>
    <title>
        @section('title')
            {{ App::setting('title') }}
        @show
    </title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
    <link rel="image_src" href="/assets/img/images/icon.png" />
    @section('styles')
        <?= include_style() ?>
    @show
    @stack('styles')
    <link rel="stylesheet" href="/themes/rdesign/css/style.css" type="text/css" />
    <link rel="alternate" href="/news/rss" title="RSS News" type="application/rss+xml" />
   

    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <meta name="description" content="@yield('description', App::setting('description'))">
    <meta name="keywords" content="@yield('keywords', App::setting('keywords'))">
    <meta name="generator" content="RotorCMS {{ env('VERSION') }}" />
</head>
<body>
<div class="wrapp">
<div class="header">
    <!-- <a href="/"><span class="logotype">{{ App::setting('title') }}</span></a><br /> -->
   <div class="logos">
       <a href="/">{{ App::setting('title') }}</a>
       <span>{{ App::setting('logos') }}</span>
    <!--{{ App::setting('logos') }}-->
    </div>
    <div class="menus">
        <ul>
            <li><a href="/">Главная</a></li>
            <li><a href="/book">Гостевая</a></li>
            <li><a href="/forum">Форум</a></li>
            <li><a href="/load">Загрузки</a></li>
            <li><a href="/blog">Блоги</a></li>
            <li><a href="/gallery">Галерея</a></li>
        </ul>
    </div>
</div>
    <div class="reg"><?php render('includes/menu'); ?></div>
 
    </div>
    <div class="contwrapp">
    <div class="sidebar">
        <div class="dom"></div>
        <div class="recent">
        <?php
            if (is_user()) {
                include (APP.'/views/main/recent.blade.php');
            } else {
                include (APP.'/views/main/recent.blade.php');
            }
            ?>
        </div>
    </div>

<div class="content">
<?= render('includes/note'); /*Временно пока шаблоны подключаются напрямую*/ ?>
