<?php
header("Content-type:text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <title>@yield('title') - {{ setting('title') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="image_src" href="/assets/img/images/icon.png">
     @yield('styles')

    @stack('styles')
    <link rel="stylesheet" href="/themes/ndiz/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/themes/ndiz/css/style.css">
    <link rel="alternate" href="/news/rss" title="RSS News" type="application/rss+xml">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="description" content="@yield('description', setting('description'))">
    <meta name="keywords" content="@yield('keywords', setting('keywords'))">
    <meta name="generator" content="Rotor {{ VERSION }}">
</head>
<body>

<div class="header">
   <div class="logo">
    {{--<a href="/"><span class="logotype">{{ setting('title') }}</span></a>--}}
    <a href="/"><img src="{{ setting('logotip') }}" alt="{{ setting('title') }}"></a>
    <span>{{ setting('logos') }}</span>
    </div>
    
    <div class="menu">@yield('menu')</div>
</div>




<div class="content">
    <div class="main">
        @yield('advertTop')
        @yield('advertUser')
        @yield('note')
        @yield('flash')
        @yield('layout')
        @yield('advertBottom')
    </div>
    
    <div class="sidebar">
            <h1>Новое на сайте</h1>
   <div class="b"><div class="imges"><img src="/themes/ndiz/img/sticker.png" alt=""></div> <b>Последние темы</b></div>
   
   <div class="recent">{{ recentTopics() }}</div>


<div class="b"><div class="imges"><img src="/themes/ndiz/img/sticker.png" alt=""></div><b>Последние файлы</b></div>
<div class="recent">{{ recentFiles() }}</div>

<div class="b"><div class="imges"><img src="/themes/ndiz/img/sticker.png" alt=""></div> <b>Последние статьи</b></div>
<div class="recent">{{ recentBlogs() }}</div>

<div class="b"><div class="imges"><img src="/themes/ndiz/img/sticker.png" alt=""></div><b>Последние фотографии</b></div>
<div class="recent">{{  recentPhotos() }}</div>
    </div>
</div>


<div class="footer">
    <div class="copy"><a href="/">{{ setting('copy') }}</a></div>
    <div class="online"> @yield('online')</div>
    <div class="counter"> @yield('counter')</div>
    <div class="perf">@yield('performance')</div>
    
</div>


<script src="/themes/ndiz/js/jquery-3.3.1.min.js"></script>
<script src="/themes/ndiz/js/top.js"></script>
@yield('scripts')

@stack('scripts')

</body>
</html>
