@extends('layout')

@section('title')
    Панель управления
@stop

@section('content')

    <h1>Панель управления</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Панель</li>
        </ol>
    </nav>

   <div class="pages-nav">
   <ul>
    <a class="rversion" href="/admin/upgrade"><i class="fa fa-key fa-lg"></i> Версия {{ VERSION }}.{{ setting('buildversion') }}</a>

    <div class="bord"><i class="fa fa-cog fa-lg text-muted"></i> Редактор</div>
     <li><a href="/admin/chats">Админ-чат <span>({{ statsChat() }})</span></a></li>
     <li><a href="/admin/guestbooks">Гостевая книга <span>({{ statsGuestbook() }})</span></a></li>
     <li> <a href="/admin/forums">Форум <span>({{ statsForum() }})</span></a></li>
     <li><a href="/admin/photos">Галерея <span>({{ statsPhotos() }})</span></a></li>
     <li><a href="/admin/blogs">Блоги <span>({{ statsBlog() }})</span></a></li> 
     <li><a href="/admin/reklama">Пользовательская реклама</a></li>

    @if (isAdmin('moder'))
        <div class="bord"><i class="fa fa-cog fa-lg text-muted"></i> Модератор</div>
    <li><a href="/admin/bans">Бан / Разбан</a></li>
    <li><a href="/admin/banlists">Список забаненых <span>({{ statsBanned() }})</span></a></li>
    <li><a href="/admin/spam">Список жалоб <span>({{ statsSpam() }})</span></a></li>
    <li> <a href="/admin/administrators">Список старших <span>({{ statsAdmins() }})</span></a></li>
    <li><a href="/admin/reglists">Список ожидающих <span>({{ statsRegList() }})</span></a></li>
    <li><a href="/admin/votes">Голосования <span>({{ statVotes() }})</span></a></li> 
    <li><a href="/admin/antimat">Управление антиматом <span>({{ statsAntimat() }})</span></a></li> 
    <li><a href="/admin/banhists">История банов <span>({{ statsBanHist() }})</span></a></li> 
    <li><a href="/admin/invitations">Приглашения <span>({{ statsInvite() }})</span></a></li>
    <li><a href="/admin/transfers">Денежные операции</a></li>
    @endif

    @if (isAdmin('admin'))
        <div class="bord"><i class="fa fa-cog fa-lg text-muted"></i> Администратор</div>
        <li><a href="/admin/rules">Правила сайта</a></li>
        <li><a href="/admin/news">Новости <span>({{ statsNews() }})</span></a></li> 
        <li><a href="/admin/ipbans">IP-бан панель <span>({{ statsIpBanned() }})</span></a></li> 
        <li><a href="/admin/phpinfo">PHP-информация <span>({{ parseVersion(PHP_VERSION) }})</span></a></li>
        <li><a href="/admin/loads">Загруз-центр <span> ({{ statsLoad() }})</span></a></li>
        <li><a href="/admin/downs/new">Новые публикации <span>({{ statsNewLoad() }})</span></a></li>
        <li><a href="/admin/errors">Ошибки / Автобаны</a></li>
        <li> <a href="/admin/blacklists">Черный список <span>({{ statsBlacklist() }})</span></a></li> 
        <li><a href="/admin/offers">Предложения / Проблемы <span>({{ statsOffers() }})</span></a></li> 
        <li> <a href="/admin/smiles">Управление смайлами <span>({{ statsSmiles() }})</span></a></li>
        <li><a href="/admin/status">Статусы пользователей</a></li>
    @endif

    @if (isAdmin('boss'))
        <div class="bord"><i class="fa fa-cog fa-lg text-muted"></i>Босс</div>
         <li><a href="/admin/settings">Настройки сайта</a></li>
         <li><a href="/admin/users">Пользователи <span>({{ statsUsers() }})</span></a></li>
         <li><a href="/admin/caches">Очистка кэша</a></li>
         <li><a href="/admin/backups">Backup-панель</a></li>
         <li><a href="/admin/checkers">Сканирование сайта <span>({{ statsChecker() }})</span></a></li> 
         <li><a href="/admin/delivery">Приват-рассылка</a></li>
         <li><a href="/admin/logs">Логи посещений</a></li>
         <li><a href="/admin/notices">Шаблоны писем</a></li>
         <li><a href="/admin/files">Редактирование файлов</a></li>
         <li><a href="/admin/delusers">Чистка пользователей</a></li>
    @endif

    @if (! $existBoss)
        <div class="bord"><b><span style="color:#ff0000">Внимание!!! Отсутствует профиль суперадмина</span></b><br>
        В базе данных не найден пользователь с правами boss</div>
    @endif

    @if (file_exists(HOME.'/install'))
        <div class="bord"><b><span style="color:#ff0000">Внимание!!! Необходимо удалить директорию install</span></b><br>
        Наличие этой директории может нарушить безопасность сайта. Удалите ее прямо сейчас!</div>
        </ul>
        </div>
    @endif
@stop
