@extends('layout')

@section('title')
    Блоги - Список статей {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список статей {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Список статей {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blogs-main-articles">
            <div class="main-articles-nav">
                <a href="/articles/{{ $data->id }}">{{ $data->title }} <span>{!! formatNum($data->rating) !!}</span></a> 
            </div>

            <div class="main-articles-cn">
              <span> Автор: {!! profile($data->user) !!} <br> ({{ dateFixed($data->created_at) }})</span>
              <span class="right">
                  <a href="/articles/comments/{{ $data->id }}"><i class="fa fa-comment"> {{ $data->count_comments }}</i></a> 
              </span>
                
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}

        Всего статей: <b>{{ $page->total }}</b><br>
    @else
        {!! showError('Статей еще нет!') !!}
    @endif
@stop
