@extends('layout')

@section('title')
    Блоги - Список комментариев {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список комментариев {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Список комментариев {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="blogs-mainnew-comments">
                <div class="blogs-mainnew-nav">
                    <a href="/articles/comment/{{ $data->relate_id}}/{{ $data->id}}"><i class="fa fa-comment"></i>{{ $data->title }} <span>({{ $data->count_comments }})</span>
                    </a>

                        @if (isAdmin())
                            <a class="del" href="#" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ App\Models\Blog::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times text-muted"></i></a>
                        @endif
                </div>

                <div class="blogs-mainnew-content">
                    {!! bbCode($data->text) !!}
                    </div>

                   <div class="blogs-mainnew-end">
                   <span>Написал: {!! profile($data->user) !!} <br> ({{ dateFixed($data->created_at) }})</span>
                    <span> @if (isAdmin())
                        ({{ $data->brow }}, {{ $data->ip }})</span>
                    @endif
                </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Комментарии не найдены!') !!}
    @endif
@stop
