@extends('layout')

@section('title')
    Авторы
@stop

@section('content')

    <h1>Авторы</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Авторы</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="blogs-authors">
            <a href="/blogs/active/articles?user={{ $data->login }}"><i class="fa fa-pencil-alt"></i>{{ $data->login }} <span>({{ $data->cnt }} cтатей / {{ $data->count_comments }} комм.)</span></a> 
            </div>
        @endforeach

        {!! pagination($page) !!}

        Всего пользователей: <b>{{ $page->total }}</b><br><br>
    @else
        {!! showError('Статей еще нет!') !!}
    @endif
@stop
