@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')

    @if (getUser() && ! $category->closed)
        <div class="float-right">
            <a class="btn btn-success" href="/blogs/create?cid={{ $category->id }}">Добавить статью</a>
        </div><br>
    @endif

    <h1>{{ $category->name }} <small>(Статей: {{ $category->count_blogs }})</small></h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/blogs/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin())
                <li class="breadcrumb-item"><a href="/admin/blogs/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
            <div class="blogs-article-nav">
               <ul>
               <li>
                <a href="/articles/{{ $data->id }}">{{ $data->title }} <span>{!! formatNum($data->rating) !!}</span></a> 
                </li>
                </ul>
            </div>
            <div class="blogs-article-comment">
               <span>
               Автор: {!! profile($data->user) !!} <br> ({{ dateFixed($data->created_at) }})</span>
               <span><i class="fa fa-eye" aria-hidden="true">{{ $data->visits }}</i> </span>
               <span>
               <a href="/articles/comments/{{ $data->id }}"><i class="fa fa-comment" aria-hidden="true"> {{ $data->count_comments }}</i></a>
                <!--<a href="/articles/end/{{ $data->id }}"><i class="fa fa-chevron-circle-right" aria-hidden="true"></i></a>-->
                
                </span>
                
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Статей еще нет, будь первым!') !!}
    @endif

   <div class="blogs-bottom">
    <a href="/blogs/top">Топ статей</a>
    <a href="/blogs/tags">Облако тегов</a>
    <a href="/blogs/search">Поиск</a>
    <a href="/blogs/authors">Авторы</a>
    </div>
@stop
