@extends('layout')

@section('title')
    Блоги - Новые статьи (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые статьи</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые статьи</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="new-articles">
            <div class="new-articles-nav">
                <a href="/articles/{{ $data->id }}">{{ $data->title }} <span>{!! formatNum($data->rating) !!}</span></a> 
            </div>

            <div class="new-articles-cn">
               <span>Категория: <a href="/blogs/{{ $data->category_id }}">{{ $data->category->name }}</a><br>
               Добавил: {!! profile($data->user) !!}  
               </span>
                <span class="right">
                ({{  dateFixed($data->created_at) }}) <br>
                <i class="fa fa-eye" aria-hidden="true"> {{ $data->visits }}</i></span>
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
@stop
