@extends('layout')

@section('title')
    Блоги - Новые комментарии (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые комментарии</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые комментарии</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="blogs-mainnew-comments">
                <div class="blogs-mainnew-nav">
                    <a href="/articles/comments/{{ $data->relate_id }}"> <i class="fa fa-comment"></i>{{ $data->title }} <span>({{ $data->count_comments }})</span></a> 

                    <div class="float-right">
                        @if (isAdmin())
                            <a class="del" href="#" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ App\Models\Blog::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times text-muted"></i></a>
                        @endif
                    </div>
                </div>

                <div class="blogs-mainnew-content">
                    {!! bbCode($data->text) !!}
                    </div>
                  <div class="blogs-mainnew-end">
                   <span>Написал: {!! profile($data->user) !!} <br> ({{ dateFixed($data->created_at) }})</span>
                    <span> @if (isAdmin())
                        ({{ $data->brow }}, {{ $data->ip }})</span>
                   
                    @endif
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Комментарии не найдены!') !!}
    @endif
@stop
