@extends('layout')

@section('title')
    Форум - Список сообщений {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список сообщений {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Список сообщений {{ $user->login }}</li>
        </ol>
    </nav>

    @foreach ($posts as $data)
        <div class="main-active-post">
            <div class="main-active-link">
               <a class="m-active-link" href="/topics/{{ $data->topic_id }}/{{ $data->id }}">{{ $data->topic->title }}</a>

                @if (isAdmin())
                    <a class="m-del-link" href="#" class="float-right" onclick="return deletePost(this)" data-tid="{{ $data->id }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times"></i></a>
                @endif
            </div>
            
               <div class="main-active-text">
                {!! bbCode($data->text) !!}
                </div>

              <div class="main-active-bottom">
                  <span> Написал: {{ $data->user->login }}
                ({{ dateFixed($data->created_at) }})</span>
                  <span> @if (isAdmin())
                    ({{ $data->brow }}, {{ $data->ip }})
                @endif</span>
              </div>
        </div>
    @endforeach

    {!! pagination($page) !!}
@stop
