@extends('layout')

@section('title')
    Форум - Список тем {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список тем {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Список тем {{ $user->login }}</li>
        </ol>
    </nav>

    @foreach ($topics as $data)
       <div class="main-new-themes">
        <div class="main-new-nav">
            <a href="/topics/{{ $data->id }}">{{ $data->title }} <span>({{ $data->count_posts }})</span></a>
        </div>

           <div class="main-new-centr">
           <span>Форум: <a href="/forums/{{ $data->forum->id }}">{{ $data->forum->title }}</a></span>
           <span> {!! $data->pagination() !!}</span>
          </div>
          
            <div class="main-new-bottom">
                <span>Автор: {{ $data->user->login }}</span>
                <span>Посл.: {{ $data->lastPost->user->login }} ({{ dateFixed($data->lastPost->created_at) }})</span>
            </div>
           
      </div>
    @endforeach

    {!! pagination($page) !!}
@stop
