@extends('layout')

@section('title')
    Форум
@stop

@section('content')

    <h1>Форум {{ setting('title') }}</h1>

    @include('advert/_forum')

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Форум</li>
        </ol>
    </nav>

   <div class="top-link">
    @if (getUser())
        Мои: <a href="/forums/active/topics">темы</a> <a href="/forums/active/posts">сообщения</a> <a href="/forums/bookmarks">закладки</a> 
    @endif

    Новые: <a href="/topics">темы</a>
    <a href="/posts">сообщения</a>
   </div>

    @if ($forums->isNotEmpty())
        @foreach ($forums as $forum)
            <div class="forum-nav">
                <ul>
                <li>
                <a href="/forums/{{ $forum->id }}"> <img class="fimg" src="/themes/ndiz/img/folder.png" alt="folder"> {{ $forum->title }} <span>({{ $forum->count_topics }}/{{ $forum->count_posts }})</span></a>
                </li>
               
</ul>
                
                @if ($forum->description)
                   <div class="forum-nav-descript">
                    {{ $forum->description }}
                    </div>
                @endif
              
            </div>

            <div class="description">
                @if ($forum->children->isNotEmpty())
                    @foreach ($forum->children as $child)
                        <i class="fa fa-copy text-muted"></i> <b><a href="/forums/{{ $child->id }}">{{ $child->title }}</a></b>
                        ({{ $child->count_topics }}/{{ $child->count_posts }})<br/>
                    @endforeach
                @endif

                @if ($forum->lastTopic->lastPost->id)
                    <a href="/topics/end/{{ $forum->lastTopic->id }}"> Тема: {{ $forum->lastTopic->title }}
                    <span>Сообщение: {{ $forum->lastTopic->lastPost->user->login }} ({{ dateFixed($forum->lastTopic->lastPost->created_at) }})</span>
                    </a>
                @else
                    Темы еще не созданы!
                @endif
</div>
        @endforeach
    @else
        {!! showError('Разделы форума еще не созданы!') !!}
        
    @endif

   <div class="bottom-link">
    <a href="/rules">Правила</a> <a href="/forums/top/themes">Топ тем</a> <a href="/forums/top/posts">Топ постов</a> <a href="/forums/search">Поиск</a> <a href="/forums/rss">RSS</a>
    </div>
@stop
