@extends('layout')

@section('title')
    Форум - Новые сообщения (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые сообщения</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Новые сообщения</li>
        </ol>
    </nav>

    @foreach ($posts as $data)
       <div class="new-post">
        <div class="new-post-link">
            <a href="/topics/{{ $data->topic_id }}/{{ $data->id }}">{{ $data->topic->title }} 
            <span>({{ $data->topic->count_posts }})</span></a>

        </div>
            <div class="new-post-text">
            {!! bbCode($data->text) !!}
            </div>
            
            <div class="new-post-bottom">
            
            <span> Написал: {{ $data->user->login }} {!! userOnline($data->user) !!} ({{ dateFixed($data->created_at) }})</span>
            <span>
               @if (isAdmin())
                ({{ $data->brow }}, {{ $data->ip }})
            @endif
            </span>

            </div>
        </div>
    @endforeach

    {!! pagination($page) !!}
@stop
