@extends('layout')

@section('title')
    Форум - Новые темы (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые темы</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Новые темы</li>
        </ol>
    </nav>

    @foreach ($topics as $data)
       <div class="new-themes">
        <div class="new-block">
            <a href="/topics/{{ $data->id }}">{{ $data->title }} <span>({{ $data->count_posts }})</span></a> 
        </div>

           <div class="podforum">
           <span> Форум: <a href="/forums/{{  $data->forum->id }}">{{  $data->forum->title }}</a></span>
           <span> {!! $data->pagination() !!}</span>
            </div>
            <div class="end-auth">
            <span> Автор: {{ $data->user->login }}</span>
            <span>Посл.: {{ $data->lastPost->user->login }} ({{ dateFixed($data->created_at) }})</span>
        
            </div>
       </div>
    @endforeach

    {!! pagination($page) !!}
@stop
