@extends('layout')

@section('title')
    Топ популярных тем
@stop

@section('content')

    <h1>Топ популярных тем</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных тем</li>
        </ol>
    </nav>

    @if ($topics->isNotEmpty())
        @foreach ($topics as $data)
            <div class="top-themes">
                <div class="themes">
                <a href="/topics/{{ $data->id }}">{{ $data->title }} <span>({{ $data->count_posts }})</span>
                </a> 
                </div>
            <div class="themes-bottom">
               <div class="text-description">
                <span>Автор: {{ $data->user->login }}</span>
                <span>
                Сообщение: {{ $data->lastPost->user->login }} ({{ dateFixed($data->lastPost->created_at) }})</span>
                <span>{!! $data->pagination() !!}</span>
                </div>
            </div>
             </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Созданных тем еще нет!') !!}
    @endif
@stop
