@extends('layout')

@section('title')
    Загрузки
@stop

@section('content')

    <h1>Загрузки</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Загрузки</li>
        </ol>
    </nav>

   <div class="loads-top">
       <span>
    @if (getUser())
       
       Мои: <a href="/downs/active/files">файлы</a>
        <a href="/downs/active/comments">комментарии</a>
       
    @endif
 </span>
   <span>
       Новые: <a href="/downs">файлы</a>
    <a href="/downs/comments">комментарии</a>
    
    </span>
</div>
    @foreach ($categories as $category)
        <div class="loads-nav">
           <ul>
           <li>
            <a href="/loads/{{ $category->id }}"> <img class="loads-img" src="/themes/ndiz/img/folder.png" alt="folder">{{ $category->name }}
            <span> @if ($category->new)
                ({{ $category->count_downs }}/+{{ $category->new->count_downs }})
            @else
                ({{ $category->count_downs }})
            @endif</span></a>
            </li>
            </ul>
        </div>

        <div>
            @if ($category->children->isNotEmpty())
                @foreach ($category->children as $child)
                    <i class="fa fa-angle-right"></i> <b><a href="/loads/{{ $child->id }}">{{ $child['name'] }}</a></b>
                    @if ($child->new)
                        ({{ $child->count_downs }}/<span style="color:#ff0000">+{{ $child->new->count_downs }}</span>)<br>
                    @else
                        ({{ $child->count_downs }})<br>
                    @endif
                @endforeach
            @endif
        </div>
    @endforeach

   <div class="loads-bottom">
    <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    <a href="/loads/rss">RSS</a>
    </div>
@stop
