@extends('layout')

@section('title')
    Альбомы пользователей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Альбомы пользователей</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Альбомы пользователей</li>
        </ol>
    </nav>

    @if ($albums->isNotEmpty())
        @foreach ($albums as $data)

           <div class="photos-content">
           <div class="photos-nav">
            <a href="/photos/albums/{{ $data->login }}"><i class="fa fa-image"></i>{{ $data->login }}
            <span>({{ $data->cnt }} фото / {{ $data->count_comments }} комм.)</span></a>
            </div>
</div>

        @endforeach

        {!! pagination($page) !!}

        Всего альбомов: <b>{{ $page->total }}</b><br><br>
    @else
        {!! showError('Альбомов еще нет!') !!}
    @endif
@stop
