@extends('layout')

@section('title')
    Альбом {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Альбом {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Альбом {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($photos->isNotEmpty())

        @foreach ($photos as $photo)
           <div class="photos-content">
            <div class="photos-nav">
                <a href="/photos/{{ $photo->id }}"><i class="fa fa-image"></i>{{ $photo->title }}</a>

               <div class="photos-nav-edit">
                @if ($moder)
                    <a href="/photos/edit/{{ $photo->id }}?page={{ $page->current }}">Редактировать</a> 
                    <a href="/photos/delete/{{ $photo->id }}?page={{ $page->current }}&amp;token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
                @endif
                </div>
            </div>
            <div>
                <?php $countFiles = $photo->files->count() ?>
                <div class="photos-photos">
                <div id="myCarousel{{ $loop->iteration }}" class="carousel slide w-75" data-ride="carousel">
                    @if ($countFiles > 1)
                        <ol class="carousel-indicators">
                            @for ($i = 0; $i < $countFiles; $i++)
                                <li data-target="#myCarousel{{ $loop->iteration }}" data-slide-to="{{ $i }}"{{ empty($i) ? ' class="active"' : '' }}></li>
                            @endfor
                        </ol>
                    @endif

                    <div class="carousel-inner">
                        @foreach ($photo->files as $file)
                            <div class="carousel-item{{ $loop->first ? ' active' : '' }}">
                                {!! resizeImage('/uploads/photos/' . $file->hash, ['alt' => $photo->title, 'class' => 'd-block w-100']) !!}
                            </div>
                        @endforeach
                    </div>

                    @if ($countFiles > 1)
                        <a class="carousel-control-prev" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    @endif
                </div>
                </div>
</div>

               <div class="photos-text">
                @if ($photo->text)
                   {!! bbCode($photo->text) !!}
                @endif
                </div>

               <div class="photos-bottom">
               <span>Добавлено: {!! profile($photo->user) !!} ({{ dateFixed($photo->created_at) }})</span>
                <span><a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment" aria-hidden="true"></i></a> <span class="comme">({{ $photo->count_comments }})</span></span>
                
                </div>
            </div>
        @endforeach

        {!! pagination($page) !!}

        Всего фотографий: <b>{{ $page->total }}</b><br><br>
    @else
        {!! showError('Фотографий в альбоме еще нет!') !!}
    @endif
@stop
