@extends('layout')

@section('title')
    Список всех комментариев {{ $user->login }} (Стр. {{ $page->current}})
@stop

@section('content')

    <h1>Список всех комментариев {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Список всех комментариев {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
            <div class="photos-comment">
                <div class="photos-comment-nav">
                   <a class="photos-link" href="/photos/comment/{{ $data->relate_id }}/{{ $data->id }}">
                     <i class="fa fa-comment"></i>{{ $data->title }}</a>

                    @if (isAdmin())
                        <a class="del" href="#" class="float-right" onclick="return deleteComment(this)" data-rid="{{ $data->relate_id }}" data-id="{{ $data->id }}" data-type="{{ Photo::class }}" data-token="{{ $_SESSION['token'] }}" data-toggle="tooltip" title="Удалить"><i class="fa fa-times"></i></a>
                    @endif
                </div>
                  
                   <div class="photos-comment-text">
                    {!! bbCode($data->text) !!}
                </div>
                  
                <div class="photos-comment-bottom">
                   <span>Написал: {!! profile($data->user) !!} ({{ dateFixed($data->created_at) }})</span>
                    
                  <span>@if (isAdmin())
                        ({{ $data->brow }}, {{ $data->ip }})
                    @endif
                    </span>
                </div>
            </div>
        @endforeach

        {!! pagination($page) !!}

    @else
        {!! showError('Комментариев еще нет!') !!}
    @endif
@stop
