@extends('layout')

@section('title')
    {{ $photo->title }}
@stop

@section('content')

    <h1>{{ $photo->title }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item"><a href="/photos/albums/{{ $photo->user->login }}">Альбом</a></li>
            <li class="breadcrumb-item active">{{ $photo->title }}</li>
        </ol>
    </nav>

   <div class="photos-content">
   <div class="photos-nav">
   <div class="photos-nav-edit">
    @if (isAdmin())
        <a href="/admin/photos/edit/{{ $photo->id }}">Редактировать</a>
       <a href="/admin/photos/delete/{{ $photo->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
    @endif

    @if ($photo->user->id == getUser('id') && ! isAdmin())
        <a href="/photos/edit/{{ $photo->id }}">Редактировать</a>
        <a href="/photos/delete/{{ $photo->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
    @endif
       </div>
       </div>
   
       
        @foreach ($photo->files as $file)
            <a href="/uploads/photos/{{ $file->hash }}" class="gallery" data-group="{{ $photo->id }}"><img  class="img-fluid" src="/uploads/photos/{{ $file->hash }}" alt="image"></a>
           
        @endforeach

       <div class="photos-text"> @if ($photo->text)
            {!! bbCode($photo->text) !!}
        @endif</div>
       

        <div class="js-rating">Рейтинг:
            @unless (getUser('id') == $photo->user_id)
                <a class="red" class="post-rating-down<?= $photo->vote == '-' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $photo->id }}" data-type="{{ App\Models\Photo::class }}" data-vote="-" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-down"></i></a>
            @endunless
            <span>{!! formatNum($photo->rating) !!}</span>
            @unless (getUser('id') == $photo->user_id)
                <a class="post-rating-up<?= $photo->vote == '+' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $photo->id }}" data-type="{{ App\Models\Photo::class }}" data-vote="+" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-up"></i></a>
            @endunless
        </div>

       <div class="photos-bottom">
       <span>Добавлено: {!! profile($photo->user) !!} ({{ dateFixed($photo->created_at) }})</span>
        <span><a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment" aria-hidden="true"></i></a> <span class="comme">({{ $photo->count_comments }})</span> 
        <a href="/photos/end/{{ $photo->id }}"><i class="fa fa-chevron-circle-right" aria-hidden="true"></i></a></span>
        </div>
</div>
    <?php $nav = photoNavigation($photo->id); ?>

    @if ($nav['next'] || $nav['prev'])
        <div class="photos-pagis">
            @if ($nav['next'])
                <a href="/photos/{{ $nav['next'] }}"><i class="fa fa-arrow-circle-left" aria-hidden="true"></i></a> &nbsp;
            @endif

            @if ($nav['prev'])
                &nbsp; <a href="/photos/{{ $nav['prev'] }}"><i class="fa fa-arrow-circle-right" aria-hidden="true"></i></a>
            @endif
        </div>
    @endif
@stop
