@extends('layout')

@section('title')
    Анкета пользователя {{ $user->login }}
@stop

@section('content')

    <div class="avatar-box">
        <div class="avatar-box_image">{!! userAvatar($user) !!}</div>
        <h1 class="avatar-box_login">
            {{ $user->login }} <small>#{{ $user->id }}</small>
        </h1>
    </div>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Анкета {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($user->level === 'pended')
        <b><span style="color:#ff0000">Внимание, аккаунт требует подтверждение регистрации!</span></b><br>
    @endif

    @if ($user->level === 'banned' && $user->timeban > SITETIME)
        <div class="form">
            <b><span style="color:#ff0000">Внимание, данный пользователь заблокирован!</span></b><br>
            До окончания бана: {{ formatTime($user->timeban - SITETIME) }}<br>

            @if ($user->lastBan->id)
                Причина: {!! bbCode($user->lastBan->reason) !!}<br>
            @endif
        </div>
    @endif

    @if (in_array($user->level, $adminGroups))
        <div class="top-info">Должность: <b>{{ userLevel($user->level) }}</b></div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
               <div class="users">
               <ul>
               <li>
                Статус: <a href="/statusfaq">{!! userStatus($user) !!}</a></li>

               <li>
                {!! $user->getGender() !!}
                Пол:
                {{  ($user->gender === 'male') ? 'Мужской' : 'Женский' }}
                </li>

               <li>
                Логин: {{ $user->login }}
                </li>

                @if (!empty($user->name))
                   <li>
                    Имя: {{ $user->name }}
                    </li>
                @endif
                

                @if (!empty($user->country))
                   <li>
                    Страна: {{ $user->country }}
                    </li>
                @endif
                

                @if (!empty($user->city))
                    <li>
                    Откуда: {{ $user->city }}
                    </li>
                @endif
                
                
                @if (!empty($user->birthday))
                   <li>
                    Дата рождения: {{ $user->birthday }}
                    </li>
                @endif
                

                @if (!empty($user->icq))
                   <li>
                    ICQ: {{ $user->icq }}
                    </li>
                @endif

                @if (!empty($user->skype))
                   <li>
                    Skype: {{ $user->skype }}
                    </li>
                @endif

                <li>Всего посeщений: {{ $user->visits }}</li>
                <li>Сообщений на форуме: {{ $user->allforum }}</li>
                <li>Сообщений в гостевой: {{ $user->allguest }}</li>
                <li>Комментариев: {{ $user->allcomments }}</li>
                <li>Актив: {{ plural($user->point, setting('scorename')) }}</li>
                <li>Денег: {{ plural($user->money, setting('moneyname')) }}</li>

                @if ($user->themes)
                    <li>Используемый скин: {{ $user->themes }}</li>
                @endif
                <li>Дата регистрации: {{ dateFixed($user->created_at, 'd.m.Y') }}</li>

                @if ($invite)
                    <li>Зарегистрирован по приглашению: {!! profile($invite->user) !!}</li>
                @endif

                <li>Последний визит: {{ dateFixed($user->updated_at) }}</li>
                 </ul>
                 
                <div class="ratings">
                <div class="ratings-top">
                <a href="/ratings/{{ $user->login }}">Репутация: <b>{!! formatNum($user->rating) !!}</b> (+{{  $user->posrating }}/-{{  $user->negrating }})</a>
                </div>
                
                <div class="rating-bottom">
                @if (getUser() && getUser('login') != $user->login)
                   <a class="minus" href="/users/{{ $user->login }}/rating?vote=minus">Минус <i class="fa fa-thumbs-down"></i></a>
                    <a class="plus" href="/users/{{ $user->login }}/rating?vote=plus"><i class="fa fa-thumbs-up"></i> Плюс</a>
                    
                @endif
                </div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
               <div class="top-img">
                @if (!empty($user->picture) && file_exists(UPLOADS . '/pictures/'.$user->picture))
                    <a class="gallery" href="/uploads/pictures/{{ $user->picture }}">
                        {!! resizeImage('/uploads/pictures/' . $user->picture, ['alt' => $user->login, 'class' => 'float-right img-fluid rounded']) !!}</a>
                @else
                    <img src="/assets/img/images/photo.jpg" alt="Фото" class="float-right img-fluid rounded">
                @endif
                </div>
            </div>
            <div class="col-md-12">
               <div class="user-nav">
                @if (!empty($user->info))
                    <div class="o-sebe"><b>О себе</b>:<br>{!! bbCode($user->info) !!}</div>
                @endif
                <div class="user-main-link">
                <span><a href="/forums/active/topics?user={{ $user->login }}">Форум</a>
                <a href="/forums/active/posts?user={{ $user->login }}">Сообщ.</a> 
                <a href="/downs/active/files?user={{ $user->login }}">Загрузки</a>
                <a href="/downs/active/comments?user={{ $user->login }}">комм.</a></span>
                
                <span>
                <a href="/blogs/active/articles?user={{ $user->login }}">Блоги</a>
                <a href="/blogs/active/comments?user={{ $user->login }}">комм.</a>
                <a href="/photos/albums/{{ $user->login }}">Галерея</a>
                <a href="/photos/comments/{{ $user->login }}">комм.</a>
                </span>
                </div>
                </div>
            </div>
        </div>
    </div>

    @if (isAdmin())
    <div class="zametka">
        <i class="fa fa-thumbtack"></i> <b>Заметка:</b> (<a href="/users/{{ $user->login }}/note">Изменить</a>)<br>

        @if (! empty($user->note->text))
            {!! bbCode($user->note->text) !!}<br>
            Изменено: {!! profile($user->note->editUser) !!} ({{ dateFixed($user->note->updated_at) }})<br>
        @else
            Записей еще нет!<br>
        @endif

        </div>
    @endif

    <div class="users-bottom-navi">
       <ul>
       <li>
       <a href="/walls/{{ $user->login }}"> <i class="fa fa-sticky-note"></i> Стена сообщений <span>
           ({{ userWall($user) }})
       </span></a> 
        </li>

        @if ($user->login != getUser('login'))
           <li class="cont">
            <i class="fa fa-address-book"></i> Добавить в
            <a href="/contacts?act=add&amp;user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}">контакт</a>
            <a href="/ignores?act=add&amp;user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}">игнор</a>
            </li>
            <li>
            <a href="/messages/send?user={{ $user->login }}"><i class="fa fa-envelope"></i> Отправить сообщение</a></li>

             <li>
             <a href="/transfers?user={{ $user->login }}"><i class="fa fa-money-bill-alt"></i>Перечислить денег</a></li>

            @if (!empty($user->site))
                 <li><a href="{{ $user->site }}"><i class="fa fa-home"></i>Перейти на сайт {{ $user->login }}</a></li>
            @endif

            @if (isAdmin('moder'))
                @if (!empty(setting('invite')))
                   <li>
                    <a href="/admin/invitations/send?user={{ $user->login }}&amp;token={{ $_SESSION['token'] }}"><i class="fa fa-ban"></i> Отправить инвайт</a></li>
                @endif
                <li>
            <a href="/admin/bans/edit?user={{ $user->login }}"><i class="fa fa-ban"></i> Бан / Разбан</a>
            </li>
            <li>
            <a href="/banhists/view?user={{ $user->login }}"><i class="fa fa-history"></i> История банов</a></li>
            @endif

            @if (isAdmin('admin'))
               <li>
                <a href="/admin/users/edit?user={{ $user->login }}"><i class="fa fa-wrench"></i> Редактировать</a></li>
            @endif
        @else
         <li><a href="/profile"><i class="fa fa-user-circle"></i>Мой профиль</a></li>
        <li><a href="/accounts"><i class="fa fa-cog"></i> Мои данные</a></li>
         <li><a href="/settings"><i class="fa fa-wrench"></i>Настройки</a></li>
        </ul>
        @endif

    </div>
@stop
