@extends('layout')

@section('title')
    Авторы
@stop

@section('content')

    <h1>Авторы</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Авторы</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="content">
           <div class="block">
            <a href="/blogs/active/articles?user={{ $data->login }}"><img src="/themes/RdesignNew/img/blogs.png" alt="icon">{{ $data->login }} <span>({{ $data->cnt }} cтатей / {{ $data->count_comments }} комм.)</span></a> 
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}

        <div class="vsego-articles">Всего пользователей: <b>{{ $page->total }}</b></div>
    @else
        {!! showError('Статей еще нет!') !!}
    @endif
@stop
