@extends('layout')

@section('title')
    Блоги - Новые статьи (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Новые статьи</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Новые статьи</li>
        </ol>
    </nav>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)
           <div class="content">
            <div class="block">
                <a href="/articles/{{ $data->id }}"><img src="/themes/RdesignNew/img/new.png" alt="icon">{{ $data->title }} <span>{!! ($data->rating) !!}</span></a> 
            </div>
            </div>
            <div class="articles-end">
               <span>Категория: <a href="/blogs/{{ $data->category_id }}">{{ $data->category->name }}</a><br>
               Добавил: {!! profile($data->user) !!}  
               </span>
                <span class="right">
                ({{  dateFixed($data->created_at) }}) <br>
                <i class="fa fa-eye" aria-hidden="true"> {{ $data->visits }}</i></span>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
@stop
