@extends('layout')

@section('title')
    Топ статей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Топ статей</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>
            <li class="breadcrumb-item active">Топ статей</li>
        </ol>
    </nav>

    Сортировать:

    <?php $active = ($order === 'visits') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=visits" class="badge badge-{{ $active }}">Просмотры</a>

    <?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=rated" class="badge badge-{{ $active }}">Оценки</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/blogs/top?sort=comments" class="badge badge-{{ $active }}">Комментарии</a>
    <hr>

    @if ($blogs->isNotEmpty())
        @foreach ($blogs as $data)

           <div class="content">
            <div class="block">
               <a href="/articles/{{ $data->id }}"><img src="/themes/RdesignNew/img/top-star.png" alt="icon">{{ $data->title }} <span>{!! ($data->rating) !!}
               </span>
               </a>
            </div>
            </div>
             <div class="articles-end">
               <span>Автор: {!! profile($data->user) !!} <br>
                Категория: <a href="/blogs/{{ $data->category_id }}">{{ $data->name }}</a></span>
                <span class="center"><i class="fa fa-eye" aria-hidden="true"> {{ $data->visits }}</i></span>
                <span class="right">
                <a href="/articles/comments/{{ $data->id }}"><i class="fa fa-comment" aria-hidden="true"> {{ $data->count_comments }}</i></a> 
                <!--<a href="/articles/end/{{ $data->id }}">&raquo;</a>-->
                </span>
               
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных статей еще нет!') !!}
    @endif
@stop
