@extends('layout')

@section('title')
    {{ $blog->title }}
@stop

@section('keywords')
    {{ $blog->tags }}
@stop

@section('description')
    {{ stripString($blog->text) }}
@stop

@section('content')


    <h1>{{ $blog->title }} <small>(Оценка: {!! formatNum($blog->rating) !!})</small></h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/blogs">Блоги</a></li>

            @if ($blog->category->parent->id)
                <li class="breadcrumb-item"><a href="/blogs/{{ $blog->category->parent->id }}">{{ $blog->category->parent->name }}</a></li>
            @endif
            <li class="breadcrumb-item"><a href="/blogs/{{ $blog->category_id }}">{{ $blog->category->name }}</a></li>
            <li class="breadcrumb-item active">{{ $blog->title }}</li>
        </ol>
    </nav>

    @if ($blog->user->id == getUser('id'))
        <div class="dob">
            <a class="btn btn-success" href="/articles/edit/{{ $blog->id }}">Изменить</a>
        </div>
    @endif
  
  
   <div class="blogs-article-views">
   <div class="blogs-article-top">
    <a href="/articles/print/{{ $blog->id }}">Печать</a>
    <a href="/articles/rss/{{ $blog->id }}">RSS-лента</a>

    @if (isAdmin())
        <a href="/admin/articles/edit/{{ $blog->id }}">Редактировать</a>
        <a href="/admin/articles/move/{{ $blog->id }}">Перенести</a>
        <a href="/admin/articles/delete/{{ $blog->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы действительно хотите удалить данную статью?')">Удалить</a>
    @endif
    </div>

   <div class="blogs-article-articles">
    {!! $blog->text !!}
    </div>

   <div class="blogs-article-paginate">
    {!! pagination($page) !!}
</div>
   
   <div class="blogs-authors-articles">
       <span class="left"> Автор статьи: {!! profile($blog->user) !!} <br> ({{ dateFixed($blog->created_at) }})</span>
       <span class="right">
       <div class="blogs-authors-ratings">
    <div class="js-rating">Рейтинг:
        @unless (getUser('id') == $blog->user_id)
            <a class="red<?= $blog->vote == '-' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $blog->id }}" data-type="{{ App\Models\Blog::class }}" data-vote="-" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-down"></i></a>
        @endunless
        <span>{!! formatNum($blog->rating) !!}</span>
        @unless (getUser('id') == $blog->user_id)
            <a class="post-rating-up<?= $blog->vote == '+' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $blog->id }}" data-type="{{ App\Models\Blog::class }}" data-vote="+" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-up"></i></a>
        @endunless
    </div>
    </div>
    </span>
   </div>
   <div class="blogs-views-bottom">
       <span><i class="fa fa-tag"></i> {!! $tags !!}</span>
       <span><i class="fa fa-eye"> {{ $blog->visits }}</i></span>
       <span><a href="/articles/comments/{{ $blog->id }}"><i class="fa fa-comment"></i> {{  $blog->count_comments }}</a>
       </span>
   </div>
    </div>
@stop
