@extends('layout')

@section('title')
    Форум - Список тем {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Список тем {{ $user->login }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Список тем {{ $user->login }}</li>
        </ol>
    </nav>

    @foreach ($topics as $data)
       <div class="content">
        <div class="block">
            <a href="/topics/{{ $data->id }}"><img src="/themes/RdesignNew/img/main.png" alt="icon">{{ $data->title }} <span>({{ $data->count_posts }})</span></a>
        </div>
</div>

           <div class="end-auth">
            <span>Автор: {{ $data->user->login }}</span>
            <span>Посл.: {{ $data->lastPost->user->login }} ({{ dateFixed($data->lastPost->created_at) }})</span>
          </div>
          
            <div class="podforum">
               <span>Форум: <a href="/forums/{{ $data->forum->id }}">{{ $data->forum->title }}</a></span>
           <span class="pags"> {!! $data->pagination() !!}</span>
            </div>
           
    @endforeach

    {!! pagination($page) !!}
@stop
