@extends('layout')

@section('title')
    Топ популярных тем
@stop

@section('content')

    <h1>Топ популярных тем</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных тем</li>
        </ol>
    </nav>

    @if ($topics->isNotEmpty())
        @foreach ($topics as $data)
            <div class="content">
                <div class="block">
                <a href="/topics/{{ $data->id }}"><img src="/themes/RdesignNew/img/top-star.png" alt="icon">{{ $data->title }} <span>({{ $data->count_posts }})</span>
                </a> 
                </div>
</div>
            
               <div class="end-auth">
                <span>Автор: {{ $data->user->login }}</span>
                <span>
                Сообщение: {{ $data->lastPost->user->login }} ({{ dateFixed($data->lastPost->created_at) }})</span>
                </div>
            <div class="podforum"><span class="pags">{!! $data->pagination() !!}</span></div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Созданных тем еще нет!') !!}
    @endif
@stop
