@extends('layout')

@section('title')
    Топ популярных постов
@stop

@section('content')
    <h1>Топ популярных постов</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных постов</li>
        </ol>
    </nav>

    @if ($posts->isNotEmpty())
        @foreach ($posts as $data)
           <div class="new-comment">
            <div class="new-comment-nav">
                <a class="new-posts-link" href="/topics/{{ $data->topic_id }}/{{ $data->id }}"><i class="fa fa-comment"></i>{{ $data->topic->title }}
                <span>(Рейтинг: {{ $data->rating }})</span>
                </a>
               
            </div>
            
               <div class="new-comment-comment-text">{!! bbCode($data->text) !!}</div>
              
                
                <div class="new-comment-bottom">
                <span> Написал: {{ $data->user->login }} {!! userOnline($data->user) !!} ({{ dateFixed($data->created_at) }})
                        </span>
                         
                          <?php if (isAdmin()): ?>
                    <span class="data">({{ $data->brow }}, {{ $data->ip }})</span>
                <?php endif; ?>
                         
                          </div>
               
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Сообщений еще нет!') !!}
    @endif
@stop
