@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')

  

    <h1>{{ $category->name }}</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/loads/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/loads/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="loads-top">
   <span>
    Сортировать:

    <?php $active = ($order === 'created_at') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=time" class="badge badge-{{ $active }}">По дате</a>

    <?php $active = ($order === 'loads') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=loads" class="badge badge-{{ $active }}">Скачивания</a>

    <?php $active = ($order === 'rated') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=rated" class="badge badge-{{ $active }}">Оценки</a>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <a href="/loads/{{ $category->id }}?sort=comments" class="badge badge-{{ $active }}">Комментарии</a>
    </span>
   </div>

    @if ($category->children->isNotEmpty() && $page->current == 1)
        <div class="act">
            @foreach ($category->children as $child)
                <div class="b">
                    <i class="fa fa-folder-open"></i>
                    <b><a href="/loads/{{ $child->id }}">{{ $child->name }}</a></b> ({{ $child->count_downs }})</div>
            @endforeach
        </div>
        
    @endif

  @if (getUser() && ! $category->closed)
   <div class="dob">
            <a class="btn btn-success" href="/downs/create?cid={{ $category->id }}">Добавить файл</a>
        </div>
         @endif
         
    @if ($downs->isNotEmpty())
        @foreach ($downs as $data)
            <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

            <div class="loads-nav">
               <div class="block">
                <a href="/downs/{{ $data->id }}"><img src="/themes/RdesignNew/img/down-arrow.png" alt="loads-img">{{ $data->title }} <span>{{ $rating }}</span></a>
                </div>
            </div>

            <div class="loads-count">
               <span>Скачиваний: {{ $data->loads }}</span>
               <span>
               <a href="/downs/comments/{{ $data->id }}"><i class="fa fa-comment" aria-hidden="true"> {{ $data->count_comments }}</i></a>
                <!--<a href="/downs/end/{{ $data->id }}"><i class="fa fa-chevron-circle-right" aria-hidden="true"></i></a>-->
                </span>
                
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        @if (! $category->closed)
            {!! showError('В данной категории еще нет файлов!') !!}
        @endif
    @endif

    @if ($category->closed)
        {!! showError('В данной категории запрещена загрузка файлов!') !!}
    @endif

   <div class="loads-bottom">
    <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    </div>
@stop
