@extends('layout')

@section('title')
    Загрузки - Новые файлы (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Новые файлы</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item active">Новые файлы</li>
        </ol>
    </nav>

    @if ($downs->isNotEmpty())
        @foreach ($downs as $down)
            <?php $rating = $down->rated ? round($down->rating / $down->rated, 1) : 0; ?>
            <div class="loads-nav">
            <div class="block">
                <a href="/downs/{{ $down->id }}"><img src="/themes/RdesignNew/img/new.png" alt="icon">{{ $down->title }} <span>({{ $rating }})</span></a>
            </div>
           </div>
            <div class="loads-new-comment">
               <span>Категория: <a href="/loads/{{ $down->category->id }}">{{ $down->category->name }}</a></span>
                <span>Скачиваний: {{ $down->loads }}</span>
                <span>Автор: {!! profile($down->user) !!} ({{ dateFixed($down->created_at) }})</span>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных файлов еще нет!') !!}
    @endif
@stop
