@extends('layout')

@section('title')
    История переписки
@stop

@section('content')

    <h1>История переписки</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item"><a href="/messages">Приватные сообщения</a></li>
            <li class="breadcrumb-item active">История переписки</li>
        </ol>
    </nav>

   <div class="messages-top">
   <span class="out"><a href="/messages"><i class="fa fa-envelope"></i> Входящие</a></span>
    <span class="out"><a href="/messages/outbox"><i class="fa fa-paper-plane" aria-hidden="true"></i> Отправленные</a>
    </span>
    </div>
   

    @if ($messages->isNotEmpty())

        @foreach ($messages as $data)
           <div class="post">
            <div class="b">
                <div class="img">{!! userAvatar($data->author) !!}</div>
                <b>{!! profile($data->author) !!}</b> {!! userOnline($data->author) !!}
                <br>
                ({{  dateFixed($data->created_at) }})
            </div>
            <div class="message">{!! bbCode($data->text) !!}</div>
            </div>
        @endforeach

        {!! pagination($page) !!}

    @else
        {!! showError('История переписки отсутствует!') !!}
    @endif

    <br>
    <div class="form">
        <form action="/messages/send?user={{ $user->login }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            <label for="msg">Сообщение:</label>
            <textarea class="form-control markItUp" id="msg" rows="5" name="msg" placeholder="Текст сообщения" required></textarea>

            @if (getUser('point') < setting('privatprotect'))
                {!! view('app/_captcha') !!}
            @endif

            <button class="btn btn-primary">Быстрый ответ</button></form></div><br>

   <div class="center-text"><span>Всего писем: <b>{{ $page->total }}</b></span></div>
    
<div class="users-bottom-navi">
   <ul>
    <li><a href="/searchusers"><i class="fa fa-search"></i> Поиск контактов</a></li>
    <li><a href="/messages/send"><i class="fa fa-envelope"></i>Написать письмо</a></li>
     <li><a href="/contacts"><i class="fa fa-address-book"></i>Контакт</a></li>
     <li><a href="/ignores"><i class="fa fa-ban" aria-hidden="true"></i>Игнор</a></li>
     </ul>
     </div>
@stop
