@extends('layout')

@section('title')
    Отправленные сообщения
@stop

@section('content')

    <h1>Отправленные сообщения</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item active">Отправленные</li>
        </ol>
    </nav>

   <div class="messages-top">
   <span class="out"><a href="/messages"><i class="fa fa-envelope"></i>  Входящие ({{ $page->totalInbox }})</a></span>
    <span><i class="fa fa-paper-plane" aria-hidden="true"></i> Отправленные ({{ $page->total }})</span>
    </div>
    

    @if ($messages->isNotEmpty())
        <form action="/messages/delete?type=outbox&amp;page={{ $page->current }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">
            <div class="form-privat">
                <input type="checkbox" id="all" onchange="var o=this.form.elements;for(var i=0;i&lt;o.length;i++)o[i].checked=this.checked"> <b><label for="all">Отметить все</label></b>
            </div>

            @foreach ($messages as $data)
               <div class="post"> 
                <div class="b">
                    <div class="img">{!! userAvatar($data->recipient) !!}</div>
                    <b>{!! profile($data->recipient) !!}</b>  ({{ dateFixed($data->created_at) }})<br>
                    {!! userStatus($data->recipient) !!} {!! userOnline($data->recipient) !!}</div>

                <div class="message">{!! bbCode($data->text) !!}</div>
                   <div class="edit-block">
                    <input type="checkbox" name="del[]" value="{{ $data->id }}">
                    <a class="out-link" href="/messages/send?user={{ $data->recipient->login }}">Написать еще</a>
                    <a class="out-link" href="/messages/history?user={{ $data->recipient->login }}">История</a>
                    </div>
                    </div> 
            @endforeach

           <div class="dels"> <button class="btn btn-sm btn-danger">Удалить выбранное</button></div>
           
        </form>

        {!! pagination($page) !!}

       <div class="center-text">
           <span>Всего писем: <b>{{ $page->total }}</b></span>
           <span>Объем ящика: <b>{{ setting('limitmail') }}</b></span>
       </div>
        
        <div class="users-bottom-navi">
        <ul>

        <li><a href="/messages/clear?type=outbox&amp;token={{ $_SESSION['token'] }}"><i class="fa fa-times"></i> Очистить ящик</a></li>
    @else
        {!! showError('Отправленных писем еще нет!') !!}
    @endif

    <li><a href="/searchusers"> <i class="fa fa-search"></i>Поиск контактов</a></li>
    <li><a href="/messages/send"><i class="fa fa-envelope"></i> Написать письмо</a></li>
            <li><a href="/contacts"><i class="fa fa-address-book"></i> Контакт</a></li>
    <li><a href="/ignores"><i class="fa fa-ban" aria-hidden="true"></i>Игнор</a>
    </li>
    </ul>
    </div>
@stop
