@extends('layout')

@section('title')
    Последние комментарии
@stop

@section('content')

    <h1>Последние комментарии</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/news">Новости сайта</a></li>
            <li class="breadcrumb-item active">Последние комментарии</li>
        </ol>
    </nav>

    @if ($comments->isNotEmpty())
        @foreach ($comments as $data)
           <div class="news-comment">
            <div class="news-comment-nav">
                 <a class="news-posts-link" href="/news/comment/{{ $data->relate_id }}/{{ $data->id }}"><i class="fa fa-comment"></i>{{ $data->title }} <span>({{ $data->count_comments }})</span></a> 
            </div>
            <div class="news-comment-comment-text">{!! bbCode($data->text) !!}</div>

            <div class="news-comment-bottom">
              <span> Написал: {!! profile($data->user) !!} <br>({{ dateFixed($data->created_at) }})</span>
              <span> @if (isAdmin())
                    ({{ $data->brow }}, {{ $data->ip }})
                @endif</span>
               

            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Комментарии не найдены!') !!}
    @endif
@stop
