@extends('layout')

@section('title')
    Новости сайта (Стр. {{ $page->current}})
@stop

@section('content')

    <h1>Новости сайта</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Новости сайта</li>

            @if (isAdmin('moder'))
                <li class="breadcrumb-item"><a href="/admin/news">Управление</a></li>
            @endif
        </ol>
    </nav>

    @if ($news->isNotEmpty())
        @foreach ($news as $data)
           <div class="news-comment">
            <div class="news-comment-nav">
                <a class="news-posts-link" href="/news/{{ $data->id }}"><i class="fa fa-file-alt fa-lg text-muted"></i> {{ $data->title }} <span>({{ dateFixed($data->created_at) }})</span></a>
            </div>

            @if ($data->image)
                <div class="img">
                    <a href="/uploads/news/{{ $data->image }}">{!! resizeImage('/uploads/news/' . $data->image, ['size' => 100, 'alt' => $data->title]) !!}</a>
                </div>
            @endif

            <div class="news-comment-comment-text">{!! bbCode($data->shortText()) !!}</div>
            <div class="news-comment-bottom">
               <span> Добавлено: {!! profile($data->user) !!}</span>
               <span class="right">
               <a href="/news/comments/{{ $data->id }}"><i class="fa fa-comment"> {{ $data->count_comments }}</i></a>
                <!--<a href="/news/end/{{ $data->id }}">&raquo;</a>-->
                </span>
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Новостей еще нет!') !!}
    @endif

   <div class="news-end">
     <span><a href="/news/rss"><i class="fa fa-rss"></i> RSS подписка</a></span>
      <span><a href="/news/allcomments"><i class="fa fa-comment"></i> Комментарии</a></span>
    </div>
@stop
