@extends('layout')

@section('title')
    Альбомы пользователей (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Альбомы пользователей</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Альбомы пользователей</li>
        </ol>
    </nav>

    @if ($albums->isNotEmpty())
        @foreach ($albums as $data)

           <div class="content">
           <div class="block">
            <a href="/photos/albums/{{ $data->login }}"><img src="/themes/RdesignNew/img/album.png" alt="icon">{{ $data->login }}
            <span>({{ $data->cnt }} фото / {{ $data->count_comments }} комм.)</span></a>
            </div>
</div>

        @endforeach

        {!! pagination($page) !!}
        <div class="center-text"><span>Всего альбомов: <b>{{ $page->total }}</b></span></div>

       
    @else
        {!! showError('Альбомов еще нет!') !!}
    @endif
@stop
