@extends('layout')

@section('title')
    История голосований (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>История голосований</h1>

    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item active">История голосований</li>
        </ol>
    </nav>

    @if ($votes->isNotEmpty())
        @foreach ($votes as $vote)
            <div class="votes-block">
                <div class="votes-link-block"> <a href="/votes/history/{{ $vote->id }}"><i class="fa fa-briefcase"></i>{{ $vote->title }}</a></div>
               
           
            <div class="votes-bottom">
               <span> @if ($vote->topic->id)
                    Тема: <a href="/topics/{{ $vote->topic->id }}">{{ $vote->topic->title }}</a>
                @endif</span>
                <span>Создано: {{ dateFixed($vote->created_at) }}</span>
               <span>Всего голосов: {{ $vote->count }}</span>
            </div>
        </div>
        @endforeach

        {!! pagination($page) !!}
    @else
        {!! showError('Голосований в архиве еще нет!') !!}
    @endif
@stop
